#version 330
uniform samplerBuffer polygons;
uniform int polygonsBufferSize;
uniform float mapScale;
uniform float mapOffset;
uniform float maxDistance;

in vec4 worldPosition;
in vec2 texcoord_out;
out vec4 fragColor;

float distance_here( vec2 position, vec2 a, vec2 b )
{
	vec2 edgeDirection = vec2(b-a);
	float edgeLength = length(edgeDirection);
	edgeDirection *= (1.0 / edgeLength);

	vec2 delta = position - a;
	float projection = dot(delta, edgeDirection);
	projection = clamp(projection, 0.0, edgeLength);
	vec2 positionOnEdge = a + projection * edgeDirection;

	return length(position - positionOnEdge);
}

void main(void)
{
	int ind = 0;

	vec2 prev;
	vec2 next;
	float minDistance = maxDistance;
	bool inside = false;

	vec2 posHere = worldPosition.xz;

	while ( ind < polygonsBufferSize )
	{
		prev.x = texelFetch(polygons, ind++).r;
		prev.y = texelFetch(polygons, ind++).r;
		next.x = texelFetch(polygons, ind++).r;
		next.y = texelFetch(polygons, ind++).r;

		float distanceHere = distance_here(posHere, prev, next);
		minDistance = min( minDistance, distanceHere );
	}

	minDistance = clamp(minDistance / maxDistance, 0.0, 1.0);
	// vec2 foo = posHere / mapScale.x;
	fragColor.rgba = vec4(minDistance, minDistance, minDistance, 1.0);
}



