uniform sampler2D shadowTexture;
uniform float shadowFov;
uniform float shadowAlpha;
uniform float shadowDepthRange;
uniform float shadowDepthBias;
uniform float shadowDepthMaxBias;
uniform float shadowDepthBiasConstant;
uniform bool shadows;

uniform mat4 worldToLight[4];
uniform vec4 cascadeNear;
uniform vec4 cascadeFar;
uniform bool cascades;

vec4 getCascadeWeights(float depth, vec4 splitNear, vec4 splitFar)
{
	vec4 near = step(splitNear, vec4(depth));
	vec4 far = step(depth, splitFar);

	return near * far;
}

vec4 getCascadeViewport(vec4 weights)
{
	vec2 off = vec2(0,0.0) * weights.x +
		vec2(0.5,0.0) * weights.y +
		vec2(0.0,0.5) * weights.z +
		vec2(0.5,0.5) * weights.w;
	return vec4(off, 0.5, 0.5);
}

vec2 VogelDiskSample(int sampleIndex, int samplesCount, float phi )
{
	const float goldenAngle = 2.4;
	float r = sqrt(sampleIndex+0.5) / sqrt(samplesCount);
	float theta = sampleIndex * goldenAngle + phi;

	float sine, cosine;
	sine = sin(theta);
	cosine = cos(theta);

	return vec2(r*cosine, r*sine);
}

float InterleavedGradientNoise(vec2 screenPos)
{
	const vec3 magic = vec3(0.06711056,0.00583715,52.9829189);
	return fract(magic.z * fract(dot(screenPos, magic.xy)));
}


float calculate_shadow_illumination( vec4 worldPosition, float NdL )
{
	float illuminated = NdL;
	if ( shadows &&
			worldPosition.x > 0.0 && worldPosition.z < 16000.0 &&
			worldPosition.z > 0.0 && worldPosition.z < 16000.0 )
	{
		float shadowSampleOffset = 0.5;
		bool doShadow = true;
		vec4 shadowCoord;
		if ( cascades )
		{
			vec4 cascadeWeights = getCascadeWeights( viewPosition.z, cascadeNear, cascadeFar );
			mat4 wTL = worldToLight[0] * cascadeWeights.x +
				worldToLight[1] * cascadeWeights.y +
				worldToLight[2] * cascadeWeights.z +
				worldToLight[3] * cascadeWeights.w;
			shadowCoord = (wTL * worldPosition );

			vec4 offsetPosition = wTL * (worldPosition + vec4(1.0,0.0,0.0,0.0));
			shadowSampleOffset = length(offsetPosition.xy - shadowCoord.xy);
			shadowSampleOffset *= 0.5;

			doShadow = length(cascadeWeights) > 0.0 &&
				( shadowCoord.s >= 0.0 &&
					shadowCoord.s <= 1.0 &&
					shadowCoord.t >= 0.0 &&
					shadowCoord.t <= 1.0 );
			vec4 viewport = getCascadeViewport(cascadeWeights);
			shadowCoord.xy = vec2(shadowCoord.xy * viewport.zw + viewport.xy);
			shadowCoord.w = 1.0;

			// shadowSampleOffsetFactor = cascadeWeights.x * 1.0 +
			// 	cascadeWeights.y * 0.2 +
			// 	cascadeWeights.z * 0.008 +
			// 	cascadeWeights.w * 0.002;
			// color.rgb = mix(color.rgb, cascadeWeights.rgb, 0.8);
			// color.rb = mix(color.rb, vec2(1.0), cascadeWeights.a * 0.8);
			// fragColor[0].rgba = vec4(cascadeWeights.rgb,1.0);
			// return;
		}
		else
		{
			shadowCoord = worldToLight[0] * (worldPosition);
			doShadow = ( shadowCoord.s >= 0.0 &&
					shadowCoord.s <= 1.0 &&
					shadowCoord.t >= 0.0 &&
					shadowCoord.t <= 1.0 );

			vec4 offsetPosition = worldToLight[0] * (worldPosition + vec4(1.0,0.0,0.0,0.0));
			shadowSampleOffset = length(offsetPosition.xy - shadowCoord.xy);
		}

		if ( doShadow )
		{
			float biasSlopeAmt = sqrt( 1.0 - (NdL * NdL) ) / NdL;
			float shadowDepthBiasFoo = shadowDepthBias + 0.0002;
			float bias = shadowDepthBiasFoo * biasSlopeAmt  + shadowDepthBiasConstant;
			bias = clamp(bias, 0, shadowDepthMaxBias);
			bias += shadowDepthRange/10000000.0;
			vec4 shadowCoordinateWdivide = shadowCoord / shadowCoord.w ;
			shadowCoordinateWdivide.z = 1.0 - shadowCoordinateWdivide.z;
			shadowCoordinateWdivide.z -= bias;

			vec3 c_offsets[9];
			for ( int i = 0; i < 9; i++ )
			{
				c_offsets[i] = vec3(
						VogelDiskSample(i, 9,
							InterleavedGradientNoise( worldPosition.xz * 100.0 )
							).xy, 0);
			}

			float lightingHit = 0.0;//texture(shadowTexture, shadowCoordinateWdivide.xyz);
			float avgBlockerDepth = 0.0;
			float numBlockers = 0.0;
			// for ( int i = 0; i < 9; i++ )
			// {
			// 	vec3 thisSamplePosition = shadowCoordinateWdivide.xyz +
			// 		(1.0 * shadowSampleOffset * c_offsets[i]);
			// 	float depth = texture( shadowTexture, thisSamplePosition.xy ).r;
			// 	if ( depth < shadowCoordinateWdivide.z)
			// 	{
			// 		numBlockers += 1.0;
			// 		float depth = shadowCoordinateWdivide.z - depth;
			// 		avgBlockerDepth += depth;
			// 	}
			// }
			// if ( numBlockers > 0.0 )
			{
				// avgBlockerDepth = avgBlockerDepth / numBlockers;
				avgBlockerDepth = 0.0050;
				for ( int i = 0; i < 9; i++ )
				{
					vec3 thisSamplePosition = shadowCoordinateWdivide.xyz +
						(50.0 * avgBlockerDepth * shadowSampleOffset * c_offsets[i]);
					// float f = texture(shadowTexture, thisSamplePosition, 0.0);
					if ( texture(shadowTexture, thisSamplePosition.xy).r < shadowCoordinateWdivide.z)
					{
						lightingHit += 1.0 / 9.0; //1.0 / 9.0;
					}
				}
				illuminated *= (1.0-lightingHit); //mix( 1.0, lookup, shadowAlpha );
			}
		}
		else
		{
			// color.rgb = vec3(0);
		}
	}
	return illuminated;
}
