#version 330
uniform samplerBuffer polygons;
uniform int polygonsBufferSize;
uniform float mapScale;
uniform float mapOffset;
uniform float maxDistance;

in vec4 worldPosition;
in vec2 texcoord_out;
out vec4 fragColor;

bool is_inside( vec2 position, vec2 a, vec2 b )
{
	vec2 direction = vec2(b-a);

	direction = normalize( direction );
	vec2 normal = vec2( direction.y, -direction.x );

	vec2 delta = normalize( position - a );

	return dot(delta,normal) <= 0;
}

float distance_here( vec2 position, vec2 a, vec2 b )
{
	vec2 edgeDirection = vec2(b-a);
	float edgeLength = length(edgeDirection);
	edgeDirection *= (1.0 / edgeLength);

	vec2 delta = position - a;
	float projection = dot(delta, edgeDirection);
	projection = clamp(projection, 0.0, edgeLength);
	vec2 positionOnEdge = a + projection * edgeDirection;

	return length(position - positionOnEdge);
}

void main(void)
{
	int ind = 0;

	vec2 prev;
	vec2 next;
	float minDistance = maxDistance;
	bool inside = false;

	vec2 posHere = texcoord_out * mapScale + mapOffset;

	prev.x = texelFetch(polygons, ind++).r;
	prev.y = texelFetch(polygons, ind++).r;

	while ( ind < polygonsBufferSize )
	// while ( ind <= 10 )
	{
		float value = texelFetch(polygons, ind++).r;
		if ( value < 0.0 )
		{
			if ( inside )
				minDistance = 0.0;

			if ( ind < polygonsBufferSize )
			{
				prev.x = texelFetch(polygons, ind++).r;
				prev.y = texelFetch(polygons, ind++).r;
				inside = true;
			}
		}
		else
		{
			next.x = value;
			next.y = texelFetch(polygons, ind++).r;

			float distanceHere = distance_here(posHere, prev, next);

			// This test isn't working for some reason.  Maybe I have some
			// bad data somewhere in my data set??
			if ( !is_inside(posHere, prev, next) )
				inside = false;

			minDistance = min( minDistance, distanceHere );
			// minDistance = distanceHere;

			prev = next;
		}
	}

	minDistance = minDistance / maxDistance;
	// vec2 foo = posHere / mapScale.x;
	fragColor.rgba = vec4(minDistance, minDistance, minDistance, 1.0);
}


