#version 330
#ifdef TEXTURE
uniform sampler2D textures[8];
in vec2 texcoord_out;
uniform float alphaRef;
#endif // TEXTURE

// in float fogFactor;
uniform float fogDensity;
uniform bool fog;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform bool glow;

// We have the originx and originy values from the rez2D_h include file.
// uniform float rezOriginX;
// uniform float rezOriginY;
uniform float rezDestX;
uniform float rezDestY;

#include "rez2D_h.glsl"

// in vec2 relativePositionInWindow;
in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;

void main(void)
{
	vec4 color = frontColor;
#ifdef TEXTURE
	vec4 textureSample = texture(textures[0], texcoord_out.st);
	if ( textureSample.a < alphaRef )
		discard;
	color *= textureSample;

	vec2 relativePositionInWindow = vec2(
			worldPosition.x - rezOriginX,
			worldPosition.y - rezOriginY
			);
	// need to scale that position from pixels to [0..1]
	relativePositionInWindow.x /= (rezDestX - rezOriginX);
	relativePositionInWindow.y /= (rezDestY - rezOriginY);

	vec2 testPos = relativePositionInWindow.st + vec2(0,0.05);
	vec2 centerAmt = 2.0 * abs(0.5 - testPos);
	// centerAmt.st *= centerAmt.st;
	// float alphaFactor = mix( 0.15, 1.0, centerAmt );
	// color.a *= mix( 0.2, 0.04, max(centerAmt.t, centerAmt.s) );
	float distFromCenter = length(centerAmt) / 1.414f;
	// color.a = mix( 0.03, 1.00, distFromCenter );
	color.a *= mix( 0.03, 0.08, distFromCenter );
	color.a += 0.5 * distFromCenter;

	// color.a *= mix( 0.05, 0.1, max(centerAmt.s, centerAmt.t) );
	// color.a += 0.8 * max(centerAmt.s, centerAmt.t);
	//color.a = centerAmt.t;//mix( 0.2, 0.04, centerAmt.t );

	// color.a = centerAmt;
	// color.rgb = mix(color.rgb, vec3(0), centerAmt);
#endif // TEXTURE


	vec4 glowColor = vec4(0.0);
	vec4 finalColor;
	vec4 finalGlow;
	rez2D( worldPosition, color, glowColor, finalColor, finalGlow );

	// finalColor.r = relativePositionInWindow.t;
	// finalColor.a = 1.0;

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;
}

