#version 330
in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
in vec4 instanceColorAttrib;

uniform vec3 dimensions; // size of input texture, in pixels

in vec4 vertex;
in vec2 texcoord;

out vec2 texcoord_out;
out vec4 tl1;
out vec4 tl2;
out vec4 tl3;

void main(void)
{
	vec4 worldPosition = localToWorldAttrib * vertex;
	gl_Position = viewToProjection * worldToView * worldPosition;
	texcoord_out = texcoord;

	float dx = 1.0 / dimensions.x;
	float dy = 1.0 / dimensions.y;

	vec2 tc = texcoord;
	// tc += 0.5 * vec2(dx,dy);

	tl1 = tc.xxxy + vec4(-dx, 0, dx, -dy);
	tl2 = tc.xxxy + vec4(-dx, 0, dx, 0);
	tl3 = tc.xxxy + vec4(-dx, 0, dx, dy);
}

