#version 330
uniform sampler2D textures[8];
uniform vec3 dimensions; // size of input texture, in pixels
in vec2 texcoord_out;
in vec4 tl1;
in vec4 tl2;
in vec4 tl3;

out vec4 fragColor;

void main(void)
{
	vec2 fp = floor( 3.0 * fract(texcoord_out * dimensions.xy) );

	/*
	 *  tl1:  A B C    E0 E1 E2
	 *  tl2:  D E F    E3 E4 E5
	 *  tl3:  G H I    E6 E7 E8
	 */

	vec4 A = texture(textures[0], tl1.xw);
	vec4 B = texture(textures[0], tl1.yw);
	vec4 C = texture(textures[0], tl1.zw);

	vec4 D = texture(textures[0], tl2.xw);
	vec4 E = texture(textures[0], tl2.yw);
	vec4 F = texture(textures[0], tl2.zw);

	vec4 G = texture(textures[0], tl3.xw);
	vec4 H = texture(textures[0], tl3.yw);
	vec4 I = texture(textures[0], tl3.zw);

	bool eqBD = (B == D);
	bool eqBF = (B == F);
	bool eqHD = (H == D);
	bool eqHF = (H == F);
	bool neqEA = (E != A);
	bool neqEC = (E != C);
	bool neqEG = (E != G);
	bool neqEI = (E != I);

	// vec4 E0 = eqBD ? B : E;
	// vec4 E1 = eqBD && neqEC || eqBF && neqEA ? B : E;
	// vec4 E2 = eqBF ? B : E;
	// vec4 E3 = eqBD && neqEG || eqHD && neqEA ? D : E;
	// vec4 E5 = eqBF && neqEI || eqHF && neqEC ? F : E;
	// vec4 E6 = eqHD ? H : E;
	// vec4 E7 = eqHD && neqEI || eqHF && neqEG ? H : E;
	// vec4 E8 = eqHF ? H : E;

	vec4 E0 = eqBD ? D : E;
	vec4 E1 = (eqBD && neqEC) || (eqBF && neqEA) ? B : E;
	vec4 E2 = eqBF ? F : E;
	vec4 E3 = (eqBD && neqEG) || (eqHD && neqEA) ? D : E;
	vec4 E4 = E;
	vec4 E5 = (eqBF && neqEI) || (eqHF && neqEC) ? F : E;
	vec4 E6 = eqHD ? D : E;
	vec4 E7 = (eqHD && neqEI) || (eqHF && neqEG) ? H : E;
	vec4 E8 = eqHF ? F : E;

	fragColor = (B!=H) && (D!=F) ?
		(fp.y == 0.0 ? (fp.x == 0.0 ? E0 :
						fp.x == 1.0 ? E1 : E2) :
		 (fp.y == 1.0 ? (fp.x == 0.0 ? E3 :
						 fp.x == 1.0 ? E4 : E5) :
						(fp.x == 0.0 ? E6 :
						 fp.x == 1.0 ? E7 : E8)))
		: E;

	// fragColor = (B!=H) && (D!=F) ? (fp.y == 0.0 ? (fp.x == 0.0 ? E0 : fp.x == 1.0 ? E1 : E2) : (fp.y == 1.0 ? (fp.x == 0.0 ? E6 : fp.x == 1.0 ? E : E5) : (fp.x == 0.0 ? E6 : fp.x == 1.0 ? E7 : E8))) : E;

	// fragColor = (B!=H) && (D!=F) ? (fp.y == 0.0 ? (fp.x == 0.0 ? E0 : fp.x == 1.0 ? E1 : E2) : (fp.y == 1.0 ? (fp.x == 0.0 ? E6 : fp.x == 1.0 ? E : E5) : (fp.x == 0.0 ? E6 : fp.x == 1.0 ? E7 : E8))) : E;
	//fragColor.r = fp.y == 0.0 ? 1 : 0.5;
	// fragColor = (B!=H) && (D!=F) ? (fp.y == 0.0 ? (fp.x == 0.0 ? E0 : fp.x == 1.0 ? E1 : E2) : (fp.y == 1.0 ? (fp.x == 0.0 ? E6 : fp.x == 1.0 ? E : E5) : (fp.x == 0.0 ? E6 : fp.x == 1.0 ? E7 : E8))) : E;
	// fragColor = (B!=H) && (D!=F) ? (fp.y == 0.0 ? (fp.x == 0.0 ? E0 : fp.x == 1.0 ? E1 : E2) : (fp.y == 1.0 ? (fp.x == 0.0 ? E3 : fp.x == 1.0 ? E : E5) : (fp.x == 0. ? E6 : fp.x == 1. ? E7 : E8))) : E;
}


