#version 330
uniform bool glow;
uniform vec4 insideColor;
uniform vec4 outsideColor;

in vec4 frontColor;
in vec2 texcoord_out;
out vec4 fragColor[2];

// in vec4 worldPosition;
//#include "rez2DXZ_h.glsl"

void main(void)
{
	float f = smoothstep( 2.0, 1.0, texcoord_out.y );

	vec4 color = frontColor * mix( insideColor, outsideColor, f );

	vec3 glowColor = vec3(0.0);
	if ( glow )
		glowColor = color.rgb;

	vec4 nowGlow = vec4(glowColor, color.a);
	// vec4 finalColor;
	// vec4 finalGlow;
	// rez2D( worldPosition, color, nowGlow, finalColor, finalGlow );

	fragColor[0].rgba = color;
	fragColor[1].rgba = nowGlow;
}

