#version 330
uniform bool fog;
uniform float fogDensity;
// uniform mat4 localToWorld;
in mat4 localToWorldAttrib;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
in vec4 instanceColorAttrib;

uniform vec4 universal_color;

// out float fogFactor;
in vec4 vertex;
in vec3 normal;
in vec4 color;
in vec2 texcoord;

out vec4 frontColor;
out vec4 worldPosition;
out vec4 localPosition;

out vec2 texcoord_out;

uniform samplerBuffer bufferTexture;

out vec3 fragNormal;

void main(void)
{
	float push = 0.0;
	texcoord_out = texcoord;

	float bandwidthValueA = texelFetch(bufferTexture, int(floor(texcoord_out.t)) - 1).r;
	float bandwidthValueB = texelFetch(bufferTexture, int(floor(texcoord_out.t))).r;
	float abmix = fract(texcoord_out.t);
	float bandwidthValue = mix( bandwidthValueA, bandwidthValueB, abmix);
	push = clamp(bandwidthValue * 2.0, 0.0, 0.1);

	frontColor = instanceColorAttrib * color * universal_color;
	localPosition = vertex;
	localPosition.xyz += normal * push;
	worldPosition = localToWorldAttrib * localPosition;
	gl_Position = viewToProjection * worldToView * worldPosition;

	fragNormal = normalize((localToWorldAttrib * vec4(normal,0.0)).xyz);
}

