#version 330

// in float fogFactor;
uniform float fogDensity;
uniform bool fog;
uniform vec3 cameraDirection;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform bool glow;
uniform float globalTime;
uniform vec4 selectedColor;
uniform bool cable;
uniform vec4 tint;
// uniform float bandwidth;

in vec3 fragNormal;

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;
#include "rez3D_h.glsl"

void main(void)
{
	vec4 color = frontColor;// * bandwidthColor;

	float bandwidthValue = clamp(color.r, 0, 1); // we pass our current bandwidth level through in the 'r' channel of our instance color.
	float pulse = color.b;

	vec3 zeroBandwidthColor = vec3(0.06,0.025,0.15);
	vec3 partialBandwidthColor = vec3(0.125,0.22,0.25);
	vec3 fullBandwidthColor = vec3(0.5,0.9,1.0);

	zeroBandwidthColor.rgb = mix( zeroBandwidthColor.rgb, color.rgb, color.a );
	partialBandwidthColor.rgb = mix( partialBandwidthColor.rgb, color.rgb, color.a );
	fullBandwidthColor.rgb = mix( fullBandwidthColor.rgb, color.rgb, color.a );

	color.rgb = zeroBandwidthColor;
	color.a = 1.0;
	vec3 normal = normalize(fragNormal);
	vec3 glowColor = color.rgb;

	// color.rgb = mix( zeroBandwidthColor, fullBandwidthColor, bandwidthValue );

	if ( normal.y > 0.9 )
	{
		float threshhold = mix(1.0, 0.9, bandwidthValue);
		if ( normal.y > threshhold )
			glowColor.rgb = color.rgb = fullBandwidthColor;
		else if ( normal.y > 0.5 )
			glowColor.rgb = color.rgb = partialBandwidthColor;
	}

	if ( normal.y < 0.80 )
	{
		float angle = atan( normal.z, normal.x ) + 3.141593; // force it into [0..twopi]

		// Okay.  Threshhold for each angle is different.
		float angleSlice = (angle * 8) / (3.141593 * 2);
		float angleFrac = fract(angleSlice);
		angleSlice = floor(angleSlice);

		if ( angleFrac > 0.15 && angleFrac < 0.85 )
		{
			// angleSlice is now a value in [0..7].  Let's use different threshholds in
			// each slice.

			float bandwidthValueInThisSlice = 8 * (bandwidthValue - (angleSlice / 8));
			bandwidthValueInThisSlice = clamp(bandwidthValueInThisSlice, 0.0, 1.0);

			float threshhold = mix(0.95, 0.5, bandwidthValueInThisSlice);
			if ( normal.y > threshhold )
				glowColor.rgb = color.rgb = fullBandwidthColor;
			else if ( normal.y > 0.5 )
				glowColor.rgb = color.rgb = partialBandwidthColor;
		}
	}

	color.a = 1.0;
	color.rgb += selectedColor.rgb;

	vec4 finalColor = vec4(color.rgb,1.0);
	float f = sin(mod(globalTime,3.1415)) * 0.2;

	// vec4 finalGlow = vec4(mix(vec3(0),glowColor,f), color.a);
	vec4 finalGlow;
	rez3D( color, f, finalColor, finalGlow );

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;
}



