#version 330
uniform sampler2D key;
uniform sampler2D map;
uniform float texelSize;

out vec4 fragColor;

in vec4 worldPosition;

void main(void)
{
	vec2 keyTexel = worldPosition.xz / texelSize;
	float keySample = 1.0 - texture(key, keyTexel).r;

	// 8 for the pixel separation, 256 because that's how frequently the texture repeats.
	vec2 worldTexel = worldPosition.xz / 2048.0;
	float height = texture(map, worldTexel).r;

	float alpha = clamp( keySample, 0.0, 1.0);
	float beachAlpha = clamp( alpha * 2.0, 0.0, 1.0 ); // [0.0-0.5-1.0] -> [0.0-1.0-1.0]
	float downAlpha = clamp( (alpha-0.5) * 2.0, 0.0, 1.0 ); // [0.0-0.5-1.0] -> [0.0-0.0-1.0]

	// Okay.  So now:
	height = mix( height, -200.0, downAlpha );

	// HACK FOR VISIBILITY IN EXPORTED FILES:  TO REMOVE BEFORE USING THIS FOR REAL!
	// height = height / 400.0;

	fragColor.rgba = vec4(vec3(height), beachAlpha);
}


