#version 330
in vec2 texcoord_out;

in vec3 cameraToFragment;
uniform bool rezEffect;
uniform float rezTime;
uniform float rezDuration;
uniform float rezDistance;
uniform bool rezReverse;
uniform bool glow;
uniform float globalTime;
uniform float fadeDistance;
uniform float alphaDistance;

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;

void main(void)
{
	vec4 color = frontColor;
	vec3 finalColor = color.rgb;
	vec3 glowColor = vec3(0.0);
	if ( glow )
		glowColor = finalColor;

	if ( rezEffect )
	{
		float time = rezTime;//mod(globalTime, 5.0);//rezTime;//mod(rezTime,15.0);

		float totalDistance = rezDistance;
		float totalDuration = rezDuration;
		float rezSpeed = 1.0 * (totalDistance + fadeDistance) / totalDuration;
		float finishTime = (totalDistance + fadeDistance) / rezSpeed;
		float waitTimeAtEnd = totalDuration - finishTime;

		if ( rezReverse )
		{
			time = rezTime - waitTimeAtEnd;
		}

		float rezzedSoFar = time * rezSpeed;
		float distanceHere = texcoord_out.y;

		if ( rezzedSoFar < distanceHere )
			discard;

		float distanceSinceRez = rezzedSoFar - distanceHere;
		if ( distanceSinceRez > alphaDistance )
			discard;
		else
		{
			color.a *= 1.0 - (distanceSinceRez / alphaDistance);
		}
		if ( distanceSinceRez < fadeDistance )
		{
			// float bright = smoothstep( fadeDistance, 0.0, distanceSinceRez );
			float bright = 1.0 - (distanceSinceRez / fadeDistance);
			bright *= bright;
			fragColor[0].rgba = vec4(finalColor, color.a);
			fragColor[1].rgba = vec4(0.05,0.5,1.0, color.a * bright);
			return;
		}
	}

	fragColor[0].rgba = vec4(finalColor, color.a);
	fragColor[1].rgba = vec4(glowColor, color.a);
	// fragColor = vec4(1.0,0.0,0.0,1.0);
}



