#version 330
#ifdef TEXTURE
uniform sampler2D textures[8];
uniform float alphaRef;
#endif // TEXTURE
in vec2 texcoord_out;

// in float fogFactor;
uniform float fogDensity;
uniform bool fog;
uniform float fade = 0.0;
uniform vec4 tint;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform bool glow;
uniform float pathLength;

#ifdef LIT
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];
in vec3 fragNormal;
in vec3 local_normal;
#endif // LIT

in vec4 frontColor;
out vec4 fragColor[3];

in vec4 worldPosition;

#include "rez2D_h.glsl"

void main(void)
{
	vec4 color = frontColor;
#ifdef TEXTURE
	vec4 textureSample = texture(textures[0], texcoord_out.st);
	if ( textureSample.a < alphaRef )
		discard;
	color *= textureSample;
#endif // TEXTURE

#ifdef LIT
	vec3 n = normalize(local_normal);
	// float NdotL = max(dot(n,lightSource[0].position)+1.0,0.0) * 0.5;
    //
	// vec3 ambientPart = color.rgb * lightSource[0].ambient.rgb;
	// vec3 diffusePart = color.rgb * lightSource[0].diffuse.rgb * NdotL;
	// color.rgb = ambientPart + diffusePart;

	vec3 V = normalize(-cameraToFragment);
	float NdV = abs(dot(n,V));

	float fresnel = 1.0 - NdV;//pow(NdV,5.0);

	fresnel = pow(fresnel, 3.0);

	// float fade =

	// little bit of fresnel at the edges, too

	color.a = max(color.a,fresnel);//mix(vec3(1), color.rgb, fresnel);
	// color.rgb = n;

	float edgeAmt = max(
			smoothstep(1.0,0.0,texcoord_out.s),
			smoothstep(4.0,5.0,texcoord_out.s)
			);
	fresnel = max( fresnel, edgeAmt );
	color.rgb = mix(color.rgb, vec3(0.6,0.4,1), fresnel );

	float endFade = 0.0;
	endFade = min(
			smoothstep(5.0,30.0,texcoord_out.t),
			smoothstep(pathLength - 5.0, pathLength-30.0, texcoord_out.t)
			);
	color.a *= endFade;
#endif // LIT

	color.rgb = mix( color.rgb, tint.rgb, tint.a );
	color.a *= (1.0-fade);

	if ( false )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		float fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor,0.0,1.0);
		color.rgb = mix(fogColor.rgb, color.rgb, fogFactor );
	}
	vec4 glowColor = vec4(vec3(0.0),color.a);
	if ( glow )
		glowColor = color;

#ifdef LIT
	fragColor[2].rgba = vec4(n,1.0);
#else
	fragColor[2].rgba = vec4(0.0);
#endif

	vec4 finalColor;
	vec4 finalGlow;
	rez2D( worldPosition, color, glowColor, finalColor, finalGlow );

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;
}

