#version 330
#ifdef TEXTURE
uniform sampler2D textures[8];
in vec2 texcoord_out;
uniform float alphaRef;
#endif // TEXTURE

// in float fogFactor;
uniform float fogDensity;
uniform bool fog;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform bool glow;

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;

uniform float time;
/* uniform float globalTime; */
float d = 1.0 / 1024.0; // TODO:  HOOK THIS UP TO RESOLUTION SOMEHOW

float lookup( vec2 p, float dx, float dy, float t )
{
	float f = d * t;
	vec2 uv = (p.xy + vec2(dx * f, dy * f));
	vec4 c = texture( textures[0], uv.xy );
	// luma calculation
	return (0.216*c.r + 0.7152*c.g + 0.722*c.b) * c.a;
}

void main(void)
{
	vec4 color = frontColor;
#ifdef TEXTURE
	vec4 textureSample = texture(textures[0], texcoord_out.st);
	if ( textureSample.a < alphaRef )
		discard;
	//color *= textureSample;
	//

	float edgeTimeUp = smoothstep(0.0, 1.5, time);
	float edgeTimeDown = smoothstep(2.0, 1.5, time);
	float edgeTime = min(edgeTimeUp, edgeTimeDown);
	float whiteTimeUp = smoothstep(1.0,2.0,time);
	float whiteTimeDown = smoothstep(4.0,2.0, time);
	float whiteTime = min(whiteTimeUp,whiteTimeDown);
	float logoTime = smoothstep(1.5,3.0,time);

	color *= textureSample;
	color.a *= logoTime;

	vec4 glowColor;
	if ( edgeTime > 0.0 )
	{
		vec2 p = texcoord_out.st;
		float gx = 0.0;
		gx += -1 * lookup(p, -1.0, -1.0, edgeTime);
		gx += -2 * lookup(p, -1.0, 0.0, edgeTime);
		gx += -1 * lookup(p, -1.0, 1.0, edgeTime);
		gx += 1 * lookup(p, 1.0, -1.0, edgeTime);
		gx += 2 * lookup(p, 1.0, 0.0, edgeTime);
		gx += 1 * lookup(p, 1.0, 1.0, edgeTime);

		float gy = 0.0;
		gy += -1.0 * lookup(p, -1.0, -1.0, edgeTime);
		gy += -2.0 * lookup(p, 0.0, -1.0, edgeTime);
		gy += -1.0 * lookup(p, 1.0, -1.0, edgeTime);
		gy += 1.0 * lookup(p, -1.0, 1.0, edgeTime);
		gy += 2.0 * lookup(p, 0.0, 1.0, edgeTime);
		gy += 1.0 * lookup(p, 1.0, 1.0, edgeTime);
		float g = gx*gx + gy*gy;
		/* float g = abs(gx) + abs(gy); */
		g = g * g;
		glowColor = vec4(0.05, 0.5, 1.0, 0.2 * g * edgeTime);

	}
	else
	{
		if ( glow )
		{
			glowColor = color;
			glowColor.a *= 0.5;
		}
		else
			glowColor = vec4(0.0,0.0,0.0,textureSample.a);
	}
	/* glowColor += vec4(vec3(whiteTime), textureSample.a * whiteTime); */
	glowColor = mix( glowColor, vec4(textureSample.rgb, textureSample.a*0.15), whiteTime );
	/* glowColor += vec4(textureSample.rgb, textureSample.a*0.15) * whiteTime; */
	/* color.rgba = vec4(1.0,1.0,1.0,g); */
	/* color.rgba = vec4(0.05, 0.5, 1.0, 0.2 * g); */
	/* glowColor = mix( glowColor, vec4(0,0,0,textureSample.a), 1.0 - whiteTimeDown ); */

	if ( color.a < 0.01 && glowColor.a < 0.01 )
		discard;

	// glowColor.a *= logoTime;

#endif // TEXTURE

	vec3 finalColor = color.rgb;
	if ( fog )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		float fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
		finalColor = mix(fogColor.rgb, color.rgb, fogFactor );
	}
	/* if ( glow ) */
	/* 	glowColor = finalColor; */

	fragColor[0].rgba = vec4(finalColor, color.a);
	fragColor[1].rgba = glowColor;
	// fragColor = vec4(1.0,0.0,0.0,1.0);
}


