#version 330
#ifdef TEXTURE
uniform sampler2D textures[8];
uniform float alphaRef;
#endif // TEXTURE
in vec2 texcoord_out;

in vec3 position;
uniform float fogDensity;
uniform bool fog;
in vec3 cameraToFragment;
uniform vec3 fogColor;
uniform bool glow;
uniform float globalTime;
uniform float fade;
in mat4 localToWorld;

uniform bool rezEffect;
uniform float rezTime;
uniform float rezGridDims;
uniform float rezDelayPerGrid;
uniform float rezOriginX;
uniform float rezOriginY;
uniform float rezExpandTime;
uniform float rezFadeTime;
uniform float rezRandomExtraDelay;

#ifdef LIT
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];
in vec3 fragNormal;
#endif // LIT

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;

void main(void)
{
	vec4 color = frontColor;
#ifdef TEXTURE
	vec4 textureSample = texture(textures[0], texcoord_out.st);
	if ( textureSample.a < alphaRef )
		discard;
	color *= textureSample;
#endif // TEXTURE

	float seq = texcoord_out.y;//mod(texcoord_out.x,1.0);
	float minTime = mod(0.3 * globalTime,1.0);
	// our "minTime" now goes from [0..1] over about 3 seconds.  We want to remove
	// a moving section from the middle.  SO, the space we want to remove from
	// the current point is (let's say) 1.0.
	float timeToRemove = 0.3;
	//
	// this means that we need to adjust our time to extend this amount time
	// BEFORE and AFTER to [0..1] range.

	float maxTime = mod(minTime + timeToRemove,1.0);
	// if ( maxTime < minTime )
	// {
	// 	if ( seq < maxTime || seq > minTime )
	// 		discard;
	// }
	// else
	// {
	// 	if ( seq > minTime && seq < maxTime )
	// 		discard;
	// }

#ifdef LIT
	vec3 n = normalize(fragNormal);
	float NdotL = max(dot(n,lightSource[0].position)+1.0,0.0) * 0.5;

	if ( NdotL < 0.4 )
		NdotL = 0.2;

	vec4 ambientPart = color * lightSource[0].ambient;
	vec4 diffusePart = color * lightSource[0].diffuse * NdotL;
	color = ambientPart + diffusePart;
#endif // LIT

	vec3 finalColor = color.rgb;
	if ( fog )
	{
		float fragmentDistance = length(cameraToFragment) / 100.0;
		const float LOG2 = 1.442695;
		float fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
		finalColor = mix(fogColor.rgb, color.rgb, fogFactor );
	}
	vec3 glowColor = vec3(0.0);
	if ( glow )
		glowColor = finalColor;

	if ( rezEffect )
	{
		float time = rezTime; //mod(globalTime,1.0);

		float gridDims = rezGridDims;
		float delayPerGrid = rezDelayPerGrid;
		float halfGridDims = gridDims * 0.5;
		vec2 relativePosition = position.xy - vec2(rezOriginX, rezOriginY);

		uint xGridSquare = uint(floor(relativePosition.x / gridDims));
		uint yGridSquare = uint(floor(relativePosition.y / gridDims));
		float xGridPos = relativePosition.x - xGridSquare*gridDims;
		float yGridPos = relativePosition.y - yGridSquare*gridDims;
		vec2 gridCenter = vec2( (float(xGridSquare))*gridDims + halfGridDims, (float(yGridSquare))*gridDims + halfGridDims ) + vec2(rezOriginX, rezOriginY);

		float distanceFromGridEdge = min( xGridPos, yGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - xGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - yGridPos );
		distanceFromGridEdge = distanceFromGridEdge / halfGridDims; // [0..1] for 'grid edge' to 'center'

		// effect moves across the ground from +y to -y

		uint munge = xGridSquare ^ yGridSquare + yGridSquare ^ 1423927578u;
		munge = munge ^ munge >> 12u;
		munge = munge ^ munge << 25u;
		munge = munge ^ munge >> 27u;
		munge = munge * 3294967295u;
		munge = munge ^ munge >> 12u;
		munge = munge ^ munge << 25u;
		munge = munge ^ munge >> 27u;
		munge = munge * 3294967295u;

		float extraDelay = float(munge) / 4294967295.0;
		extraDelay *= extraDelay * extraDelay;
		extraDelay *= rezRandomExtraDelay;

		float delay = (delayPerGrid * yGridSquare) + extraDelay;

		float delta = time - delay;
		float glowFade = 1.0;

		vec4 gridWorldPosition = localToWorld * vec4(gridCenter.x, gridCenter.y,0,1);
		// if ( length(gridCenter + vec2(rezOriginX, rezOriginY)) < gridDims * 0.5 )
		if ( length(gridWorldPosition.xy) < gridDims )
		{
			glowFade = fade;
			// make a hole for the camera to pass through.
			// color.a *= fade;

			// fragColor[0].rgba = vec4(1,0,0,1);
			// fragColor[1].rgba = vec4(1,0,0,1);
			// return;
		}

		if ( delta < 0 )
		{
			discard;
		}
		else if ( delta < rezExpandTime )
		{
			float f = delta * (1.0 / rezExpandTime);
			/* f = 3.0 * f * f - 2.0 * f * f * f; */
			if ( distanceFromGridEdge > f )
				discard;

			fragColor[0].rgba = vec4(finalColor.rgb,color.a * f * glowFade );
			fragColor[1].rgba = vec4(0.0, 1.0, 1.0, 0.5 * color.a * glowFade );
			return;
		}
		else if ( delta < rezFadeTime )
		{
			float thisPhaseTime = delta - rezExpandTime;
			thisPhaseTime = thisPhaseTime / (rezFadeTime - rezExpandTime);
			float f = thisPhaseTime;
			/* f = 3.0 * f * f - 2.0 * f * f * f; */
			float distanceFromCenter = 1.0 - distanceFromGridEdge;
			if ( distanceFromCenter > f )
			{
				/* fragColor[1].rgba = vec4(0.0, 1.0-f, 1.0-f, color.a * 0.5 * (1.0-f)); */
				fragColor[1].rgba = mix(vec4(0.0,1.0,1.0,color.a*0.5 * glowFade), vec4(glowColor, color.a * glowFade), f);
			}
			else
			{
				fragColor[1].rgba = vec4(glowColor, color.a * glowFade );
			}
			fragColor[0].rgba = vec4(finalColor.rgb,color.a * glowFade );
			return;
		}
	}



	fragColor[0].rgba = vec4(finalColor, color.a * fade );
	fragColor[1].rgba = vec4(glowColor, color.a * fade);
	// fragColor = vec4(1.0,0.0,0.0,1.0);
}


