#version 330
#ifdef TEXTURE
uniform sampler2D textures[8];
uniform float alphaRef;
#endif // TEXTURE
in vec2 texcoord_out;

in vec3 position;
in vec3 cameraToFragment;
uniform bool glow;
uniform float globalTime;
uniform float fade;

uniform bool rezEffect;
uniform bool rezIn = false; // if true, we don't draw stuff 'before' the sweep
uniform bool fritzing = false;
uniform float fritzingTime = 0.0;
uniform float rezTime;
uniform float rezGridDims;
uniform float rezDelayPerGrid;
uniform float rezOriginX;
uniform float rezOriginY;
uniform float rezExpandTime;
uniform float rezFadeTime;
uniform float rezRandomExtraDelay;
uniform vec4 rezColor = vec4(0.0,1.0,1.0,0.5);

in vec4 frontColor;
out vec4 fragColor[2];

in vec4 worldPosition;

float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }
float noise(float x) { float i = floor(x); float f = fract(x); float u = f * f * (3.0 - 2.0 * f); return mix(hash(i), hash(i + 1.0), u); }
float noise(vec2 x) { vec2 i = floor(x); vec2 f = fract(x); float a = hash(i); float b = hash(i + vec2(1.0, 0.0)); float c = hash(i + vec2(0.0, 1.0)); float d = hash(i + vec2(1.0, 1.0)); vec2 u = f * f * (3.0 - 2.0 * f); return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y; }

void main(void)
{
	vec4 color = frontColor;
	color.a *= (1.0-fade);

	// color.a *= rezTime;

	vec3 finalColor = color.rgb;
	vec3 glowColor = vec3(0.0);
	if ( glow )
	{
		glowColor = color.rgb;
		glowColor.rgb *= 0.5;
	}

	// if ( rezEffect )
	{
		float time = rezTime; //mod(globalTime,1.0);

		float gridDims = rezGridDims;
		float delayPerGrid = rezDelayPerGrid;
		float halfGridDims = gridDims * 0.5;
		vec2 relativePosition = vec2(worldPosition.x,-worldPosition.y) - vec2(rezOriginX, rezOriginY);

		uint xGridSquare = uint(floor(relativePosition.x / gridDims));
		uint yGridSquare = uint(floor(relativePosition.y / gridDims));
		vec2 gridCenter = vec2( (float(xGridSquare))*gridDims + halfGridDims, (float(yGridSquare))*gridDims + halfGridDims );
		float xGridPos = relativePosition.x - xGridSquare*gridDims;
		float yGridPos = relativePosition.y - yGridSquare*gridDims;

		float distanceFromGridEdge = min( xGridPos, yGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - xGridPos );
		distanceFromGridEdge = min( distanceFromGridEdge, gridDims - yGridPos );
		distanceFromGridEdge = distanceFromGridEdge / halfGridDims; // [0..1] for 'grid edge' to 'center'

		// effect moves across the ground from +y to -y

		float extraDelay = noise( vec2(xGridSquare,yGridSquare) );
		float timeWhenThisGridCellFritzes = extraDelay * rezRandomExtraDelay;
		// extraDelay *= extraDelay;
		extraDelay *= rezRandomExtraDelay;
		// extraDelay *= extraDelay * extraDelay;

		if ( /*fritzing &&*/ length(gridCenter + vec2(rezOriginX, rezOriginY)) < gridDims * 0.5 )
		{
			// if ( distanceFromGridEdge < fritzingTime )
			// 	discard;
			timeWhenThisGridCellFritzes = 0.1;
		}

		finalColor.rgb *= 0.5 + (0.5 * smoothstep(0.0, 0.2, distanceFromGridEdge));
		vec4 thisRezColor = rezColor;
		thisRezColor.rgb *= 0.5 + (0.5 * smoothstep(0.0, 0.2, distanceFromGridEdge));

		// if ( fritzing && fritzingTime > timeWhenThisGridCellFritzes )
		// {
		// 	float timeSinceFritz = fritzingTime - timeWhenThisGridCellFritzes;
		// 	float fractionThroughFritz = timeSinceFritz * 5.0;
		// 	if ( fractionThroughFritz > 1.0 )
		// 	{
		// 		// okay.  We want to discard from INSIDE OUT as 'fractionThroughFritz' goes from 1.0 to 1.3
		// 		float clipFraction = smoothstep(1.0,2.0,fractionThroughFritz);
		// 		if ( (1.0-distanceFromGridEdge) < clipFraction )
		// 			discard;
		// 	}
		// 	{
		// 		glowColor = mix( glowColor, thisRezColor.rgb, fractionThroughFritz );
		// 		fragColor[0].rgba = vec4(finalColor, color.a);
		// 		fragColor[1].rgba = vec4(glowColor, color.a);
		// 		return;
		// 	}
		// }

		float delay = (delayPerGrid * yGridSquare) + extraDelay;

		float delta = time - delay;

		if ( delta < 0 )
		{
			if ( rezIn ) discard;
		}
		// else if ( delta < rezExpandTime )
		// {
		// 	float f = delta * (1.0 / rezExpandTime);
		// 	f = 3.0 * f * f - 2.0 * f * f * f;
		// 	if ( distanceFromGridEdge > f )
		// 	{
		// 		// discard;
		// 		if ( rezIn ) discard;
		// 	}
		// 	else
		// 	{
		// 		if ( rezIn )
		// 		{
		// 			fragColor[0].rgba = vec4(finalColor.rgb, color.a);
		// 			// fragColor[1].rgba = vec4(thisRezColor.rgb, thisRezColor.a * color.a);
		// 			fragColor[1].rgba = vec4(0.0,0.3,0.3, 0.75);
		// 		}
		// 		else
		// 		{
		// 			fragColor[0].rgba = vec4(finalColor.rgb,color.a);
		// 			fragColor[1].rgba = vec4(thisRezColor.rgb, thisRezColor.a * color.a);
		// 		}
		// 		return;
		// 	}
		// }
		// else if ( delta < rezFadeTime )
		// {
		// 	float thisPhaseTime = delta - rezExpandTime;
		// 	thisPhaseTime = thisPhaseTime / (rezFadeTime - rezExpandTime);
		// 	float f = thisPhaseTime;
		// 	// if ( f < 0.2 )
		// 	// 	thisRezColor.a = mix(0.5,thisRezColor.a,f * 5.0);
		// 	// f *= f;
		// 	// f = 3.0 * f * f - 2.0 * f * f * f;
		// 	if ( rezIn )
		// 	{
		// 		float brightness = 1.0-f;
		// 		brightness = brightness * brightness * brightness;
		// 		fragColor[1].rgba = vec4(0.0,0.3,0.3, brightness * 0.75);
		// 	}
		// 	else
		// 	{
		// 		float distanceFromCenter = 1.0 - distanceFromGridEdge;
		// 		if ( distanceFromCenter > f )
		// 		{
		// 			// fragColor[1].rgba = vec4(1.0);
		// 			/* fragColor[1].rgba = vec4(0.0, 1.0-f, 1.0-f, color.a * 0.5 * (1.0-f)); */
		// 			fragColor[1].rgba = mix(vec4(thisRezColor.rgb, thisRezColor.a * color.a), vec4(glowColor, color.a), f);
		// 			// fragColor[1].rgba = vec4(thisRezColor.rgb, thisRezColor.a * color.a);
		// 		}
		// 		else
		// 		{
		// 			// fragColor[1].rgba = vec4(1,1,1,0.1);
		// 			fragColor[1].rgba = vec4(glowColor, color.a);
		// 		}
		// 	}
		// 	fragColor[0].rgba = vec4(finalColor.rgb,color.a);
		// 	return;
		// }
	}

	fragColor[0].rgba = vec4(finalColor, color.a);
	fragColor[1].rgba = vec4(glowColor, color.a);
	// fragColor = vec4(1.0,0.0,0.0,1.0);
}



