#version 330
uniform mat4 localToWorld;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
uniform vec4 universal_color;

out vec3 cameraToFragment;
in vec4 vertex;

out vec4 frontColor;
out vec4 worldPosition;
out vec3 position;

void main(void)
{
	frontColor = universal_color;
	worldPosition = localToWorld * vertex;
	position = vertex.xyz;
	gl_Position = viewToProjection * worldToView * worldPosition;

	cameraToFragment = vec3(gl_Position);
}


