#version 330
uniform mat4 localToWorld;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
uniform vec4 universal_color;

in vec4 vertex;
in vec4 color;
out vec4 frontColor;
out vec2 screenPosition;

void main()
{
	frontColor = color * universal_color;
	screenPosition.xy = vertex.xy;
	gl_Position = viewToProjection * worldToView * localToWorld * vertex;
}


