#version 330
in vec2 texcoord_out;
// #ifdef TEXTURE
// uniform sampler2D diffuse;
// uniform float alphaRef;
// #endif // TEXTURE

uniform sampler2D environmentMap;
// in float fogFactor;
uniform float fogDensity;
uniform float ssao_size;
uniform bool fog;
in vec3 cameraToFragment;
// in float fragmentDistance;
uniform vec3 fogColor;
uniform float glow;
uniform mat4 worldToView;
in vec4 viewPosition;
in vec3 local_light_pos;
in vec3 local_normal;
in vec4 vertexColor;

uniform vec4 colorSlot[8];

#ifdef LIT
struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];
in vec3 fragNormal;
#endif // LIT

in vec4 frontColor;
out vec4 fragColor[3];

in vec4 worldPosition;


#include "rez3D_h.glsl"
#ifdef LIT
#include "shade_h.glsl"
#include "shadow_h.glsl"
#endif // LIT

void main(void)
{
	// fragColor = vec4(1.0,0.0,0.0,1.0);
	vec4 color = frontColor;
// #ifdef TEXTURE
// 	vec4 textureSample = texture(diffuse, texcoord_out.st);
// 	if ( textureSample.a < alphaRef )
// 		discard;
// 	color *= textureSample;
// #endif // TEXTURE
	color.rgba = colorSlot[ int(floor(texcoord_out.s * 8)) ];//vec3(clamp(texcoord_out.s, 0.0, 1.0));
	color *= vertexColor;
	// color.rgba = colorSlot[0];//vec3(clamp(texcoord_out.s, 0.0, 1.0));
	color.a = 1.0;
	color.rgb *= mix(1.0, 0.5, texcoord_out.t );
	color.rgb = mix( color.rgb, frontColor.rgb, frontColor.a );

	float fogFactor = 1.0;
	if ( fog )
	{
		float fragmentDistance = length(cameraToFragment);
		const float LOG2 = 1.442695;
		fogFactor = exp2( -fogDensity *
				fogDensity *
				fragmentDistance *
				fragmentDistance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
		// finalColor = mix(fogColor.rgb, color.rgb, fogFactor );
	}
#ifdef LIT
	vec3 n = normalize(fragNormal);
	float rawNdotL = dot(n,lightSource[0].position);
	float illuminated = max(rawNdotL,0.0);//max(rawNdotL+1.0,0.0) * 0.5;

	// illuminated = rawNdotL;//smoothstep(-0.1,0.1,rawNdotL);
	// illuminated = smoothstep(-0.1,0.1,rawNdotL);
	// if ( rawNdotL < 0.0 )
	// 	illuminated = 0.0;
	if ( shadows )
	{
		illuminated = calculate_shadow_illumination( worldPosition, rawNdotL );
	}
	// if ( illuminated < 0.4 )
	// 	illuminated = 0.2;

	vec3 N = normalize(local_normal);
	vec3 L = normalize(local_light_pos);
	vec3 V = normalize(-cameraToFragment);
	vec3 H = normalize(L + V);
	float specular = min( length(color.rgb), 0.21 );
	float rimSpecular = 0.10;
	float roughness = 0.8;
	float subsurface = 1.0;
	float clearcoat = 1.0;
	vec3 linearColor;
	color.rgb = shade(color.rgb, linearColor, N,L,V,H,
			illuminated, specular, rimSpecular, roughness, roughness,
			subsurface, clearcoat, fogColor.rgb, 1.0 - fogFactor, true);

	// vec3 refl = reflect(V,N);
	// vec3 env = texture( environmentMap, -refl.zy ).rgb;
	// color.rgb += env * 0.1;
	// color.rgb = mix( color.rgb, vec3(0), refl.z );

#else // !LIT
	color.rgb = mix(fogColor.rgb, color.rgb, fogFactor );
#endif

	vec4 finalColor;
	vec4 finalGlow;
	rez3D( color, glow, finalColor, finalGlow );

	fragColor[0].rgba = finalColor;
	fragColor[1].rgba = finalGlow;

#ifdef LIT
	// vec3 dx = dFdx( cameraToFragment );
	// vec3 dy = dFdy( cameraToFragment );
	// vec3 triangleN = -normalize(cross(dx,dy));
	// vec3 mungedN =  0.5 * ((N * (ssao_size/5.0)) + vec3(1.0));
	// vec3 mungedN =  0.5 * ((N * (0.1/5.0)) + vec3(1.0));
	vec3 mungedN =  N * (ssao_size/10.0);
	mungedN = (0.5 * mungedN) + vec3(0.5);
	fragColor[2].rgba = vec4( mungedN, 1.0);
#else
	fragColor[2].rgba = vec4(0,0,0,1);
#endif // LIT
}


