#version 330
uniform bool fog;
uniform float fogDensity;
uniform mat4 localToWorld;
uniform mat4 worldToView;
uniform mat4 viewToProjection;
uniform vec4 universal_color;
uniform float invWorldDims;
uniform float texelDistance;
uniform vec3 overlayOrigin;
uniform float overlayScale;

uniform sampler2D heightTexture;
uniform sampler2D colorTexture;
uniform sampler2D normalTexture;
uniform float clutterLength;
uniform float clutterTime;

out vec4 worldPosition;
out float fogFactor;
out vec3 cameraToFragment;
out vec3 local_light_pos;
in vec4 vertex;
in vec3 normal;
in vec4 color;
in vec2 texcoord;

out vec4 frontColor;
out vec2 fragTexCoord;
out vec2 fragTintCoord;
out vec3 fragNormal;
out vec4 viewPosition;
out float overlayMod;
out vec4 shadowCoord;
out vec3 local_normal;

struct lightSourceParameters
{
	vec4 ambient;              // Aclarri
	vec4 diffuse;              // Dcli
	vec4 specular;             // Scli
	vec3 position;             // Ppli
	vec3 halfVector;           // Derived: Hi
};

uniform lightSourceParameters lightSource[4];

void main()
{
	worldPosition = localToWorld * vertex;
	fragTintCoord = (vec2(texelDistance * 0.5) + worldPosition.xz) * invWorldDims;

	float clutterAmt = texture( colorTexture, fragTintCoord.st ).a;
	if ( clutterAmt > 0.5 )
	{
		fragTexCoord = texcoord;
		// frontColor.rgba = texture( colorTexture, fragTintCoord.st ).rgba;
		// TODO:  NaN us out if our alpha is too low.
		// frontColor.rgba = vec4(1.0,0.0,0.0,1.0);
		frontColor.a = 1.0;
		vec3 normal = normalize((texture( normalTexture, fragTintCoord.st ).rgb * 2.0) - vec3(1.0));
		fragNormal = normal;
		local_normal = (worldToView * vec4(fragNormal,0.0)).xyz;

		vec3 up = ( normal.y > 0.99999 ) ? vec3(0,0,1) : vec3(0,1,0);

		vec3 right = normalize(cross(up, normal));
		vec3 slope = normalize(cross(right,normal));

		clutterAmt = min(
				texture( colorTexture, (worldPosition.xz+right.xz*3.0) * invWorldDims ).a,
				texture( colorTexture, (worldPosition.xz-right.xz*3.0) * invWorldDims ).a
				);
		if ( clutterAmt > 0.5 )
		{
			// 		clutterAmt = vsMin( data->ClutterAt( center.x + offset.x, center.z + offset.z ),
			// 				data->ClutterAt( center.x - offset.x, center.z - offset.z ) );
			// 		if ( clutterAmt < 0.5f )
			// 			return;

			// vec3 loft = slope * clutterLength * normal.y + 0.1f * normal;
			// vec3 loft = slope * 10.0 * clutterAmt * normal.y + 0.1f * normal;
			vec3 loft = slope * clutterLength * clutterAmt * normal.y + 0.1f * normal;

			// 	vsVector3D loft = clutterHeight * slope * normal.y + 0.1f * normal;
			float loftAmt = (1.0 - texcoord.t);

			worldPosition.xyz += right * 3.0 * (2.0 * texcoord.s - 1.0);

			fragTintCoord = (vec2(texelDistance * 0.5) + worldPosition.xz) * invWorldDims;
			worldPosition.y = texture( heightTexture, fragTintCoord.st ).r;

			frontColor = texture( colorTexture, fragTintCoord.st ).rgba;
			frontColor.a = 1.0;

			// if ( slope.z < 0.0 )
				// frontColor.rgb = slope;

			worldPosition.xyz += loft * loftAmt;
			frontColor.rgb += vec3(0.05 * loftAmt);

			// frontColor = vec4(1,0,0,1);

			// fragTintCoord = worldPosition.xz * invWorldDims;
			fragTintCoord = (vec2(texelDistance * 0.5) + worldPosition.xz) * invWorldDims;
			if ( loftAmt > 0.5 )
			{
				worldPosition.y = max( worldPosition.y, texture( heightTexture, fragTintCoord.st ).r + 1.0 );

				float t = mod(clutterTime + worldPosition.x + worldPosition.z, 2.0) * 0.5; // [0..1]
				t = 2.0 * abs( t - 0.5 ); // [1 .. 0 .. 1]
				t = smoothstep(0.0,1.0,t);
				worldPosition.y += t * 0.2;
			}
			// worldPosition.y += 0.2 * (1.0 - texcoord.y);

			// shadowCoord = worldToLight * worldPosition;
			vec4 worldNormal = (localToWorld * vec4(normal,0));
		}
		else
			worldPosition.xyz = vec3(0);
	}
	// float overlayModMin = min( smoothstep(0.0,0.1,overlayTexcoord.s), smoothstep(0.0,0.1,overlayTexcoord.t) );
	// float overlayModMax = min( 1.0 - smoothstep(0.9,1.0,overlayTexcoord.s), 1.0 - smoothstep(0.9,1.0,overlayTexcoord.t) );
	// overlayMod = min( overlayModMin, overlayModMax );
	overlayMod = 1.0;

	// worldPosition.y += 0.5;

	vec4 camToFragment = worldToView * worldPosition;
	cameraToFragment = camToFragment.rgb;
	gl_Position = viewToProjection * camToFragment;
	viewPosition = gl_Position;
	local_light_pos = (worldToView * vec4(lightSource[0].position.xyz, 0.0)).xyz;

	fogFactor = 1.0;
	if ( fog )
	{
		const float LOG2 = 1.442695;
		vec3 vVertex = vec3(gl_Position);
		float distance = length(vVertex);
		fogFactor = exp2( -fogDensity *
				fogDensity *
				distance *
				distance *
				LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
	}

}

