/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.serialization.codecs;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.function.Function;
import java.util.stream.Stream;

public class KeyDispatchCodec<K, V>
extends MapCodec<V> {
    private final String typeKey;
    private final Codec<K> keyCodec;
    private final String valueKey = "value";
    private final Function<? super V, ? extends DataResult<? extends K>> type;
    private final Function<? super K, ? extends DataResult<? extends Decoder<? extends V>>> decoder;
    private final Function<? super V, ? extends DataResult<? extends Encoder<V>>> encoder;

    public KeyDispatchCodec(String typeKey, Codec<K> keyCodec, Function<? super V, ? extends DataResult<? extends K>> type, Function<? super K, ? extends DataResult<? extends Decoder<? extends V>>> decoder, Function<? super V, ? extends DataResult<? extends Encoder<V>>> encoder) {
        this.typeKey = typeKey;
        this.keyCodec = keyCodec;
        this.type = type;
        this.decoder = decoder;
        this.encoder = encoder;
    }

    public KeyDispatchCodec(String typeKey, Codec<K> keyCodec, Function<? super V, ? extends DataResult<? extends K>> type, Function<? super K, ? extends DataResult<? extends Codec<? extends V>>> codec) {
        this(typeKey, keyCodec, type, codec, v -> KeyDispatchCodec.getCodec(type, codec, v));
    }

    @Override
    public <T> DataResult<V> decode(DynamicOps<T> ops, MapLike<T> input) {
        T elementName = input.get(this.typeKey);
        if (elementName == null) {
            return DataResult.error("Input does not contain a key [" + this.typeKey + "]: " + input);
        }
        return this.keyCodec.decode(ops, elementName).flatMap((? super R type) -> {
            DataResult<Decoder<V>> elementDecoder = this.decoder.apply(type.getFirst());
            return elementDecoder.flatMap((? super R c) -> {
                if (ops.compressMaps()) {
                    Object value = input.get(ops.createString("value"));
                    if (value == null) {
                        return DataResult.error("Input does not have a \"value\" entry: " + input);
                    }
                    return c.parse(ops, value).map(Function.identity());
                }
                if (c instanceof MapCodec.MapCodecCodec) {
                    return ((MapCodec.MapCodecCodec)c).codec().decode(ops, input).map(Function.identity());
                }
                return c.decode(ops, ops.createMap(input.entries())).map(Pair::getFirst);
            });
        });
    }

    @Override
    public <T> RecordBuilder<T> encode(V input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        DataResult<Encoder<V>> elementEncoder = this.encoder.apply(input);
        RecordBuilder<T> builder = prefix.withErrorsFrom(elementEncoder);
        if (!elementEncoder.result().isPresent()) {
            return builder;
        }
        Encoder<V> c = elementEncoder.result().get();
        if (ops.compressMaps()) {
            return prefix.add(this.typeKey, this.type.apply(input).flatMap((? super R t) -> this.keyCodec.encodeStart(ops, t))).add("value", c.encodeStart(ops, input));
        }
        if (c instanceof MapCodec.MapCodecCodec) {
            return ((MapCodec.MapCodecCodec)c).codec().encode(input, ops, prefix).add(this.typeKey, this.type.apply(input).flatMap((? super R t) -> this.keyCodec.encodeStart(ops, t)));
        }
        Object typeString = ops.createString(this.typeKey);
        DataResult element = c.encodeStart(ops, input).flatMap(ops::getMap);
        return element.map((? super R map) -> {
            map.entries().forEach(pair -> {
                if (pair.getFirst().equals(typeString)) {
                    prefix.add(typeString, this.type.apply(input).flatMap((? super R t) -> this.keyCodec.encodeStart(ops, t)));
                } else {
                    prefix.add(pair.getFirst(), pair.getSecond());
                }
            });
            return prefix;
        }).result().orElseGet(() -> prefix.withErrorsFrom(element));
    }

    @Override
    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(this.typeKey, "value").map(ops::createString);
    }

    private static <K, V> DataResult<? extends Encoder<V>> getCodec(Function<? super V, ? extends DataResult<? extends K>> type, Function<? super K, ? extends DataResult<? extends Encoder<? extends V>>> encoder, V input) {
        return type.apply(input).flatMap((? super R k) -> ((DataResult)encoder.apply((Object)k)).map(Function.identity())).map((? super R c) -> c);
    }

    public String toString() {
        return "KeyDispatchCodec[" + this.keyCodec.toString() + " " + this.type + " " + this.decoder + "]";
    }
}

