/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.server.SessionLockManager;
import net.minecraft.util.FileUtil;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.AnvilSaveConverter;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.PlayerData;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraft.world.storage.VersionData;
import net.minecraft.world.storage.WorldSummary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveFormat {
    private static final Logger field_215785_a = LogManager.getLogger();
    private static final DateTimeFormatter field_197716_d = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final ImmutableList<String> field_237257_c_ = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    private final Path field_215786_c;
    private final Path field_215787_d;
    private final DataFixer field_215788_e;

    public SaveFormat(Path path, Path path2, DataFixer dataFixer) {
        this.field_215788_e = dataFixer;
        try {
            Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.field_215786_c = path;
        this.field_215787_d = path2;
    }

    public static SaveFormat func_237269_a_(Path path) {
        return new SaveFormat(path, path.resolve("../backups"), DataFixesManager.func_210901_a());
    }

    private static Pair<DimensionGeneratorSettings, Lifecycle> func_237259_a_(Dynamic<?> dynamic, DataFixer dataFixer, int n) {
        String \u260332;
        Dynamic \u26032 = dynamic.get("WorldGenSettings").orElseEmptyMap();
        for (String \u260332 : field_237257_c_) {
            Optional optional = dynamic.get(\u260332).result();
            if (!optional.isPresent()) continue;
            \u26032 = \u26032.set(\u260332, (Dynamic)optional.get());
        }
        Dynamic dynamic2 = dataFixer.update(TypeReferences.field_233375_y_, \u26032, n, SharedConstants.func_215069_a().getWorldVersion());
        \u260332 = DimensionGeneratorSettings.field_236201_a_.parse(dynamic2);
        return Pair.of((Object)\u260332.resultOrPartial(Util.func_240982_a_("WorldGenSettings: ", arg_0 -> ((Logger)field_215785_a).error(arg_0))).orElseGet(DimensionGeneratorSettings::func_236210_a_), (Object)\u260332.lifecycle());
    }

    private static DatapackCodec func_237258_a_(Dynamic<?> dynamic) {
        return DatapackCodec.field_234881_b_.parse(dynamic).resultOrPartial(arg_0 -> ((Logger)field_215785_a).error(arg_0)).orElse(DatapackCodec.field_234880_a_);
    }

    public List<WorldSummary> func_75799_b() throws AnvilConverterException {
        if (!Files.isDirectory(this.field_215786_c, new LinkOption[0])) {
            throw new AnvilConverterException(new TranslationTextComponent("selectWorld.load_folder_access").getString());
        }
        ArrayList arrayList = Lists.newArrayList();
        for (File file : \u2603 = this.field_215786_c.toFile().listFiles()) {
            if (!file.isDirectory()) continue;
            try {
                boolean bl = SessionLockManager.func_232999_b_(file.toPath());
            }
            catch (Exception exception) {
                field_215785_a.warn("Failed to read {} lock", (Object)file, (Object)exception);
                continue;
            }
            WorldSummary worldSummary = this.func_237266_a_(file, this.func_237267_a_(file, bl));
            if (worldSummary == null) continue;
            arrayList.add(worldSummary);
        }
        return arrayList;
    }

    private int func_215782_e() {
        return 19133;
    }

    @Nullable
    private <T> T func_237266_a_(File file, BiFunction<File, DataFixer, T> biFunction) {
        if (!file.exists()) {
            return null;
        }
        File file2 = new File(file, "level.dat");
        if (file2.exists() && (\u2603 = biFunction.apply(file2, this.field_215788_e)) != null) {
            return \u2603;
        }
        file2 = new File(file, "level.dat_old");
        if (file2.exists()) {
            return biFunction.apply(file2, this.field_215788_e);
        }
        return null;
    }

    @Nullable
    private static DatapackCodec func_237272_b_(File file, DataFixer dataFixer) {
        try {
            CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a(new FileInputStream(file));
            \u2603 = compoundNBT.func_74775_l("Data");
            \u2603.func_82580_o("Player");
            int \u26032 = \u2603.func_150297_b("DataVersion", 99) ? \u2603.func_74762_e("DataVersion") : -1;
            Dynamic \u26033 = dataFixer.update(DefaultTypeReferences.LEVEL.func_219816_a(), new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)\u2603), \u26032, SharedConstants.func_215069_a().getWorldVersion());
            return \u26033.get("DataPacks").result().map(SaveFormat::func_237258_a_).orElse(DatapackCodec.field_234880_a_);
        }
        catch (Exception exception) {
            field_215785_a.error("Exception reading {}", (Object)file, (Object)exception);
            return null;
        }
    }

    private static BiFunction<File, DataFixer, ServerWorldInfo> func_237270_b_(DynamicOps<INBT> dynamicOps, DatapackCodec datapackCodec) {
        return (file, dataFixer) -> {
            try {
                CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a(new FileInputStream((File)file));
                \u2603 = compoundNBT.func_74775_l("Data");
                \u2603 = \u2603.func_150297_b("Player", 10) ? \u2603.func_74775_l("Player") : null;
                \u2603.func_82580_o("Player");
                int \u26032 = \u2603.func_150297_b("DataVersion", 99) ? \u2603.func_74762_e("DataVersion") : -1;
                Dynamic \u26033 = dataFixer.update(DefaultTypeReferences.LEVEL.func_219816_a(), new Dynamic(dynamicOps, (Object)\u2603), \u26032, SharedConstants.func_215069_a().getWorldVersion());
                Pair<DimensionGeneratorSettings, Lifecycle> \u26034 = SaveFormat.func_237259_a_(\u26033, dataFixer, \u26032);
                VersionData \u26035 = VersionData.func_237324_a_(\u26033);
                WorldSettings \u26036 = WorldSettings.func_234951_a_(\u26033, datapackCodec);
                return ServerWorldInfo.func_237369_a_((Dynamic<INBT>)\u26033, dataFixer, \u26032, \u2603, \u26036, \u26035, (DimensionGeneratorSettings)\u26034.getFirst(), (Lifecycle)\u26034.getSecond());
            }
            catch (Exception exception) {
                field_215785_a.error("Exception reading {}", file, (Object)exception);
                return null;
            }
        };
    }

    private BiFunction<File, DataFixer, WorldSummary> func_237267_a_(File file, boolean bl) {
        return (file2, dataFixer) -> {
            try {
                CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a(new FileInputStream((File)file2));
                \u2603 = compoundNBT.func_74775_l("Data");
                \u2603.func_82580_o("Player");
                int \u26032 = \u2603.func_150297_b("DataVersion", 99) ? \u2603.func_74762_e("DataVersion") : -1;
                Dynamic \u26033 = dataFixer.update(DefaultTypeReferences.LEVEL.func_219816_a(), new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)\u2603), \u26032, SharedConstants.func_215069_a().getWorldVersion());
                VersionData \u26034 = VersionData.func_237324_a_(\u26033);
                int \u26035 = \u26034.func_237323_a_();
                if (\u26035 == 19132 || \u26035 == 19133) {
                    boolean bl2 = \u26035 != this.func_215782_e();
                    File \u26036 = new File(file, "icon.png");
                    DatapackCodec \u26037 = \u26033.get("DataPacks").result().map(SaveFormat::func_237258_a_).orElse(DatapackCodec.field_234880_a_);
                    WorldSettings \u26038 = WorldSettings.func_234951_a_(\u26033, \u26037);
                    return new WorldSummary(\u26038, \u26034, file.getName(), bl2, bl, \u26036);
                }
                return null;
            }
            catch (Exception exception) {
                field_215785_a.error("Exception reading {}", file2, (Object)exception);
                return null;
            }
        };
    }

    public boolean func_207742_d(String string) {
        try {
            Path path = this.field_215786_c.resolve(string);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean func_90033_f(String string) {
        return Files.isDirectory(this.field_215786_c.resolve(string), new LinkOption[0]);
    }

    public Path func_215781_c() {
        return this.field_215786_c;
    }

    public Path func_197712_e() {
        return this.field_215787_d;
    }

    public LevelSave func_237274_c_(String string) throws IOException {
        return new LevelSave(string);
    }

    public class LevelSave
    implements AutoCloseable {
        private final SessionLockManager field_237278_b_;
        private final Path field_237279_c_;
        private final String field_237280_d_;
        private final Map<FolderName, Path> field_237281_e_ = Maps.newHashMap();

        public LevelSave(String string) throws IOException {
            this.field_237280_d_ = string;
            this.field_237279_c_ = SaveFormat.this.field_215786_c.resolve(string);
            this.field_237278_b_ = SessionLockManager.func_232998_a_(this.field_237279_c_);
        }

        public String func_237282_a_() {
            return this.field_237280_d_;
        }

        public Path func_237285_a_(FolderName folderName2) {
            return this.field_237281_e_.computeIfAbsent(folderName2, folderName -> this.field_237279_c_.resolve(folderName.func_237255_a_()));
        }

        public File func_237291_a_(RegistryKey<World> registryKey) {
            return DimensionType.func_236031_a_(registryKey, this.field_237279_c_.toFile());
        }

        private void func_237301_i_() {
            if (!this.field_237278_b_.func_232997_a_()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerData func_237292_b_() {
            this.func_237301_i_();
            return new PlayerData(this, SaveFormat.this.field_215788_e);
        }

        public boolean func_237295_c_() {
            WorldSummary worldSummary = this.func_237296_d_();
            return worldSummary != null && worldSummary.func_237314_k_().func_237323_a_() != SaveFormat.this.func_215782_e();
        }

        public boolean func_237283_a_(IProgressUpdate iProgressUpdate) {
            this.func_237301_i_();
            return AnvilSaveConverter.func_237330_a_(this, iProgressUpdate);
        }

        @Nullable
        public WorldSummary func_237296_d_() {
            this.func_237301_i_();
            return (WorldSummary)SaveFormat.this.func_237266_a_(this.field_237279_c_.toFile(), SaveFormat.this.func_237267_a_(this.field_237279_c_.toFile(), false));
        }

        @Nullable
        public IServerConfiguration func_237284_a_(DynamicOps<INBT> dynamicOps, DatapackCodec datapackCodec) {
            this.func_237301_i_();
            return (IServerConfiguration)SaveFormat.this.func_237266_a_(this.field_237279_c_.toFile(), SaveFormat.func_237270_b_((DynamicOps<INBT>)dynamicOps, datapackCodec));
        }

        @Nullable
        public DatapackCodec func_237297_e_() {
            this.func_237301_i_();
            return (DatapackCodec)SaveFormat.this.func_237266_a_(this.field_237279_c_.toFile(), (file, dataFixer) -> SaveFormat.func_237272_b_(file, dataFixer));
        }

        public void func_237287_a_(IDynamicRegistries iDynamicRegistries, IServerConfiguration iServerConfiguration) {
            this.func_237288_a_(iDynamicRegistries, iServerConfiguration, null);
        }

        public void func_237288_a_(IDynamicRegistries iDynamicRegistries, IServerConfiguration iServerConfiguration, @Nullable CompoundNBT compoundNBT) {
            File file = this.field_237279_c_.toFile();
            CompoundNBT \u26032 = iServerConfiguration.func_230411_a_(iDynamicRegistries, compoundNBT);
            CompoundNBT \u26033 = new CompoundNBT();
            \u26033.func_218657_a("Data", \u26032);
            try {
                \u2603 = File.createTempFile("level", ".dat", file);
                CompressedStreamTools.func_74799_a(\u26033, new FileOutputStream(\u2603));
                \u2603 = new File(file, "level.dat_old");
                \u2603 = new File(file, "level.dat");
                Util.func_240977_a_(\u2603, \u2603, \u2603);
            }
            catch (Exception \u26034) {
                field_215785_a.error("Failed to save level {}", (Object)file, (Object)\u26034);
            }
        }

        public File func_237298_f_() {
            this.func_237301_i_();
            return this.field_237279_c_.resolve("icon.png").toFile();
        }

        public void func_237299_g_() throws IOException {
            this.func_237301_i_();
            final Path path = this.field_237279_c_.resolve("session.lock");
            for (int i = 1; i <= 5; ++i) {
                field_215785_a.info("Attempt {}...", (Object)i);
                try {
                    Files.walkFileTree(this.field_237279_c_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                            if (!path2.equals(path)) {
                                field_215785_a.debug("Deleting {}", (Object)path2);
                                Files.delete(path2);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path path2, IOException iOException) throws IOException {
                            if (iOException != null) {
                                throw iOException;
                            }
                            if (path2.equals(LevelSave.this.field_237279_c_)) {
                                LevelSave.this.field_237278_b_.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(path2);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                            return this.postVisitDirectory((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.visitFile((Path)object, basicFileAttributes);
                        }
                    });
                    break;
                }
                catch (IOException iOException) {
                    if (i < 5) {
                        field_215785_a.warn("Failed to delete {}", (Object)this.field_237279_c_, (Object)iOException);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw iOException;
                }
            }
        }

        public void func_237290_a_(String string) throws IOException {
            this.func_237301_i_();
            File file = new File(SaveFormat.this.field_215786_c.toFile(), this.field_237280_d_);
            if (!file.exists()) {
                return;
            }
            \u2603 = new File(file, "level.dat");
            if (\u2603.exists()) {
                CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a(new FileInputStream(\u2603));
                \u2603 = compoundNBT.func_74775_l("Data");
                \u2603.func_74778_a("LevelName", string);
                CompressedStreamTools.func_74799_a(compoundNBT, new FileOutputStream(\u2603));
            }
        }

        public long func_237300_h_() throws IOException {
            this.func_237301_i_();
            String string = LocalDateTime.now().format(field_197716_d) + "_" + this.field_237280_d_;
            Path \u26032 = SaveFormat.this.func_197712_e();
            try {
                Files.createDirectories(Files.exists(\u26032, new LinkOption[0]) ? \u26032.toRealPath(new LinkOption[0]) : \u26032, new FileAttribute[0]);
            }
            catch (IOException \u26033) {
                throw new RuntimeException(\u26033);
            }
            Path \u26034 = \u26032.resolve(FileUtil.func_214992_a(\u26032, string, ".zip"));
            try (final ZipOutputStream \u26035 = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(\u26034, new OpenOption[0])));){
                final Path path = Paths.get(this.field_237280_d_, new String[0]);
                Files.walkFileTree(this.field_237279_c_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                        if (path2.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String string = path.resolve(LevelSave.this.field_237279_c_.relativize(path2)).toString().replace('\\', '/');
                        ZipEntry \u26032 = new ZipEntry(string);
                        \u26035.putNextEntry(\u26032);
                        com.google.common.io.Files.asByteSource((File)path2.toFile()).copyTo((OutputStream)\u26035);
                        \u26035.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.visitFile((Path)object, basicFileAttributes);
                    }
                });
            }
            return Files.size(\u26034);
        }

        @Override
        public void close() throws IOException {
            this.field_237278_b_.close();
        }
    }
}

