/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerData {
    private static final Logger field_237332_b_ = LogManager.getLogger();
    private final File field_237333_c_;
    protected final DataFixer field_237331_a_;

    public PlayerData(SaveFormat.LevelSave levelSave, DataFixer dataFixer) {
        this.field_237331_a_ = dataFixer;
        this.field_237333_c_ = levelSave.func_237285_a_(FolderName.field_237247_c_).toFile();
        this.field_237333_c_.mkdirs();
    }

    public void func_237335_a_(PlayerEntity playerEntity) {
        try {
            CompoundNBT compoundNBT = playerEntity.func_189511_e(new CompoundNBT());
            File \u26032 = File.createTempFile(playerEntity.func_189512_bd() + "-", ".dat", this.field_237333_c_);
            CompressedStreamTools.func_74799_a(compoundNBT, new FileOutputStream(\u26032));
            File \u26033 = new File(this.field_237333_c_, playerEntity.func_189512_bd() + ".dat");
            File \u26034 = new File(this.field_237333_c_, playerEntity.func_189512_bd() + ".dat_old");
            Util.func_240977_a_(\u26033, \u26032, \u26034);
        }
        catch (Exception exception) {
            field_237332_b_.warn("Failed to save player data for {}", (Object)playerEntity.func_200200_C_().getString());
        }
    }

    @Nullable
    public CompoundNBT func_237336_b_(PlayerEntity playerEntity) {
        CompoundNBT compoundNBT = null;
        try {
            File file = new File(this.field_237333_c_, playerEntity.func_189512_bd() + ".dat");
            if (file.exists() && file.isFile()) {
                compoundNBT = CompressedStreamTools.func_74796_a(new FileInputStream(file));
            }
        }
        catch (Exception exception) {
            field_237332_b_.warn("Failed to load player data for {}", (Object)playerEntity.func_200200_C_().getString());
        }
        if (compoundNBT != null) {
            int n = compoundNBT.func_150297_b("DataVersion", 3) ? compoundNBT.func_74762_e("DataVersion") : -1;
            playerEntity.func_70020_e(NBTUtil.func_210822_a(this.field_237331_a_, DefaultTypeReferences.PLAYER, compoundNBT, n));
        }
        return compoundNBT;
    }

    public String[] func_237334_a_() {
        String[] stringArray = this.field_237333_c_.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".dat")) continue;
            stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 4);
        }
        return stringArray;
    }
}

