/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.surfacebuilders;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class BadlandsSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState field_215434_S = Blocks.field_196777_fo.func_176223_P();
    private static final BlockState field_215436_T = Blocks.field_196778_fp.func_176223_P();
    private static final BlockState field_215438_U = Blocks.field_150405_ch.func_176223_P();
    private static final BlockState field_215440_V = Blocks.field_196783_fs.func_176223_P();
    private static final BlockState field_215441_W = Blocks.field_196719_fA.func_176223_P();
    private static final BlockState field_215442_X = Blocks.field_196721_fC.func_176223_P();
    private static final BlockState field_215443_Y = Blocks.field_196791_fw.func_176223_P();
    protected BlockState[] field_215432_a;
    protected long field_215433_b;
    protected PerlinNoiseGenerator field_215435_c;
    protected PerlinNoiseGenerator field_215437_d;
    protected PerlinNoiseGenerator field_215439_e;

    public BadlandsSurfaceBuilder(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
    }

    @Override
    public void func_205610_a_(Random random, IChunk iChunk2, Biome biome, int n, int n2, int n3, double d, BlockState blockState, BlockState blockState2, int n4, long l, SurfaceBuilderConfig surfaceBuilderConfig) {
        int n5 = n & 0xF;
        \u2603 = n2 & 0xF;
        BlockState \u26032 = field_215434_S;
        BlockState \u26033 = biome.func_203944_q().func_204109_b();
        \u2603 = (int)(d / 3.0 + 3.0 + random.nextDouble() * 0.25);
        boolean \u26034 = Math.cos(d / 3.0 * Math.PI) > 0.0;
        n6 = -1;
        boolean \u26035 = false;
        \u2603 = 0;
        BlockPos.Mutable \u26036 = new BlockPos.Mutable();
        for (\u2603 = n3; \u2603 >= 0; --\u2603) {
            int n6;
            if (\u2603 >= 15) continue;
            \u26036.func_181079_c(n5, \u2603, \u2603);
            BlockState blockState3 = iChunk2.func_180495_p(\u26036);
            if (blockState3.func_196958_f()) {
                n6 = -1;
                continue;
            }
            if (!blockState3.func_203425_a(blockState.func_177230_c())) continue;
            if (n6 == -1) {
                IChunk iChunk2;
                Object \u26037;
                \u26035 = false;
                if (\u2603 <= 0) {
                    \u26032 = Blocks.field_150350_a.func_176223_P();
                    \u26033 = blockState;
                } else if (\u2603 >= n4 - 4 && \u2603 <= n4 + 1) {
                    \u26032 = field_215434_S;
                    \u26033 = biome.func_203944_q().func_204109_b();
                }
                if (\u2603 < n4 && (\u26032 == null || \u26032.func_196958_f())) {
                    \u26032 = blockState2;
                }
                n6 = \u2603 + Math.max(0, \u2603 - n4);
                if (\u2603 >= n4 - 1) {
                    if (\u2603 > n4 + 3 + \u2603) {
                        \u26037 = \u2603 < 64 || \u2603 > 127 ? field_215436_T : (\u26034 ? field_215438_U : this.func_215431_a(n, \u2603, n2));
                        iChunk2.func_177436_a(\u26036, (BlockState)\u26037, false);
                    } else {
                        iChunk2.func_177436_a(\u26036, biome.func_203944_q().func_204108_a(), false);
                        \u26035 = true;
                    }
                } else {
                    iChunk2.func_177436_a(\u26036, \u26033, false);
                    \u26037 = \u26033.func_177230_c();
                    if (\u26037 == Blocks.field_196777_fo || \u26037 == Blocks.field_196778_fp || \u26037 == Blocks.field_196780_fq || \u26037 == Blocks.field_196782_fr || \u26037 == Blocks.field_196783_fs || \u26037 == Blocks.field_196785_ft || \u26037 == Blocks.field_196787_fu || \u26037 == Blocks.field_196789_fv || \u26037 == Blocks.field_196791_fw || \u26037 == Blocks.field_196793_fx || \u26037 == Blocks.field_196795_fy || \u26037 == Blocks.field_196797_fz || \u26037 == Blocks.field_196719_fA || \u26037 == Blocks.field_196720_fB || \u26037 == Blocks.field_196721_fC || \u26037 == Blocks.field_196722_fD) {
                        iChunk2.func_177436_a(\u26036, field_215436_T, false);
                    }
                }
            } else if (n6 > 0) {
                --n6;
                if (\u26035) {
                    iChunk2.func_177436_a(\u26036, field_215436_T, false);
                } else {
                    iChunk2.func_177436_a(\u26036, this.func_215431_a(n, \u2603, n2), false);
                }
            }
            ++\u2603;
        }
    }

    @Override
    public void func_205548_a(long l2) {
        long l2;
        if (this.field_215433_b != l2 || this.field_215432_a == null) {
            this.func_215430_b(l2);
        }
        if (this.field_215433_b != l2 || this.field_215435_c == null || this.field_215437_d == null) {
            SharedSeedRandom sharedSeedRandom = new SharedSeedRandom(l2);
            this.field_215435_c = new PerlinNoiseGenerator(sharedSeedRandom, IntStream.rangeClosed(-3, 0));
            this.field_215437_d = new PerlinNoiseGenerator(sharedSeedRandom, (List<Integer>)ImmutableList.of((Object)0));
        }
        this.field_215433_b = l2;
    }

    protected void func_215430_b(long l) {
        int \u26035;
        int \u26034;
        int \u26033;
        int \u26032;
        this.field_215432_a = new BlockState[64];
        Arrays.fill(this.field_215432_a, field_215438_U);
        SharedSeedRandom sharedSeedRandom = new SharedSeedRandom(l);
        this.field_215439_e = new PerlinNoiseGenerator(sharedSeedRandom, (List<Integer>)ImmutableList.of((Object)0));
        for (\u26032 = 0; \u26032 < 64; ++\u26032) {
            if ((\u26032 += sharedSeedRandom.nextInt(5) + 1) >= 64) continue;
            this.field_215432_a[\u26032] = field_215436_T;
        }
        \u26032 = sharedSeedRandom.nextInt(4) + 2;
        for (\u26033 = 0; \u26033 < \u26032; ++\u26033) {
            \u26034 = sharedSeedRandom.nextInt(3) + 1;
            \u26035 = sharedSeedRandom.nextInt(64);
            for (\u26036 = 0; \u26035 + \u26036 < 64 && \u26036 < \u26034; ++\u26036) {
                this.field_215432_a[\u26035 + \u26036] = field_215440_V;
            }
        }
        \u26033 = sharedSeedRandom.nextInt(4) + 2;
        for (\u26034 = 0; \u26034 < \u26033; ++\u26034) {
            \u26035 = sharedSeedRandom.nextInt(3) + 2;
            \u26036 = sharedSeedRandom.nextInt(64);
            for (i = 0; \u26036 + i < 64 && i < \u26035; ++i) {
                this.field_215432_a[\u26036 + i] = field_215441_W;
            }
        }
        \u26034 = sharedSeedRandom.nextInt(4) + 2;
        for (\u26035 = 0; \u26035 < \u26034; ++\u26035) {
            \u26036 = sharedSeedRandom.nextInt(3) + 1;
            i = sharedSeedRandom.nextInt(64);
            for (\u2603 = 0; i + \u2603 < 64 && \u2603 < \u26036; ++\u2603) {
                this.field_215432_a[i + \u2603] = field_215442_X;
            }
        }
        \u26035 = sharedSeedRandom.nextInt(3) + 3;
        int \u26036 = 0;
        for (int i = 0; i < \u26035; ++i) {
            \u2603 = 1;
            \u26036 += sharedSeedRandom.nextInt(16) + 4;
            for (\u2603 = 0; \u26036 + \u2603 < 64 && \u2603 < 1; ++\u2603) {
                this.field_215432_a[\u26036 + \u2603] = field_215434_S;
                if (\u26036 + \u2603 > 1 && sharedSeedRandom.nextBoolean()) {
                    this.field_215432_a[\u26036 + \u2603 - 1] = field_215443_Y;
                }
                if (\u26036 + \u2603 >= 63 || !sharedSeedRandom.nextBoolean()) continue;
                this.field_215432_a[\u26036 + \u2603 + 1] = field_215443_Y;
            }
        }
    }

    protected BlockState func_215431_a(int n, int n2, int n3) {
        \u2603 = (int)Math.round(this.field_215439_e.func_215464_a((double)n / 512.0, (double)n3 / 512.0, false) * 2.0);
        return this.field_215432_a[(n2 + \u2603 + 64) % 64];
    }
}

