/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.PillagerOutpostPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class PillagerOutpostStructure
extends Structure<NoFeatureConfig> {
    private static final List<Biome.SpawnListEntry> field_214558_a = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_220350_aJ, 1, 1, 1)});

    public PillagerOutpostStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @Override
    public List<Biome.SpawnListEntry> func_202279_e() {
        return field_214558_a;
    }

    @Override
    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider, long l, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome, ChunkPos chunkPos, NoFeatureConfig noFeatureConfig) {
        int n3 = n >> 4;
        \u2603 = n2 >> 4;
        sharedSeedRandom.setSeed((long)(n3 ^ \u2603 << 4) ^ l);
        sharedSeedRandom.nextInt();
        if (sharedSeedRandom.nextInt(5) != 0) {
            return false;
        }
        for (\u2603 = n - 10; \u2603 <= n + 10; ++\u2603) {
            for (\u2603 = n2 - 10; \u2603 <= n2 + 10; ++\u2603) {
                ChunkPos chunkPos2 = Structure.field_236381_q_.func_236392_a_(chunkGenerator.func_235957_b_().func_236197_a_(Structure.field_236381_q_), l, sharedSeedRandom, \u2603, \u2603);
                if (\u2603 != chunkPos2.field_77276_a || \u2603 != chunkPos2.field_77275_b) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends MarginedStructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int n, int n2, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_230364_a_(ChunkGenerator chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome, NoFeatureConfig noFeatureConfig) {
            BlockPos blockPos = new BlockPos(n * 16, 0, n2 * 16);
            PillagerOutpostPieces.func_215139_a(chunkGenerator, templateManager, blockPos, this.field_75075_a, this.field_214631_d);
            this.func_202500_a();
        }
    }
}

