/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MineshaftStructure
extends Structure<MineshaftConfig> {
    public MineshaftStructure(Codec<MineshaftConfig> codec) {
        super(codec);
    }

    @Override
    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider, long l, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome, ChunkPos chunkPos, MineshaftConfig mineshaftConfig) {
        sharedSeedRandom.func_202425_c(l, n, n2);
        double d = mineshaftConfig.field_202439_a;
        return sharedSeedRandom.nextDouble() < d;
    }

    @Override
    public Structure.IStartFactory<MineshaftConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<MineshaftConfig> {
        public Start(Structure<MineshaftConfig> structure, int n, int n2, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_230364_a_(ChunkGenerator chunkGenerator2, TemplateManager templateManager, int n, int n2, Biome biome, MineshaftConfig mineshaftConfig) {
            MineshaftPieces.Room room = new MineshaftPieces.Room(0, this.field_214631_d, (n << 4) + 2, (n2 << 4) + 2, mineshaftConfig.field_202440_b);
            this.field_75075_a.add(room);
            room.func_74861_a(room, this.field_75075_a, this.field_214631_d);
            this.func_202500_a();
            if (mineshaftConfig.field_202440_b == Type.MESA) {
                int n3 = -5;
                \u2603 = chunkGenerator2.func_230356_f_() - this.field_75074_b.field_78894_e + this.field_75074_b.func_78882_c() / 2 - -5;
                this.field_75074_b.func_78886_a(0, \u2603, 0);
                for (StructurePiece structurePiece : this.field_75075_a) {
                    structurePiece.func_181138_a(0, \u2603, 0);
                }
            } else {
                ChunkGenerator chunkGenerator2;
                this.func_214628_a(chunkGenerator2.func_230356_f_(), this.field_214631_d, 10);
            }
        }
    }

    public static enum Type implements IStringSerializable
    {
        NORMAL("normal"),
        MESA("mesa");

        public static final Codec<Type> field_236324_c_;
        private static final Map<String, Type> field_214717_c;
        private final String field_214718_d;

        private Type(String string2) {
            this.field_214718_d = string2;
        }

        public String func_214714_a() {
            return this.field_214718_d;
        }

        private static Type func_214715_a(String string) {
            return field_214717_c.get(string);
        }

        public static Type func_189910_a(int n) {
            if (n < 0 || n >= Type.values().length) {
                return NORMAL;
            }
            return Type.values()[n];
        }

        @Override
        public String func_176610_l() {
            return this.field_214718_d;
        }

        static {
            field_236324_c_ = IStringSerializable.func_233023_a_(Type::values, Type::func_214715_a);
            field_214717_c = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::func_214714_a, type -> type));
        }
    }
}

