/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.jigsaw;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.JigsawReplacementStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SingleJigsawPiece
extends JigsawPiece {
    private static final Codec<Either<ResourceLocation, Template>> field_236837_a_ = Codec.of(SingleJigsawPiece::func_236840_a_, (Decoder)ResourceLocation.field_240908_a_.map(Either::left));
    public static final Codec<SingleJigsawPiece> field_236838_b_ = RecordCodecBuilder.create(instance -> instance.group(SingleJigsawPiece.func_236846_c_(), SingleJigsawPiece.func_236844_b_(), SingleJigsawPiece.func_236848_d_()).apply((Applicative)instance, SingleJigsawPiece::new));
    protected final Either<ResourceLocation, Template> field_236839_c_;
    protected final ImmutableList<StructureProcessor> field_214862_b;

    private static <T> DataResult<T> func_236840_a_(Either<ResourceLocation, Template> either, DynamicOps<T> dynamicOps, T t) {
        Optional optional = either.left();
        if (!optional.isPresent()) {
            return DataResult.error((String)"Can not serialize a runtime pool element");
        }
        return ResourceLocation.field_240908_a_.encode(optional.get(), dynamicOps, t);
    }

    protected static <E extends SingleJigsawPiece> RecordCodecBuilder<E, List<StructureProcessor>> func_236844_b_() {
        return IStructureProcessorType.field_237137_i_.listOf().fieldOf("processors").forGetter(singleJigsawPiece -> singleJigsawPiece.field_214862_b);
    }

    protected static <E extends SingleJigsawPiece> RecordCodecBuilder<E, Either<ResourceLocation, Template>> func_236846_c_() {
        return field_236837_a_.fieldOf("location").forGetter(singleJigsawPiece -> singleJigsawPiece.field_236839_c_);
    }

    @Deprecated
    public SingleJigsawPiece(String string, List<StructureProcessor> list) {
        this((Either<ResourceLocation, Template>)Either.left((Object)new ResourceLocation(string)), list, JigsawPattern.PlacementBehaviour.RIGID);
    }

    protected SingleJigsawPiece(Either<ResourceLocation, Template> either, List<StructureProcessor> list, JigsawPattern.PlacementBehaviour placementBehaviour) {
        super(placementBehaviour);
        this.field_236839_c_ = either;
        this.field_214862_b = ImmutableList.copyOf(list);
    }

    public SingleJigsawPiece(Template template, List<StructureProcessor> list, JigsawPattern.PlacementBehaviour placementBehaviour) {
        this((Either<ResourceLocation, Template>)Either.right((Object)template), list, placementBehaviour);
    }

    @Deprecated
    public SingleJigsawPiece(String string) {
        this(string, (List<StructureProcessor>)ImmutableList.of());
    }

    private Template func_236843_a_(TemplateManager templateManager) {
        return (Template)this.field_236839_c_.map(templateManager::func_200220_a, Function.identity());
    }

    public List<Template.BlockInfo> func_214857_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, boolean bl) {
        Template template = this.func_236843_a_(templateManager);
        List<Template.BlockInfo> \u26032 = template.func_215386_a(blockPos, new PlacementSettings().func_186220_a(rotation), Blocks.field_185779_df, bl);
        ArrayList \u26033 = Lists.newArrayList();
        for (Template.BlockInfo blockInfo : \u26032) {
            if (blockInfo.field_186244_c == null || (\u2603 = StructureMode.valueOf(blockInfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            \u26033.add(blockInfo);
        }
        return \u26033;
    }

    @Override
    public List<Template.BlockInfo> func_214849_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, Random random) {
        Template template = this.func_236843_a_(templateManager);
        List<Template.BlockInfo> \u26032 = template.func_215386_a(blockPos, new PlacementSettings().func_186220_a(rotation), Blocks.field_226904_lY_, true);
        Collections.shuffle(\u26032, random);
        return \u26032;
    }

    @Override
    public MutableBoundingBox func_214852_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation) {
        Template template = this.func_236843_a_(templateManager);
        return template.func_215388_b(new PlacementSettings().func_186220_a(rotation), blockPos);
    }

    @Override
    public boolean func_230378_a_(TemplateManager templateManager, ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos blockPos, BlockPos blockPos2, Rotation rotation, MutableBoundingBox mutableBoundingBox, Random random, boolean bl) {
        Template template = this.func_236843_a_(templateManager);
        if (template.func_237146_a_(iSeedReader, blockPos, blockPos2, \u2603 = this.func_230379_a_(rotation, mutableBoundingBox, bl), random, 18)) {
            List<Template.BlockInfo> list = Template.func_237145_a_(iSeedReader, blockPos, blockPos2, \u2603, this.func_214857_a(templateManager, blockPos, rotation, false));
            for (Template.BlockInfo blockInfo : list) {
                this.func_214846_a(iSeedReader, blockInfo, blockPos, rotation, random, mutableBoundingBox);
            }
            return true;
        }
        return false;
    }

    protected PlacementSettings func_230379_a_(Rotation rotation, MutableBoundingBox mutableBoundingBox, boolean bl) {
        PlacementSettings placementSettings = new PlacementSettings();
        placementSettings.func_186223_a(mutableBoundingBox);
        placementSettings.func_186220_a(rotation);
        placementSettings.func_215223_c(true);
        placementSettings.func_186222_a(false);
        placementSettings.func_215222_a(BlockIgnoreStructureProcessor.field_215204_a);
        placementSettings.func_237133_d_(true);
        if (!bl) {
            placementSettings.func_215222_a(JigsawReplacementStructureProcessor.field_215196_a);
        }
        this.field_214862_b.forEach(placementSettings::func_215222_a);
        this.func_214854_c().func_214937_b().forEach(placementSettings::func_215222_a);
        return placementSettings;
    }

    @Override
    public IJigsawDeserializer<?> func_214853_a() {
        return IJigsawDeserializer.field_214928_b;
    }

    public String toString() {
        return "Single[" + this.field_236839_c_ + "]";
    }
}

