/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.spawner.WorldEntitySpawner;

public final class NoiseChunkGenerator
extends ChunkGenerator {
    public static final Codec<NoiseChunkGenerator> field_236079_d_ = RecordCodecBuilder.create(instance -> instance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(noiseChunkGenerator -> noiseChunkGenerator.field_222542_c), (App)Codec.LONG.fieldOf("seed").stable().forGetter(noiseChunkGenerator -> noiseChunkGenerator.field_236084_w_), (App)DimensionSettings.field_236098_b_.fieldOf("settings").forGetter(noiseChunkGenerator -> noiseChunkGenerator.field_236080_h_)).apply((Applicative)instance, instance.stable(NoiseChunkGenerator::new)));
    private static final float[] field_222561_h = Util.func_200696_a(new float[13824], fArray -> {
        for (int i = 0; i < 24; ++i) {
            for (\u2603 = 0; \u2603 < 24; ++\u2603) {
                for (\u2603 = 0; \u2603 < 24; ++\u2603) {
                    fArray[i * 24 * 24 + \u2603 * 24 + \u2603] = (float)NoiseChunkGenerator.func_222554_b(\u2603 - 12, \u2603 - 12, i - 12);
                }
            }
        }
    });
    private static final float[] field_236081_j_ = Util.func_200696_a(new float[25], fArray -> {
        for (int i = -2; i <= 2; ++i) {
            for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                fArray[i + 2 + (\u2603 + 2) * 5] = \u2603 = 10.0f / MathHelper.func_76129_c((float)(i * i + \u2603 * \u2603) + 0.2f);
            }
        }
    });
    private static final BlockState field_222562_i = Blocks.field_150350_a.func_176223_P();
    private final int field_222563_j;
    private final int field_222564_k;
    private final int field_222565_l;
    private final int field_222566_m;
    private final int field_222567_n;
    protected final SharedSeedRandom field_222558_e;
    private final OctavesNoiseGenerator field_222568_o;
    private final OctavesNoiseGenerator field_222569_p;
    private final OctavesNoiseGenerator field_222570_q;
    private final INoiseGenerator field_222571_r;
    private final OctavesNoiseGenerator field_236082_u_;
    @Nullable
    private final SimplexNoiseGenerator field_236083_v_;
    protected final BlockState field_222559_f;
    protected final BlockState field_222560_g;
    private final long field_236084_w_;
    protected final DimensionSettings field_236080_h_;
    private final int field_236085_x_;

    public NoiseChunkGenerator(BiomeProvider biomeProvider, long l, DimensionSettings dimensionSettings) {
        this(biomeProvider, biomeProvider, l, dimensionSettings);
    }

    private NoiseChunkGenerator(BiomeProvider biomeProvider, BiomeProvider biomeProvider2, long l, DimensionSettings dimensionSettings) {
        super(biomeProvider, biomeProvider2, dimensionSettings.func_236108_a_(), l);
        this.field_236084_w_ = l;
        this.field_236080_h_ = dimensionSettings;
        NoiseSettings noiseSettings = dimensionSettings.func_236113_b_();
        this.field_236085_x_ = noiseSettings.func_236169_a_();
        this.field_222563_j = noiseSettings.func_236175_f_() * 4;
        this.field_222564_k = noiseSettings.func_236174_e_() * 4;
        this.field_222559_f = dimensionSettings.func_236115_c_();
        this.field_222560_g = dimensionSettings.func_236116_d_();
        this.field_222565_l = 16 / this.field_222564_k;
        this.field_222566_m = noiseSettings.func_236169_a_() / this.field_222563_j;
        this.field_222567_n = 16 / this.field_222564_k;
        this.field_222558_e = new SharedSeedRandom(l);
        this.field_222568_o = new OctavesNoiseGenerator(this.field_222558_e, IntStream.rangeClosed(-15, 0));
        this.field_222569_p = new OctavesNoiseGenerator(this.field_222558_e, IntStream.rangeClosed(-15, 0));
        this.field_222570_q = new OctavesNoiseGenerator(this.field_222558_e, IntStream.rangeClosed(-7, 0));
        this.field_222571_r = noiseSettings.func_236178_i_() ? new PerlinNoiseGenerator(this.field_222558_e, IntStream.rangeClosed(-3, 0)) : new OctavesNoiseGenerator(this.field_222558_e, IntStream.rangeClosed(-3, 0));
        this.field_222558_e.func_202423_a(2620);
        this.field_236082_u_ = new OctavesNoiseGenerator(this.field_222558_e, IntStream.rangeClosed(-15, 0));
        if (noiseSettings.func_236180_k_()) {
            SharedSeedRandom sharedSeedRandom = new SharedSeedRandom(l);
            sharedSeedRandom.func_202423_a(17292);
            this.field_236083_v_ = new SimplexNoiseGenerator(sharedSeedRandom);
        } else {
            this.field_236083_v_ = null;
        }
    }

    @Override
    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return field_236079_d_;
    }

    @Override
    public ChunkGenerator func_230349_a_(long l) {
        return new NoiseChunkGenerator(this.field_222542_c.func_230320_a_(l), l, this.field_236080_h_);
    }

    public boolean func_236088_a_(long l, DimensionSettings.Preset preset) {
        return this.field_236084_w_ == l && this.field_236080_h_.func_236109_a_(preset);
    }

    private double func_222552_a(int n, int n2, int n3, double d, double d2, double d3, double d4) {
        \u2603 = 0.0;
        \u2603 = 0.0;
        \u2603 = 0.0;
        boolean bl = true;
        double \u26032 = 1.0;
        for (int i = 0; i < 16; ++i) {
            double d5 = OctavesNoiseGenerator.func_215461_a((double)n * d * \u26032);
            \u2603 = OctavesNoiseGenerator.func_215461_a((double)n2 * d2 * \u26032);
            \u2603 = OctavesNoiseGenerator.func_215461_a((double)n3 * d * \u26032);
            \u2603 = d2 * \u26032;
            ImprovedNoiseGenerator \u26033 = this.field_222568_o.func_215463_a(i);
            if (\u26033 != null) {
                \u2603 += \u26033.func_215456_a(d5, \u2603, \u2603, \u2603, (double)n2 * \u2603) / \u26032;
            }
            if ((\u2603 = this.field_222569_p.func_215463_a(i)) != null) {
                \u2603 += \u2603.func_215456_a(d5, \u2603, \u2603, \u2603, (double)n2 * \u2603) / \u26032;
            }
            if (i < 8 && (\u2603 = this.field_222570_q.func_215463_a(i)) != null) {
                \u2603 += \u2603.func_215456_a(OctavesNoiseGenerator.func_215461_a((double)n * d3 * \u26032), OctavesNoiseGenerator.func_215461_a((double)n2 * d4 * \u26032), OctavesNoiseGenerator.func_215461_a((double)n3 * d3 * \u26032), d4 * \u26032, (double)n2 * d4 * \u26032) / \u26032;
            }
            \u26032 /= 2.0;
        }
        return MathHelper.func_151238_b(\u2603 / 512.0, \u2603 / 512.0, (\u2603 / 10.0 + 1.0) / 2.0);
    }

    private double[] func_222547_b(int n, int n2) {
        double[] dArray = new double[this.field_222566_m + 1];
        this.func_222548_a(dArray, n, n2);
        return dArray;
    }

    private void func_222548_a(double[] dArray, int n, int n2) {
        double \u26039;
        double \u26037;
        double \u26036;
        double \u26038;
        NoiseSettings noiseSettings = this.field_236080_h_.func_236113_b_();
        if (this.field_236083_v_ != null) {
            \u26038 = EndBiomeProvider.func_235317_a_(this.field_236083_v_, n, n2) - 8.0f;
            \u26039 = \u26038 > 0.0 ? 0.25 : 1.0;
        } else {
            float f;
            float f2 = 0.0f;
            f = 0.0f;
            \u2603 = 0.0f;
            int \u26032 = 2;
            int \u26033 = this.func_230356_f_();
            f3 = this.field_222542_c.func_225526_b_(n, \u26033, n2).func_185355_j();
            for (int i = -2; i <= 2; ++i) {
                for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                    float f3;
                    float f4;
                    Biome biome = this.field_222542_c.func_225526_b_(n + i, \u26033, n2 + \u2603);
                    float \u26034 = biome.func_185355_j();
                    float \u26035 = biome.func_185360_m();
                    if (noiseSettings.func_236181_l_() && \u26034 > 0.0f) {
                        f4 = 1.0f + \u26034 * 2.0f;
                        \u2603 = 1.0f + \u26035 * 4.0f;
                    } else {
                        f4 = \u26034;
                        \u2603 = \u26035;
                    }
                    \u2603 = \u26034 > f3 ? 0.5f : 1.0f;
                    \u2603 = \u2603 * field_236081_j_[i + 2 + (\u2603 + 2) * 5] / (f4 + 2.0f);
                    f2 += \u2603 * \u2603;
                    f += f4 * \u2603;
                    \u2603 += \u2603;
                }
            }
            \u2603 = f / \u2603;
            \u2603 = f2 / \u2603;
            \u26036 = \u2603 * 0.5f - 0.125f;
            \u26037 = \u2603 * 0.9f + 0.1f;
            \u26038 = \u26036 * 0.265625;
            \u26039 = 96.0 / \u26037;
        }
        double d = 684.412 * noiseSettings.func_236171_b_().func_236151_a_();
        \u2603 = 684.412 * noiseSettings.func_236171_b_().func_236153_b_();
        \u2603 = d / noiseSettings.func_236171_b_().func_236154_c_();
        \u2603 = \u2603 / noiseSettings.func_236171_b_().func_236155_d_();
        \u26036 = noiseSettings.func_236172_c_().func_236186_a_();
        \u26037 = noiseSettings.func_236172_c_().func_236188_b_();
        \u2603 = noiseSettings.func_236172_c_().func_236189_c_();
        \u2603 = noiseSettings.func_236173_d_().func_236186_a_();
        \u2603 = noiseSettings.func_236173_d_().func_236188_b_();
        \u2603 = noiseSettings.func_236173_d_().func_236189_c_();
        \u2603 = noiseSettings.func_236179_j_() ? this.func_236095_c_(n, n2) : 0.0;
        \u2603 = noiseSettings.func_236176_g_();
        \u2603 = noiseSettings.func_236177_h_();
        for (int i = 0; i <= this.field_222566_m; ++i) {
            double d2 = this.func_222552_a(n, i, n2, d, \u2603, \u2603, \u2603);
            \u2603 = 1.0 - (double)i * 2.0 / (double)this.field_222566_m + \u2603;
            \u2603 = \u2603 * \u2603 + \u2603;
            \u2603 = (\u2603 + \u26038) * \u26039;
            d2 = \u2603 > 0.0 ? (d2 += \u2603 * 4.0) : (d2 += \u2603);
            if (\u26037 > 0.0) {
                \u2603 = ((double)(this.field_222566_m - i) - \u2603) / \u26037;
                d2 = MathHelper.func_151238_b(\u26036, d2, \u2603);
            }
            if (\u2603 > 0.0) {
                \u2603 = ((double)i - \u2603) / \u2603;
                d2 = MathHelper.func_151238_b(\u2603, d2, \u2603);
            }
            dArray[i] = d2;
        }
    }

    private double func_236095_c_(int n, int n2) {
        double d = this.field_236082_u_.func_215462_a(n * 200, 10.0, n2 * 200, 1.0, 0.0, true);
        \u2603 = d < 0.0 ? -d * 0.3 : d;
        \u2603 = \u2603 * 24.575625 - 2.0;
        if (\u2603 < 0.0) {
            return \u2603 * 0.009486607142857142;
        }
        return Math.min(\u2603, 1.0) * 0.006640625;
    }

    @Override
    public int func_222529_a(int n, int n2, Heightmap.Type type) {
        return this.func_236087_a_(n, n2, null, type.func_222684_d());
    }

    @Override
    public IBlockReader func_230348_a_(int n, int n2) {
        BlockState[] blockStateArray = new BlockState[this.field_222566_m * this.field_222563_j];
        this.func_236087_a_(n, n2, blockStateArray, null);
        return new Blockreader(blockStateArray);
    }

    private int func_236087_a_(int n, int n2, @Nullable BlockState[] blockStateArray, @Nullable Predicate<BlockState> predicate) {
        int n3 = Math.floorDiv(n, this.field_222564_k);
        \u2603 = Math.floorDiv(n2, this.field_222564_k);
        \u2603 = Math.floorMod(n, this.field_222564_k);
        \u2603 = Math.floorMod(n2, this.field_222564_k);
        double \u26032 = (double)\u2603 / (double)this.field_222564_k;
        double \u26033 = (double)\u2603 / (double)this.field_222564_k;
        double[][] \u26034 = new double[][]{this.func_222547_b(n3, \u2603), this.func_222547_b(n3, \u2603 + 1), this.func_222547_b(n3 + 1, \u2603), this.func_222547_b(n3 + 1, \u2603 + 1)};
        for (\u2603 = this.field_222566_m - 1; \u2603 >= 0; --\u2603) {
            double d = \u26034[0][\u2603];
            \u2603 = \u26034[1][\u2603];
            \u2603 = \u26034[2][\u2603];
            \u2603 = \u26034[3][\u2603];
            \u2603 = \u26034[0][\u2603 + 1];
            \u2603 = \u26034[1][\u2603 + 1];
            \u2603 = \u26034[2][\u2603 + 1];
            \u2603 = \u26034[3][\u2603 + 1];
            for (int i = this.field_222563_j - 1; i >= 0; --i) {
                double d2 = (double)i / (double)this.field_222563_j;
                \u2603 = MathHelper.func_219807_a(d2, \u26032, \u26033, d, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603);
                int \u26035 = \u2603 * this.field_222563_j + i;
                BlockState \u26036 = this.func_236086_a_(\u2603, \u26035);
                if (blockStateArray != null) {
                    blockStateArray[\u26035] = \u26036;
                }
                if (predicate == null || !predicate.test(\u26036)) continue;
                return \u26035 + 1;
            }
        }
        return 0;
    }

    protected BlockState func_236086_a_(double d, int n) {
        BlockState blockState = d > 0.0 ? this.field_222559_f : (n < this.func_230356_f_() ? this.field_222560_g : field_222562_i);
        return blockState;
    }

    @Override
    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk iChunk2) {
        IChunk iChunk2;
        ChunkPos chunkPos = iChunk2.func_76632_l();
        int \u26032 = chunkPos.field_77276_a;
        int \u26033 = chunkPos.field_77275_b;
        SharedSeedRandom \u26034 = new SharedSeedRandom();
        \u26034.func_202422_a(\u26032, \u26033);
        \u2603 = iChunk2.func_76632_l();
        int \u26035 = \u2603.func_180334_c();
        int \u26036 = \u2603.func_180333_d();
        double \u26037 = 0.0625;
        BlockPos.Mutable \u26038 = new BlockPos.Mutable();
        for (int i = 0; i < 16; ++i) {
            for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                \u2603 = \u26035 + i;
                \u2603 = \u26036 + \u2603;
                \u2603 = iChunk2.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, i, \u2603) + 1;
                double d = this.field_222571_r.func_215460_a((double)\u2603 * 0.0625, (double)\u2603 * 0.0625, 0.0625, (double)i * 0.0625) * 15.0;
                worldGenRegion.func_226691_t_(\u26038.func_181079_c(\u26035 + i, \u2603, \u26036 + \u2603)).func_206854_a(\u26034, iChunk2, \u2603, \u2603, \u2603, d, this.field_222559_f, this.field_222560_g, this.func_230356_f_(), worldGenRegion.func_72905_C());
            }
        }
        this.func_222555_a(iChunk2, \u26034);
    }

    private void func_222555_a(IChunk iChunk, Random random) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int \u26032 = iChunk.func_76632_l().func_180334_c();
        int \u26033 = iChunk.func_76632_l().func_180333_d();
        int \u26034 = this.field_236080_h_.func_236118_f_();
        int \u26035 = this.field_236085_x_ - 1 - this.field_236080_h_.func_236117_e_();
        int \u26036 = 5;
        boolean \u26037 = \u26035 + 4 >= 0 && \u26035 < this.field_236085_x_;
        boolean bl = bl2 = \u26034 + 4 >= 0 && \u26034 < this.field_236085_x_;
        if (!\u26037 && !bl2) {
            return;
        }
        for (BlockPos blockPos : BlockPos.func_191531_b(\u26032, 0, \u26033, \u26032 + 15, 0, \u26033 + 15)) {
            boolean bl2;
            int n;
            if (\u26037) {
                for (n = 0; n < 5; ++n) {
                    if (n > random.nextInt(5)) continue;
                    iChunk.func_177436_a(mutable.func_181079_c(blockPos.func_177958_n(), \u26035 - n, blockPos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
            if (!bl2) continue;
            for (n = 4; n >= 0; --n) {
                if (n > random.nextInt(5)) continue;
                iChunk.func_177436_a(mutable.func_181079_c(blockPos.func_177958_n(), \u26034 + n, blockPos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    @Override
    public void func_230352_b_(IWorld iWorld, StructureManager structureManager, IChunk iChunk2) {
        IChunk iChunk2;
        ObjectArrayList objectArrayList = new ObjectArrayList(10);
        \u2603 = new ObjectArrayList(32);
        ChunkPos \u26032 = iChunk2.func_76632_l();
        int \u26033 = \u26032.field_77276_a;
        int \u26034 = \u26032.field_77275_b;
        int \u26035 = \u26033 << 4;
        int \u26036 = \u26034 << 4;
        for (Structure<?> structure : Structure.field_236384_t_) {
            structureManager.func_235011_a_(SectionPos.func_218156_a(\u26032, 0), structure).forEach(arg_0 -> NoiseChunkGenerator.func_236089_a_(\u26032, (ObjectList)objectArrayList, \u26035, \u26036, (ObjectList)\u2603, arg_0));
        }
        double[][][] dArray = new double[2][this.field_222567_n + 1][this.field_222566_m + 1];
        for (int i = 0; i < this.field_222567_n + 1; ++i) {
            dArray[0][i] = new double[this.field_222566_m + 1];
            this.func_222548_a(dArray[0][i], \u26033 * this.field_222565_l, \u26034 * this.field_222567_n + i);
            dArray[1][i] = new double[this.field_222566_m + 1];
        }
        ChunkPrimer \u26037 = (ChunkPrimer)iChunk2;
        Heightmap \u26038 = \u26037.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap \u26039 = \u26037.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable \u260310 = new BlockPos.Mutable();
        ObjectListIterator \u260311 = objectArrayList.iterator();
        ObjectListIterator \u260312 = \u2603.iterator();
        for (int i = 0; i < this.field_222565_l; ++i) {
            for (\u2603 = 0; \u2603 < this.field_222567_n + 1; ++\u2603) {
                this.func_222548_a(dArray[1][\u2603], \u26033 * this.field_222565_l + i + 1, \u26034 * this.field_222567_n + \u2603);
            }
            for (\u2603 = 0; \u2603 < this.field_222567_n; ++\u2603) {
                ChunkSection chunkSection = \u26037.func_217332_a(15);
                chunkSection.func_222635_a();
                for (int j = this.field_222566_m - 1; j >= 0; --j) {
                    double d = dArray[0][\u2603][j];
                    \u2603 = dArray[0][\u2603 + 1][j];
                    \u2603 = dArray[1][\u2603][j];
                    \u2603 = dArray[1][\u2603 + 1][j];
                    \u2603 = dArray[0][\u2603][j + 1];
                    \u2603 = dArray[0][\u2603 + 1][j + 1];
                    \u2603 = dArray[1][\u2603][j + 1];
                    \u2603 = dArray[1][\u2603 + 1][j + 1];
                    for (int k = this.field_222563_j - 1; k >= 0; --k) {
                        \u2603 = j * this.field_222563_j + k;
                        \u2603 = \u2603 & 0xF;
                        \u2603 = \u2603 >> 4;
                        if (chunkSection.func_222632_g() >> 4 != \u2603) {
                            chunkSection.func_222637_b();
                            chunkSection = \u26037.func_217332_a(\u2603);
                            chunkSection.func_222635_a();
                        }
                        double \u260313 = (double)k / (double)this.field_222563_j;
                        double \u260314 = MathHelper.func_219803_d(\u260313, d, \u2603);
                        double \u260315 = MathHelper.func_219803_d(\u260313, \u2603, \u2603);
                        double \u260316 = MathHelper.func_219803_d(\u260313, \u2603, \u2603);
                        double \u260317 = MathHelper.func_219803_d(\u260313, \u2603, \u2603);
                        for (\u2603 = 0; \u2603 < this.field_222564_k; ++\u2603) {
                            \u2603 = \u26035 + i * this.field_222564_k + \u2603;
                            \u2603 = \u2603 & 0xF;
                            double d2 = (double)\u2603 / (double)this.field_222564_k;
                            \u2603 = MathHelper.func_219803_d(d2, \u260314, \u260315);
                            \u2603 = MathHelper.func_219803_d(d2, \u260316, \u260317);
                            for (int i2 = 0; i2 < this.field_222564_k; ++i2) {
                                int \u260320;
                                int \u260319;
                                \u2603 = \u26036 + \u2603 * this.field_222564_k + i2;
                                \u2603 = \u2603 & 0xF;
                                double d3 = (double)i2 / (double)this.field_222564_k;
                                \u2603 = MathHelper.func_219803_d(d3, \u2603, \u2603);
                                \u2603 = MathHelper.func_151237_a(\u2603 / 200.0, -1.0, 1.0);
                                \u2603 = \u2603 / 2.0 - \u2603 * \u2603 * \u2603 / 24.0;
                                while (\u260311.hasNext()) {
                                    Object object = (StructurePiece)\u260311.next();
                                    MutableBoundingBox \u260318 = ((StructurePiece)object).func_74874_b();
                                    \u260319 = Math.max(0, Math.max(\u260318.field_78897_a - \u2603, \u2603 - \u260318.field_78893_d));
                                    \u260320 = \u2603 - (\u260318.field_78895_b + (object instanceof AbstractVillagePiece ? ((AbstractVillagePiece)object).func_214830_d() : 0));
                                    int \u260321 = Math.max(0, Math.max(\u260318.field_78896_c - \u2603, \u2603 - \u260318.field_78892_f));
                                    \u2603 += NoiseChunkGenerator.func_222556_a(\u260319, \u260320, \u260321) * 0.8;
                                }
                                \u260311.back(objectArrayList.size());
                                while (\u260312.hasNext()) {
                                    object = (JigsawJunction)\u260312.next();
                                    int \u260322 = \u2603 - ((JigsawJunction)object).func_214895_a();
                                    \u260319 = \u2603 - ((JigsawJunction)object).func_214896_b();
                                    \u260320 = \u2603 - ((JigsawJunction)object).func_214893_c();
                                    \u2603 += NoiseChunkGenerator.func_222556_a(\u260322, \u260319, \u260320) * 0.4;
                                }
                                \u260312.back(\u2603.size());
                                object = this.func_236086_a_(\u2603, \u2603);
                                if (object == field_222562_i) continue;
                                if (((AbstractBlock.AbstractBlockState)object).func_185906_d() != 0) {
                                    \u260310.func_181079_c(\u2603, \u2603, \u2603);
                                    \u26037.func_201637_h(\u260310);
                                }
                                chunkSection.func_177484_a(\u2603, \u2603, \u2603, (BlockState)object, false);
                                \u26038.func_202270_a(\u2603, \u2603, \u2603, (BlockState)object);
                                \u26039.func_202270_a(\u2603, \u2603, \u2603, (BlockState)object);
                            }
                        }
                    }
                }
                chunkSection.func_222637_b();
            }
            double[][] dArray2 = dArray[0];
            dArray[0] = dArray[1];
            dArray[1] = dArray2;
        }
    }

    private static double func_222556_a(int n, int n2, int n3) {
        \u2603 = n + 12;
        \u2603 = n2 + 12;
        \u2603 = n3 + 12;
        if (\u2603 < 0 || \u2603 >= 24) {
            return 0.0;
        }
        if (\u2603 < 0 || \u2603 >= 24) {
            return 0.0;
        }
        if (\u2603 < 0 || \u2603 >= 24) {
            return 0.0;
        }
        return field_222561_h[\u2603 * 24 * 24 + \u2603 * 24 + \u2603];
    }

    private static double func_222554_b(int n, int n2, int n3) {
        double d = n * n + n3 * n3;
        \u2603 = (double)n2 + 0.5;
        \u2603 = \u2603 * \u2603;
        \u2603 = Math.pow(Math.E, -(\u2603 / 16.0 + d / 16.0));
        \u2603 = -\u2603 * MathHelper.func_181161_i(\u2603 / 2.0 + d / 2.0) / 2.0;
        return \u2603 * \u2603;
    }

    @Override
    public int func_230355_e_() {
        return this.field_236085_x_;
    }

    @Override
    public int func_230356_f_() {
        return this.field_236080_h_.func_236119_g_();
    }

    @Override
    public List<Biome.SpawnListEntry> func_230353_a_(Biome biome, StructureManager structureManager, EntityClassification entityClassification, BlockPos blockPos) {
        if (structureManager.func_235010_a_(blockPos, true, Structure.field_236374_j_).func_75069_d()) {
            if (entityClassification == EntityClassification.MONSTER) {
                return Structure.field_236374_j_.func_202279_e();
            }
            if (entityClassification == EntityClassification.CREATURE) {
                return Structure.field_236374_j_.func_214469_f();
            }
        }
        if (entityClassification == EntityClassification.MONSTER) {
            if (structureManager.func_235010_a_(blockPos, false, Structure.field_236366_b_).func_75069_d()) {
                return Structure.field_236366_b_.func_202279_e();
            }
            if (structureManager.func_235010_a_(blockPos, false, Structure.field_236376_l_).func_75069_d()) {
                return Structure.field_236376_l_.func_202279_e();
            }
            if (structureManager.func_235010_a_(blockPos, true, Structure.field_236378_n_).func_75069_d()) {
                return Structure.field_236378_n_.func_202279_e();
            }
        }
        return super.func_230353_a_(biome, structureManager, entityClassification, blockPos);
    }

    @Override
    public void func_230354_a_(WorldGenRegion worldGenRegion) {
        if (this.field_236080_h_.func_236120_h_()) {
            return;
        }
        int n = worldGenRegion.func_201679_a();
        \u2603 = worldGenRegion.func_201680_b();
        Biome \u26032 = worldGenRegion.func_226691_t_(new ChunkPos(n, \u2603).func_206849_h());
        SharedSeedRandom \u26033 = new SharedSeedRandom();
        \u26033.func_202424_a(worldGenRegion.func_72905_C(), n << 4, \u2603 << 4);
        WorldEntitySpawner.func_77191_a(worldGenRegion, \u26032, n, \u2603, \u26033);
    }

    private static /* synthetic */ void func_236089_a_(ChunkPos chunkPos, ObjectList objectList3, int n, int n2, ObjectList objectList2, StructureStart structureStart) {
        for (StructurePiece structurePiece : structureStart.func_186161_c()) {
            ObjectList objectList3;
            if (!structurePiece.func_214810_a(chunkPos, 12)) continue;
            if (structurePiece instanceof AbstractVillagePiece) {
                AbstractVillagePiece abstractVillagePiece = (AbstractVillagePiece)structurePiece;
                JigsawPattern.PlacementBehaviour \u26032 = abstractVillagePiece.func_214826_b().func_214854_c();
                if (\u26032 == JigsawPattern.PlacementBehaviour.RIGID) {
                    objectList3.add((Object)abstractVillagePiece);
                }
                for (JigsawJunction jigsawJunction : abstractVillagePiece.func_214829_e()) {
                    int n3 = jigsawJunction.func_214895_a();
                    \u2603 = jigsawJunction.func_214893_c();
                    if (n3 <= n - 12 || \u2603 <= n2 - 12 || n3 >= n + 15 + 12 || \u2603 >= n2 + 15 + 12) continue;
                    objectList2.add((Object)jigsawJunction);
                }
                continue;
            }
            objectList3.add((Object)structurePiece);
        }
    }
}

