/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.RangeCodec;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FillLayerConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlatGenerationSettings {
    private static final Logger field_211404_q = LogManager.getLogger();
    public static final Codec<FlatGenerationSettings> field_236932_a_ = RecordCodecBuilder.create(instance -> instance.group((App)DimensionStructuresSettings.field_236190_a_.fieldOf("structures").forGetter(FlatGenerationSettings::func_236943_d_), (App)FlatLayerInfo.field_236929_a_.listOf().fieldOf("layers").forGetter(FlatGenerationSettings::func_82650_c), (App)Codec.BOOL.fieldOf("lakes").withDefault((Object)false).forGetter(flatGenerationSettings -> flatGenerationSettings.field_236935_l_), (App)Codec.BOOL.fieldOf("features").withDefault((Object)false).forGetter(flatGenerationSettings -> flatGenerationSettings.field_236934_k_), (App)RangeCodec.func_241291_a_(Registry.field_212624_m.fieldOf("biome"), Util.func_240982_a_("Unknown biome, defaulting to plains", arg_0 -> ((Logger)field_211404_q).error(arg_0)), () -> Biomes.field_76772_c).forGetter(flatGenerationSettings -> flatGenerationSettings.field_82654_c)).apply((Applicative)instance, FlatGenerationSettings::new)).stable();
    private static final ConfiguredFeature<?, ?> field_202258_u = Feature.field_202289_ai.func_225566_b_(new BlockStateFeatureConfig(Blocks.field_150355_j.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_(new ChanceConfig(4)));
    private static final ConfiguredFeature<?, ?> field_202259_v = Feature.field_202289_ai.func_225566_b_(new BlockStateFeatureConfig(Blocks.field_150353_l.func_176223_P())).func_227228_a_(Placement.field_215005_D.func_227446_a_(new ChanceConfig(80)));
    private static final Map<Structure<?>, StructureFeature<?, ?>> field_202247_j = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put(Structure.field_236367_c_, DefaultBiomeFeatures.field_235150_b_);
        hashMap.put(Structure.field_236381_q_, DefaultBiomeFeatures.field_235182_t_);
        hashMap.put(Structure.field_236375_k_, DefaultBiomeFeatures.field_235173_k_);
        hashMap.put(Structure.field_236374_j_, DefaultBiomeFeatures.field_235172_j_);
        hashMap.put(Structure.field_236370_f_, DefaultBiomeFeatures.field_235168_f_);
        hashMap.put(Structure.field_236369_e_, DefaultBiomeFeatures.field_235167_e_);
        hashMap.put(Structure.field_236371_g_, DefaultBiomeFeatures.field_235169_g_);
        hashMap.put(Structure.field_236377_m_, DefaultBiomeFeatures.field_235175_m_);
        hashMap.put(Structure.field_236373_i_, DefaultBiomeFeatures.field_235170_h_);
        hashMap.put(Structure.field_236376_l_, DefaultBiomeFeatures.field_235174_l_);
        hashMap.put(Structure.field_236379_o_, DefaultBiomeFeatures.field_235179_q_);
        hashMap.put(Structure.field_236368_d_, DefaultBiomeFeatures.field_235166_d_);
        hashMap.put(Structure.field_236378_n_, DefaultBiomeFeatures.field_235177_o_);
        hashMap.put(Structure.field_236366_b_, DefaultBiomeFeatures.field_235134_a_);
        hashMap.put(Structure.field_236372_h_, DefaultBiomeFeatures.field_235187_y_);
        hashMap.put(Structure.field_236383_s_, DefaultBiomeFeatures.field_235181_s_);
    });
    private final DimensionStructuresSettings field_236933_f_;
    private final List<FlatLayerInfo> field_82655_a = Lists.newArrayList();
    private Biome field_82654_c;
    private final BlockState[] field_202244_C = new BlockState[256];
    private boolean field_202245_D;
    private boolean field_236934_k_ = false;
    private boolean field_236935_l_ = false;

    public FlatGenerationSettings(DimensionStructuresSettings dimensionStructuresSettings, List<FlatLayerInfo> list, boolean bl, boolean bl2, Biome biome) {
        this(dimensionStructuresSettings);
        if (bl) {
            this.func_236941_b_();
        }
        if (bl2) {
            this.func_236936_a_();
        }
        this.field_82655_a.addAll(list);
        this.func_82645_d();
        this.field_82654_c = biome;
    }

    public FlatGenerationSettings(DimensionStructuresSettings dimensionStructuresSettings) {
        this.field_236933_f_ = dimensionStructuresSettings;
    }

    public FlatGenerationSettings func_236937_a_(DimensionStructuresSettings dimensionStructuresSettings) {
        return this.func_241527_a_(this.field_82655_a, dimensionStructuresSettings);
    }

    public FlatGenerationSettings func_241527_a_(List<FlatLayerInfo> list, DimensionStructuresSettings dimensionStructuresSettings) {
        FlatGenerationSettings flatGenerationSettings = new FlatGenerationSettings(dimensionStructuresSettings);
        for (FlatLayerInfo flatLayerInfo : list) {
            flatGenerationSettings.field_82655_a.add(new FlatLayerInfo(flatLayerInfo.func_82657_a(), flatLayerInfo.func_175900_c().func_177230_c()));
            flatGenerationSettings.func_82645_d();
        }
        flatGenerationSettings.func_82647_a(this.field_82654_c);
        if (this.field_236934_k_) {
            flatGenerationSettings.func_236936_a_();
        }
        if (this.field_236935_l_) {
            flatGenerationSettings.func_236941_b_();
        }
        return flatGenerationSettings;
    }

    public void func_236936_a_() {
        this.field_236934_k_ = true;
    }

    public void func_236941_b_() {
        this.field_236935_l_ = true;
    }

    public Biome func_236942_c_() {
        boolean bl;
        Biome biome2 = this.func_82648_a();
        Biome biome = new Biome(new Biome.Builder().func_205416_a(biome2.func_205401_q()).func_205415_a(biome2.func_201851_b()).func_205419_a(biome2.func_201856_r()).func_205421_a(biome2.func_185355_j()).func_205420_b(biome2.func_185360_m()).func_205414_c(biome2.func_185353_n()).func_205417_d(biome2.func_76727_i()).func_235097_a_(biome2.func_235089_q_()).func_205418_a(biome2.func_205402_s())){};
        if (this.field_236935_l_) {
            biome.func_203611_a(GenerationStage.Decoration.LAKES, field_202258_u);
            biome.func_203611_a(GenerationStage.Decoration.LAKES, field_202259_v);
        }
        for (Map.Entry<Structure<?>, StructureSeparationSettings> entry : this.field_236933_f_.func_236195_a_().entrySet()) {
            biome.func_235063_a_(biome2.func_235068_b_(field_202247_j.get(entry.getKey())));
        }
        boolean bl2 = bl = (!this.field_202245_D || biome2 == Biomes.field_185440_P) && this.field_236934_k_;
        if (bl) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
            arrayList.add(GenerationStage.Decoration.SURFACE_STRUCTURES);
            for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
                if (arrayList.contains(decoration)) continue;
                for (ConfiguredFeature<?, ?> configuredFeature : biome2.func_203607_a(decoration)) {
                    biome.func_203611_a(decoration, configuredFeature);
                }
            }
        }
        BlockState[] blockStateArray = this.func_202233_q();
        for (int i = 0; i < blockStateArray.length; ++i) {
            BlockState blockState = blockStateArray[i];
            if (blockState == null || Heightmap.Type.MOTION_BLOCKING.func_222684_d().test(blockState)) continue;
            this.field_202244_C[i] = null;
            biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, Feature.field_214486_aN.func_225566_b_(new FillLayerConfig(i, blockState)));
        }
        return biome;
    }

    public DimensionStructuresSettings func_236943_d_() {
        return this.field_236933_f_;
    }

    public Biome func_82648_a() {
        return this.field_82654_c;
    }

    public void func_82647_a(Biome biome) {
        this.field_82654_c = biome;
    }

    public List<FlatLayerInfo> func_82650_c() {
        return this.field_82655_a;
    }

    public BlockState[] func_202233_q() {
        return this.field_202244_C;
    }

    public void func_82645_d() {
        Arrays.fill(this.field_202244_C, 0, this.field_202244_C.length, null);
        int n = 0;
        for (FlatLayerInfo flatLayerInfo : this.field_82655_a) {
            flatLayerInfo.func_82660_d(n);
            n += flatLayerInfo.func_82657_a();
        }
        this.field_202245_D = true;
        for (FlatLayerInfo flatLayerInfo : this.field_82655_a) {
            for (int i = flatLayerInfo.func_82656_d(); i < flatLayerInfo.func_82656_d() + flatLayerInfo.func_82657_a(); ++i) {
                BlockState blockState = flatLayerInfo.func_175900_c();
                if (blockState.func_203425_a(Blocks.field_150350_a)) continue;
                this.field_202245_D = false;
                this.field_202244_C[i] = blockState;
            }
        }
    }

    public static FlatGenerationSettings func_82649_e() {
        DimensionStructuresSettings dimensionStructuresSettings = new DimensionStructuresSettings(Optional.of(DimensionStructuresSettings.field_236192_c_), Maps.newHashMap((Map)ImmutableMap.of(Structure.field_236381_q_, (Object)DimensionStructuresSettings.field_236191_b_.get(Structure.field_236381_q_))));
        FlatGenerationSettings \u26032 = new FlatGenerationSettings(dimensionStructuresSettings);
        \u26032.func_82647_a(Biomes.field_76772_c);
        \u26032.func_82650_c().add(new FlatLayerInfo(1, Blocks.field_150357_h));
        \u26032.func_82650_c().add(new FlatLayerInfo(2, Blocks.field_150346_d));
        \u26032.func_82650_c().add(new FlatLayerInfo(1, Blocks.field_196658_i));
        \u26032.func_82645_d();
        return \u26032;
    }
}

