/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import java.util.Optional;
import net.minecraft.util.Unit;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class TextProcessing {
    private static final Optional<Object> field_238336_a_ = Optional.of(Unit.INSTANCE);

    private static boolean func_238344_a_(Style style, ICharacterConsumer iCharacterConsumer, int n, char c) {
        if (Character.isSurrogate(c)) {
            return iCharacterConsumer.onChar(n, style, 65533);
        }
        return iCharacterConsumer.onChar(n, style, c);
    }

    public static boolean func_238341_a_(String string, Style style, ICharacterConsumer iCharacterConsumer) {
        int n = string.length();
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            char c = string.charAt(\u2603);
            if (Character.isHighSurrogate(c)) {
                if (\u2603 + 1 >= n) {
                    if (iCharacterConsumer.onChar(\u2603, style, 65533)) break;
                    return false;
                }
                \u2603 = string.charAt(\u2603 + 1);
                if (Character.isLowSurrogate(\u2603)) {
                    if (!iCharacterConsumer.onChar(\u2603, style, Character.toCodePoint(c, \u2603))) {
                        return false;
                    }
                    ++\u2603;
                    continue;
                }
                if (iCharacterConsumer.onChar(\u2603, style, 65533)) continue;
                return false;
            }
            if (TextProcessing.func_238344_a_(style, iCharacterConsumer, \u2603, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean func_238345_b_(String string, Style style, ICharacterConsumer iCharacterConsumer) {
        int n = string.length();
        for (\u2603 = n - 1; \u2603 >= 0; --\u2603) {
            char c = string.charAt(\u2603);
            if (Character.isLowSurrogate(c)) {
                if (\u2603 - 1 < 0) {
                    if (iCharacterConsumer.onChar(0, style, 65533)) break;
                    return false;
                }
                \u2603 = string.charAt(\u2603 - 1);
                if (!(Character.isHighSurrogate(\u2603) ? !iCharacterConsumer.onChar(--\u2603, style, Character.toCodePoint(\u2603, c)) : !iCharacterConsumer.onChar(\u2603, style, 65533))) continue;
                return false;
            }
            if (TextProcessing.func_238344_a_(style, iCharacterConsumer, \u2603, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean func_238346_c_(String string, Style style, ICharacterConsumer iCharacterConsumer) {
        return TextProcessing.func_238339_a_(string, 0, style, iCharacterConsumer);
    }

    public static boolean func_238339_a_(String string, int n, Style style, ICharacterConsumer iCharacterConsumer) {
        return TextProcessing.func_238340_a_(string, n, style, style, iCharacterConsumer);
    }

    public static boolean func_238340_a_(String string, int n, Style style, Style style2, ICharacterConsumer iCharacterConsumer) {
        int n2 = string.length();
        Style \u26032 = style;
        for (\u2603 = n; \u2603 < n2; ++\u2603) {
            char c = string.charAt(\u2603);
            if (c == '\u00a7') {
                if (\u2603 + 1 >= n2) break;
                \u2603 = string.charAt(\u2603 + 1);
                TextFormatting textFormatting = TextFormatting.func_211165_a(\u2603);
                if (textFormatting != null) {
                    \u26032 = textFormatting == TextFormatting.RESET ? style2 : \u26032.func_240723_c_(textFormatting);
                }
                ++\u2603;
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                if (\u2603 + 1 >= n2) {
                    if (iCharacterConsumer.onChar(\u2603, \u26032, 65533)) break;
                    return false;
                }
                \u2603 = string.charAt(\u2603 + 1);
                if (Character.isLowSurrogate(\u2603)) {
                    if (!iCharacterConsumer.onChar(\u2603, \u26032, Character.toCodePoint(c, \u2603))) {
                        return false;
                    }
                    ++\u2603;
                    continue;
                }
                if (iCharacterConsumer.onChar(\u2603, \u26032, 65533)) continue;
                return false;
            }
            if (TextProcessing.func_238344_a_(\u26032, iCharacterConsumer, \u2603, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean func_238343_a_(ITextProperties iTextProperties, Style style2, ICharacterConsumer iCharacterConsumer) {
        return !iTextProperties.func_230439_a_((style, string) -> TextProcessing.func_238339_a_(string, 0, style, iCharacterConsumer) ? Optional.empty() : field_238336_a_, style2).isPresent();
    }

    public static String func_238338_a_(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        TextProcessing.func_238341_a_(string, Style.field_240709_b_, (n, style, n2) -> {
            stringBuilder.appendCodePoint(n2);
            return true;
        });
        return stringBuilder.toString();
    }

    @FunctionalInterface
    public static interface ICharacterConsumer {
        public boolean onChar(int var1, Style var2, int var3);
    }
}

