/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITargetedTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;

public class TextComponentUtils {
    public static IFormattableTextComponent func_240648_a_(IFormattableTextComponent iFormattableTextComponent, Style style) {
        if (style.func_150229_g()) {
            return iFormattableTextComponent;
        }
        \u2603 = iFormattableTextComponent.func_150256_b();
        if (\u2603.func_150229_g()) {
            return iFormattableTextComponent.func_230530_a_(style);
        }
        if (\u2603.equals(style)) {
            return iFormattableTextComponent;
        }
        return iFormattableTextComponent.func_230530_a_(\u2603.func_240717_a_(style));
    }

    public static IFormattableTextComponent func_240645_a_(@Nullable CommandSource commandSource, ITextComponent iTextComponent, @Nullable Entity entity, int n) throws CommandSyntaxException {
        if (n > 100) {
            return iTextComponent.func_230532_e_();
        }
        IFormattableTextComponent iFormattableTextComponent = iTextComponent instanceof ITargetedTextComponent ? ((ITargetedTextComponent)((Object)iTextComponent)).func_230535_a_(commandSource, entity, n + 1) : iTextComponent.func_230531_f_();
        for (ITextComponent iTextComponent2 : iTextComponent.func_150253_a()) {
            iFormattableTextComponent.func_230529_a_(TextComponentUtils.func_240645_a_(commandSource, iTextComponent2, entity, n + 1));
        }
        return iFormattableTextComponent.func_240703_c_(TextComponentUtils.func_240646_a_(commandSource, iTextComponent.func_150256_b(), entity, n));
    }

    private static Style func_240646_a_(@Nullable CommandSource commandSource, Style style, @Nullable Entity entity, int n) throws CommandSyntaxException {
        HoverEvent hoverEvent = style.func_150210_i();
        if (hoverEvent != null && (\u2603 = hoverEvent.func_240662_a_(HoverEvent.Action.field_230550_a_)) != null) {
            \u2603 = new HoverEvent(HoverEvent.Action.field_230550_a_, TextComponentUtils.func_240645_a_(commandSource, \u2603, entity, n + 1));
            return style.func_240716_a_(\u2603);
        }
        return style;
    }

    public static ITextComponent func_197679_a(GameProfile gameProfile) {
        if (gameProfile.getName() != null) {
            return new StringTextComponent(gameProfile.getName());
        }
        if (gameProfile.getId() != null) {
            return new StringTextComponent(gameProfile.getId().toString());
        }
        return new StringTextComponent("(unknown)");
    }

    public static ITextComponent func_197678_a(Collection<String> collection) {
        return TextComponentUtils.func_197675_a(collection, string -> new StringTextComponent((String)string).func_240699_a_(TextFormatting.GREEN));
    }

    public static <T extends Comparable<T>> ITextComponent func_197675_a(Collection<T> collection, Function<T, ITextComponent> function) {
        if (collection.isEmpty()) {
            return StringTextComponent.field_240750_d_;
        }
        if (collection.size() == 1) {
            return function.apply(collection.iterator().next());
        }
        ArrayList arrayList = Lists.newArrayList(collection);
        arrayList.sort(Comparable::compareTo);
        return TextComponentUtils.func_240649_b_(arrayList, function);
    }

    public static <T> IFormattableTextComponent func_240649_b_(Collection<T> collection, Function<T, ITextComponent> function) {
        if (collection.isEmpty()) {
            return new StringTextComponent("");
        }
        if (collection.size() == 1) {
            return function.apply(collection.iterator().next()).func_230532_e_();
        }
        StringTextComponent stringTextComponent = new StringTextComponent("");
        boolean \u26032 = true;
        for (T t : collection) {
            if (!\u26032) {
                stringTextComponent.func_230529_a_(new StringTextComponent(", ").func_240699_a_(TextFormatting.GRAY));
            }
            stringTextComponent.func_230529_a_(function.apply(t));
            \u26032 = false;
        }
        return stringTextComponent;
    }

    public static IFormattableTextComponent func_240647_a_(ITextComponent iTextComponent) {
        return new StringTextComponent("[").func_230529_a_(iTextComponent).func_240702_b_("]");
    }

    public static ITextComponent func_202465_a(Message message) {
        if (message instanceof ITextComponent) {
            return (ITextComponent)message;
        }
        return new StringTextComponent(message.getString());
    }
}

