/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.NBTTextComponent;
import net.minecraft.util.text.ScoreTextComponent;
import net.minecraft.util.text.SelectorTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public interface ITextComponent
extends Message,
ITextProperties {
    public Style func_150256_b();

    public String func_150261_e();

    @Override
    default public String getString() {
        return ITextProperties.super.getString();
    }

    default public String func_212636_a(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        this.func_230438_a_(string -> {
            int n2 = n - stringBuilder.length();
            if (n2 <= 0) {
                return field_240650_b_;
            }
            stringBuilder.append(string.length() <= n2 ? string : string.substring(0, n2));
            return Optional.empty();
        });
        return stringBuilder.toString();
    }

    public List<ITextComponent> func_150253_a();

    public IFormattableTextComponent func_230531_f_();

    public IFormattableTextComponent func_230532_e_();

    @Override
    default public <T> Optional<T> func_230439_a_(ITextProperties.IStyledTextAcceptor<T> iStyledTextAcceptor, Style style) {
        \u2603 = this.func_150256_b().func_240717_a_(style);
        Optional<T> optional = this.func_230534_b_(iStyledTextAcceptor, \u2603);
        if (optional.isPresent()) {
            return optional;
        }
        for (ITextComponent iTextComponent : this.func_150253_a()) {
            Optional<T> optional2 = iTextComponent.func_230439_a_(iStyledTextAcceptor, \u2603);
            if (!optional2.isPresent()) continue;
            return optional2;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> func_230438_a_(ITextProperties.ITextAcceptor<T> iTextAcceptor) {
        Optional<T> optional = this.func_230533_b_(iTextAcceptor);
        if (optional.isPresent()) {
            return optional;
        }
        for (ITextComponent iTextComponent : this.func_150253_a()) {
            Optional<T> optional2 = iTextComponent.func_230438_a_(iTextAcceptor);
            if (!optional2.isPresent()) continue;
            return optional2;
        }
        return Optional.empty();
    }

    default public <T> Optional<T> func_230534_b_(ITextProperties.IStyledTextAcceptor<T> iStyledTextAcceptor, Style style) {
        return iStyledTextAcceptor.accept(style, this.func_150261_e());
    }

    default public <T> Optional<T> func_230533_b_(ITextProperties.ITextAcceptor<T> iTextAcceptor) {
        return iTextAcceptor.accept(this.func_150261_e());
    }

    public static ITextComponent func_241827_a_(@Nullable String string) {
        return string != null ? new StringTextComponent(string) : StringTextComponent.field_240750_d_;
    }

    public static class Serializer
    implements JsonDeserializer<IFormattableTextComponent>,
    JsonSerializer<ITextComponent> {
        private static final Gson field_150700_a = Util.func_199748_a(() -> {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.disableHtmlEscaping();
            gsonBuilder.registerTypeHierarchyAdapter(ITextComponent.class, (Object)new Serializer());
            gsonBuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
            gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory());
            return gsonBuilder.create();
        });
        private static final Field field_197674_b = Util.func_199748_a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", noSuchFieldException);
            }
        });
        private static final Field field_200530_c = Util.func_199748_a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", noSuchFieldException);
            }
        });

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IFormattableTextComponent deserialize(JsonElement jsonElement2, Type type, JsonDeserializationContext jsonDeserializationContext2) throws JsonParseException {
            void var5_19;
            JsonElement jsonElement2;
            if (jsonElement2.isJsonPrimitive()) {
                return new StringTextComponent(jsonElement2.getAsString());
            }
            if (jsonElement2.isJsonObject()) {
                JsonDeserializationContext jsonDeserializationContext2;
                void var5_17;
                String string;
                JsonObject jsonObject = jsonElement2.getAsJsonObject();
                if (jsonObject.has("text")) {
                    StringTextComponent stringTextComponent = new StringTextComponent(JSONUtils.func_151200_h(jsonObject, "text"));
                } else if (jsonObject.has("translate")) {
                    string = JSONUtils.func_151200_h(jsonObject, "translate");
                    if (jsonObject.has("with")) {
                        JsonArray jsonArray = JSONUtils.func_151214_t(jsonObject, "with");
                        Object[] \u26032 = new Object[jsonArray.size()];
                        for (int i = 0; i < \u26032.length; ++i) {
                            \u26032[i] = this.deserialize(jsonArray.get(i), type, jsonDeserializationContext2);
                            if (!(\u26032[i] instanceof StringTextComponent) || !(\u2603 = (StringTextComponent)\u26032[i]).func_150256_b().func_150229_g() || !\u2603.func_150253_a().isEmpty()) continue;
                            \u26032[i] = \u2603.func_150265_g();
                        }
                        TranslationTextComponent translationTextComponent = new TranslationTextComponent(string, \u26032);
                    } else {
                        TranslationTextComponent translationTextComponent = new TranslationTextComponent(string);
                    }
                } else if (jsonObject.has("score")) {
                    string = JSONUtils.func_152754_s(jsonObject, "score");
                    if (!string.has("name") || !string.has("objective")) throw new JsonParseException("A score component needs a least a name and an objective");
                    ScoreTextComponent scoreTextComponent = new ScoreTextComponent(JSONUtils.func_151200_h((JsonObject)string, "name"), JSONUtils.func_151200_h((JsonObject)string, "objective"));
                } else if (jsonObject.has("selector")) {
                    SelectorTextComponent selectorTextComponent = new SelectorTextComponent(JSONUtils.func_151200_h(jsonObject, "selector"));
                } else if (jsonObject.has("keybind")) {
                    KeybindTextComponent keybindTextComponent = new KeybindTextComponent(JSONUtils.func_151200_h(jsonObject, "keybind"));
                } else {
                    if (!jsonObject.has("nbt")) throw new JsonParseException("Don't know how to turn " + jsonElement2 + " into a Component");
                    string = JSONUtils.func_151200_h(jsonObject, "nbt");
                    boolean \u26033 = JSONUtils.func_151209_a(jsonObject, "interpret", false);
                    if (jsonObject.has("block")) {
                        NBTTextComponent.Block block = new NBTTextComponent.Block(string, \u26033, JSONUtils.func_151200_h(jsonObject, "block"));
                    } else if (jsonObject.has("entity")) {
                        NBTTextComponent.Entity entity = new NBTTextComponent.Entity(string, \u26033, JSONUtils.func_151200_h(jsonObject, "entity"));
                    } else {
                        if (!jsonObject.has("storage")) throw new JsonParseException("Don't know how to turn " + jsonElement2 + " into a Component");
                        NBTTextComponent.Storage storage = new NBTTextComponent.Storage(string, \u26033, new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "storage")));
                    }
                }
                if (jsonObject.has("extra")) {
                    string = JSONUtils.func_151214_t(jsonObject, "extra");
                    if (string.size() <= 0) throw new JsonParseException("Unexpected empty array of components");
                    for (int i = 0; i < string.size(); ++i) {
                        var5_17.func_230529_a_(this.deserialize(string.get(i), type, jsonDeserializationContext2));
                    }
                }
                var5_17.func_230530_a_((Style)jsonDeserializationContext2.deserialize(jsonElement2, Style.class));
                return var5_17;
            }
            if (!jsonElement2.isJsonArray()) throw new JsonParseException("Don't know how to turn " + jsonElement2 + " into a Component");
            JsonArray \u26034 = jsonElement2.getAsJsonArray();
            Object var5_18 = null;
            for (JsonElement jsonElement3 : \u26034) {
                IFormattableTextComponent iFormattableTextComponent = this.deserialize(jsonElement3, jsonElement3.getClass(), jsonDeserializationContext2);
                if (var5_19 == null) {
                    IFormattableTextComponent iFormattableTextComponent2 = iFormattableTextComponent;
                    continue;
                }
                var5_19.func_230529_a_(iFormattableTextComponent);
            }
            return var5_19;
        }

        private void func_150695_a(Style style, JsonObject jsonObject, JsonSerializationContext jsonSerializationContext) {
            JsonElement jsonElement = jsonSerializationContext.serialize((Object)style);
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject2 = (JsonObject)jsonElement;
                for (Map.Entry entry : jsonObject2.entrySet()) {
                    jsonObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JsonElement serialize(ITextComponent iTextComponent2, Type type, JsonSerializationContext jsonSerializationContext) {
            ITextComponent iTextComponent2;
            Object \u26032;
            JsonObject jsonObject = new JsonObject();
            if (!iTextComponent2.func_150256_b().func_150229_g()) {
                this.func_150695_a(iTextComponent2.func_150256_b(), jsonObject, jsonSerializationContext);
            }
            if (!iTextComponent2.func_150253_a().isEmpty()) {
                \u26032 = new JsonArray();
                for (ITextComponent iTextComponent3 : iTextComponent2.func_150253_a()) {
                    \u26032.add(this.serialize(iTextComponent3, iTextComponent3.getClass(), jsonSerializationContext));
                }
                jsonObject.add("extra", (JsonElement)\u26032);
            }
            if (iTextComponent2 instanceof StringTextComponent) {
                jsonObject.addProperty("text", ((StringTextComponent)iTextComponent2).func_150265_g());
                return jsonObject;
            } else if (iTextComponent2 instanceof TranslationTextComponent) {
                \u26032 = (TranslationTextComponent)iTextComponent2;
                jsonObject.addProperty("translate", ((TranslationTextComponent)\u26032).func_150268_i());
                if (((TranslationTextComponent)\u26032).func_150271_j() == null || ((TranslationTextComponent)\u26032).func_150271_j().length <= 0) return jsonObject;
                \u26033 = new JsonArray();
                for (Object object : ((TranslationTextComponent)\u26032).func_150271_j()) {
                    if (object instanceof ITextComponent) {
                        \u26033.add(this.serialize((ITextComponent)object, object.getClass(), jsonSerializationContext));
                        continue;
                    }
                    \u26033.add((JsonElement)new JsonPrimitive(String.valueOf(object)));
                }
                jsonObject.add("with", (JsonElement)\u26033);
                return jsonObject;
            } else if (iTextComponent2 instanceof ScoreTextComponent) {
                \u26032 = (ScoreTextComponent)iTextComponent2;
                \u26033 = new JsonObject();
                \u26033.addProperty("name", ((ScoreTextComponent)\u26032).func_179995_g());
                \u26033.addProperty("objective", ((ScoreTextComponent)\u26032).func_179994_h());
                jsonObject.add("score", (JsonElement)\u26033);
                return jsonObject;
            } else if (iTextComponent2 instanceof SelectorTextComponent) {
                \u26032 = (SelectorTextComponent)iTextComponent2;
                jsonObject.addProperty("selector", ((SelectorTextComponent)\u26032).func_179992_g());
                return jsonObject;
            } else if (iTextComponent2 instanceof KeybindTextComponent) {
                \u26032 = (KeybindTextComponent)iTextComponent2;
                jsonObject.addProperty("keybind", ((KeybindTextComponent)\u26032).func_193633_h());
                return jsonObject;
            } else {
                Object \u26033;
                if (!(iTextComponent2 instanceof NBTTextComponent)) throw new IllegalArgumentException("Don't know how to serialize " + iTextComponent2 + " as a Component");
                \u26032 = (NBTTextComponent)iTextComponent2;
                jsonObject.addProperty("nbt", ((NBTTextComponent)\u26032).func_218676_i());
                jsonObject.addProperty("interpret", Boolean.valueOf(((NBTTextComponent)\u26032).func_218677_j()));
                if (iTextComponent2 instanceof NBTTextComponent.Block) {
                    \u26033 = (NBTTextComponent.Block)iTextComponent2;
                    jsonObject.addProperty("block", ((NBTTextComponent.Block)\u26033).func_218683_k());
                    return jsonObject;
                } else if (iTextComponent2 instanceof NBTTextComponent.Entity) {
                    \u26033 = (NBTTextComponent.Entity)iTextComponent2;
                    jsonObject.addProperty("entity", ((NBTTextComponent.Entity)\u26033).func_218687_k());
                    return jsonObject;
                } else {
                    if (!(iTextComponent2 instanceof NBTTextComponent.Storage)) throw new IllegalArgumentException("Don't know how to serialize " + iTextComponent2 + " as a Component");
                    \u26033 = (NBTTextComponent.Storage)iTextComponent2;
                    jsonObject.addProperty("storage", ((NBTTextComponent.Storage)\u26033).func_229726_k_().toString());
                }
            }
            return jsonObject;
        }

        public static String func_150696_a(ITextComponent iTextComponent) {
            return field_150700_a.toJson((Object)iTextComponent);
        }

        public static JsonElement func_200528_b(ITextComponent iTextComponent) {
            return field_150700_a.toJsonTree((Object)iTextComponent);
        }

        @Nullable
        public static IFormattableTextComponent func_240643_a_(String string) {
            return JSONUtils.func_188176_a(field_150700_a, string, IFormattableTextComponent.class, false);
        }

        @Nullable
        public static IFormattableTextComponent func_240641_a_(JsonElement jsonElement) {
            return (IFormattableTextComponent)field_150700_a.fromJson(jsonElement, IFormattableTextComponent.class);
        }

        @Nullable
        public static IFormattableTextComponent func_240644_b_(String string) {
            return JSONUtils.func_188176_a(field_150700_a, string, IFormattableTextComponent.class, true);
        }

        public static IFormattableTextComponent func_240642_a_(com.mojang.brigadier.StringReader stringReader) {
            try {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(stringReader.getRemaining()));
                jsonReader.setLenient(false);
                IFormattableTextComponent \u26032 = (IFormattableTextComponent)field_150700_a.getAdapter(IFormattableTextComponent.class).read(jsonReader);
                stringReader.setCursor(stringReader.getCursor() + Serializer.func_197673_a(jsonReader));
                return \u26032;
            }
            catch (IOException | StackOverflowError throwable) {
                throw new JsonParseException(throwable);
            }
        }

        private static int func_197673_a(JsonReader jsonReader) {
            try {
                return field_197674_b.getInt(jsonReader) - field_200530_c.getInt(jsonReader) + 1;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Couldn't read position of JsonReader", illegalAccessException);
            }
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((ITextComponent)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

