/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextProcessing;
import net.minecraft.util.text.TextPropertiesManager;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class CharacterManager {
    private final ICharWidthProvider field_238347_a_;

    public CharacterManager(ICharWidthProvider iCharWidthProvider) {
        this.field_238347_a_ = iCharWidthProvider;
    }

    public float func_238350_a_(@Nullable String string) {
        if (string == null) {
            return 0.0f;
        }
        MutableFloat mutableFloat = new MutableFloat();
        TextProcessing.func_238346_c_(string, Style.field_240709_b_, (n, style, n2) -> {
            mutableFloat.add(this.field_238347_a_.getWidth(n2, style));
            return true;
        });
        return mutableFloat.floatValue();
    }

    public float func_238356_a_(ITextProperties iTextProperties) {
        MutableFloat mutableFloat = new MutableFloat();
        TextProcessing.func_238343_a_(iTextProperties, Style.field_240709_b_, (n, style, n2) -> {
            mutableFloat.add(this.field_238347_a_.getWidth(n2, style));
            return true;
        });
        return mutableFloat.floatValue();
    }

    public int func_238352_a_(String string, int n, Style style) {
        StringWidthProcessor stringWidthProcessor = new StringWidthProcessor(n);
        TextProcessing.func_238341_a_(string, style, stringWidthProcessor);
        return stringWidthProcessor.func_238398_a_();
    }

    public String func_238361_b_(String string, int n, Style style) {
        return string.substring(0, this.func_238352_a_(string, n, style));
    }

    public String func_238364_c_(String string, int n, Style style2) {
        MutableFloat mutableFloat = new MutableFloat();
        MutableInt \u26032 = new MutableInt(string.length());
        TextProcessing.func_238345_b_(string, style2, (n2, style, n3) -> {
            float f = mutableFloat.addAndGet(this.field_238347_a_.getWidth(n3, style));
            if (f > (float)n) {
                return false;
            }
            \u26032.setValue(n2);
            return true;
        });
        return string.substring(\u26032.intValue());
    }

    @Nullable
    public Style func_238357_a_(ITextProperties iTextProperties, int n) {
        StringWidthProcessor stringWidthProcessor = new StringWidthProcessor(n);
        return iTextProperties.func_230439_a_((style, string) -> TextProcessing.func_238346_c_(string, style, stringWidthProcessor) ? Optional.empty() : Optional.of(style), Style.field_240709_b_).orElse(null);
    }

    public ITextProperties func_238358_a_(ITextProperties iTextProperties, int n, Style style) {
        final StringWidthProcessor stringWidthProcessor = new StringWidthProcessor(n);
        return iTextProperties.func_230439_a_(new ITextProperties.IStyledTextAcceptor<ITextProperties>(){
            private final TextPropertiesManager field_238368_c_ = new TextPropertiesManager();

            @Override
            public Optional<ITextProperties> accept(Style style, String string) {
                stringWidthProcessor.func_238399_b_();
                if (!TextProcessing.func_238346_c_(string, style, stringWidthProcessor)) {
                    \u2603 = string.substring(0, stringWidthProcessor.func_238398_a_());
                    if (!\u2603.isEmpty()) {
                        this.field_238368_c_.func_238155_a_(ITextProperties.func_240653_a_(\u2603, style));
                    }
                    return Optional.of(this.field_238368_c_.func_238156_b_());
                }
                if (!string.isEmpty()) {
                    this.field_238368_c_.func_238155_a_(ITextProperties.func_240653_a_(string, style));
                }
                return Optional.empty();
            }
        }, style).orElse(iTextProperties);
    }

    public static int func_238351_a_(String string, int n, int n2, boolean bl) {
        int n3 = n2;
        boolean \u26032 = n < 0;
        \u2603 = Math.abs(n);
        for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
            if (\u26032) {
                while (bl && n3 > 0 && (string.charAt(n3 - 1) == ' ' || string.charAt(n3 - 1) == '\n')) {
                    --n3;
                }
                while (n3 > 0 && string.charAt(n3 - 1) != ' ' && string.charAt(n3 - 1) != '\n') {
                    --n3;
                }
                continue;
            }
            \u2603 = string.length();
            \u2603 = string.indexOf(32, n3);
            \u2603 = string.indexOf(10, n3);
            n3 = \u2603 == -1 && \u2603 == -1 ? -1 : (\u2603 != -1 && \u2603 != -1 ? Math.min(\u2603, \u2603) : (\u2603 != -1 ? \u2603 : \u2603));
            if (n3 == -1) {
                n3 = \u2603;
                continue;
            }
            while (bl && n3 < \u2603 && (string.charAt(n3) == ' ' || string.charAt(n3) == '\n')) {
                ++n3;
            }
        }
        return n3;
    }

    public void func_238353_a_(String string, int n, Style style, boolean bl, ISliceAcceptor iSliceAcceptor) {
        int \u26037 = 0;
        \u2603 = string.length();
        Style \u26032 = style;
        while (\u26037 < \u2603) {
            MultilineProcessor multilineProcessor = new MultilineProcessor(n);
            boolean \u26033 = TextProcessing.func_238340_a_(string, \u26037, \u26032, style, multilineProcessor);
            if (\u26033) {
                iSliceAcceptor.accept(\u26032, \u26037, \u2603);
                break;
            }
            int \u26034 = multilineProcessor.func_238386_a_();
            char \u26035 = string.charAt(\u26034);
            int \u26036 = \u26035 == '\n' || \u26035 == ' ' ? \u26034 + 1 : \u26034;
            iSliceAcceptor.accept(\u26032, \u26037, bl ? \u26036 : \u26034);
            \u26037 = \u26036;
            \u26032 = multilineProcessor.func_238389_b_();
        }
    }

    public List<ITextProperties> func_238365_g_(String string, int n3, Style style2) {
        ArrayList arrayList = Lists.newArrayList();
        this.func_238353_a_(string, n3, style2, false, (style, n, n2) -> arrayList.add(ITextProperties.func_240653_a_(string.substring(n, n2), style)));
        return arrayList;
    }

    public List<ITextProperties> func_238362_b_(ITextProperties iTextProperties, int n, Style style) {
        return this.func_241570_a_(iTextProperties, n, style, null);
    }

    public List<ITextProperties> func_241570_a_(ITextProperties iTextProperties, int n, Style style2, @Nullable ITextProperties iTextProperties2) {
        Object object;
        ArrayList arrayList = Lists.newArrayList();
        \u2603 = Lists.newArrayList();
        iTextProperties.func_230439_a_((style, string) -> {
            if (!string.isEmpty()) {
                \u2603.add(new StyleOverridingTextComponent(string, style));
            }
            return Optional.empty();
        }, style2);
        SubstyledText \u26032 = new SubstyledText(\u2603);
        boolean \u26033 = true;
        boolean \u26034 = false;
        boolean \u26035 = false;
        block0: while (\u26033) {
            \u26033 = false;
            object = new MultilineProcessor(n);
            for (StyleOverridingTextComponent styleOverridingTextComponent : \u26032.field_238369_a_) {
                boolean bl = TextProcessing.func_238340_a_(styleOverridingTextComponent.field_238391_a_, 0, styleOverridingTextComponent.field_238392_d_, style2, (TextProcessing.ICharacterConsumer)object);
                if (!bl) {
                    int n2 = ((MultilineProcessor)object).func_238386_a_();
                    Style \u26036 = ((MultilineProcessor)object).func_238389_b_();
                    char \u26037 = \u26032.func_238372_a_(n2);
                    boolean \u26038 = \u26037 == '\n';
                    boolean \u26039 = \u26038 || \u26037 == ' ';
                    \u26034 = \u26038;
                    ITextProperties \u260310 = \u26032.func_238373_a_(n2, \u26039 ? 1 : 0, \u26036);
                    arrayList.add(this.func_241571_a_(\u260310, \u26035, iTextProperties2));
                    \u26035 = !\u26038;
                    \u26033 = true;
                    continue block0;
                }
                ((MultilineProcessor)object).func_238387_a_(styleOverridingTextComponent.field_238391_a_.length());
            }
        }
        object = \u26032.func_238371_a_();
        if (object != null) {
            arrayList.add(this.func_241571_a_((ITextProperties)object, \u26035, iTextProperties2));
        } else if (\u26034) {
            arrayList.add(ITextProperties.field_240651_c_);
        }
        return arrayList;
    }

    private ITextProperties func_241571_a_(ITextProperties iTextProperties, boolean bl, ITextProperties iTextProperties2) {
        if (bl && iTextProperties2 != null) {
            return ITextProperties.func_240655_a_(iTextProperties2, iTextProperties);
        }
        return iTextProperties;
    }

    static class SubstyledText {
        private final List<StyleOverridingTextComponent> field_238369_a_;
        private String field_238370_b_;

        public SubstyledText(List<StyleOverridingTextComponent> list) {
            this.field_238369_a_ = list;
            this.field_238370_b_ = list.stream().map(styleOverridingTextComponent -> ((StyleOverridingTextComponent)styleOverridingTextComponent).field_238391_a_).collect(Collectors.joining());
        }

        public char func_238372_a_(int n) {
            return this.field_238370_b_.charAt(n);
        }

        public ITextProperties func_238373_a_(int n3, int n2, Style style) {
            int n3;
            TextPropertiesManager textPropertiesManager = new TextPropertiesManager();
            ListIterator<StyleOverridingTextComponent> \u26032 = this.field_238369_a_.listIterator();
            int \u26033 = n3;
            boolean \u26034 = false;
            while (\u26032.hasNext()) {
                String string;
                StyleOverridingTextComponent styleOverridingTextComponent = \u26032.next();
                String \u26035 = styleOverridingTextComponent.field_238391_a_;
                int \u26036 = \u26035.length();
                if (!\u26034) {
                    if (\u26033 > \u26036) {
                        textPropertiesManager.func_238155_a_(styleOverridingTextComponent);
                        \u26032.remove();
                        \u26033 -= \u26036;
                    } else {
                        string = \u26035.substring(0, \u26033);
                        if (!string.isEmpty()) {
                            textPropertiesManager.func_238155_a_(ITextProperties.func_240653_a_(string, styleOverridingTextComponent.field_238392_d_));
                        }
                        \u26033 += n2;
                        \u26034 = true;
                    }
                }
                if (!\u26034) continue;
                if (\u26033 > \u26036) {
                    \u26032.remove();
                    \u26033 -= \u26036;
                    continue;
                }
                string = \u26035.substring(\u26033);
                if (string.isEmpty()) {
                    \u26032.remove();
                    break;
                }
                \u26032.set(new StyleOverridingTextComponent(string, style));
                break;
            }
            this.field_238370_b_ = this.field_238370_b_.substring(n3 + n2);
            return textPropertiesManager.func_238156_b_();
        }

        @Nullable
        public ITextProperties func_238371_a_() {
            TextPropertiesManager textPropertiesManager = new TextPropertiesManager();
            this.field_238369_a_.forEach(textPropertiesManager::func_238155_a_);
            this.field_238369_a_.clear();
            return textPropertiesManager.func_238154_a_();
        }
    }

    static class StyleOverridingTextComponent
    implements ITextProperties {
        private final String field_238391_a_;
        private final Style field_238392_d_;

        public StyleOverridingTextComponent(String string, Style style) {
            this.field_238391_a_ = string;
            this.field_238392_d_ = style;
        }

        @Override
        public <T> Optional<T> func_230438_a_(ITextProperties.ITextAcceptor<T> iTextAcceptor) {
            return iTextAcceptor.accept(this.field_238391_a_);
        }

        @Override
        public <T> Optional<T> func_230439_a_(ITextProperties.IStyledTextAcceptor<T> iStyledTextAcceptor, Style style) {
            return iStyledTextAcceptor.accept(this.field_238392_d_.func_240717_a_(style), this.field_238391_a_);
        }
    }

    @FunctionalInterface
    public static interface ISliceAcceptor {
        public void accept(Style var1, int var2, int var3);
    }

    class MultilineProcessor
    implements TextProcessing.ICharacterConsumer {
        private final float field_238377_b_;
        private int field_238378_c_ = -1;
        private Style field_238379_d_ = Style.field_240709_b_;
        private boolean field_238380_e_;
        private float field_238381_f_;
        private int field_238382_g_ = -1;
        private Style field_238383_h_ = Style.field_240709_b_;
        private int field_238384_i_;
        private int field_238385_j_;

        public MultilineProcessor(float f) {
            this.field_238377_b_ = Math.max(f, 1.0f);
        }

        @Override
        public boolean onChar(int n, Style style, int n2) {
            \u2603 = n + this.field_238385_j_;
            switch (n2) {
                case 10: {
                    return this.func_238388_a_(\u2603, style);
                }
                case 32: {
                    this.field_238382_g_ = \u2603;
                    this.field_238383_h_ = style;
                }
            }
            float f = CharacterManager.this.field_238347_a_.getWidth(n2, style);
            this.field_238381_f_ += f;
            if (this.field_238380_e_ && this.field_238381_f_ > this.field_238377_b_) {
                if (this.field_238382_g_ != -1) {
                    return this.func_238388_a_(this.field_238382_g_, this.field_238383_h_);
                }
                return this.func_238388_a_(\u2603, style);
            }
            this.field_238380_e_ |= f != 0.0f;
            this.field_238384_i_ = \u2603 + Character.charCount(n2);
            return true;
        }

        private boolean func_238388_a_(int n, Style style) {
            this.field_238378_c_ = n;
            this.field_238379_d_ = style;
            return false;
        }

        private boolean func_238390_c_() {
            return this.field_238378_c_ != -1;
        }

        public int func_238386_a_() {
            return this.func_238390_c_() ? this.field_238378_c_ : this.field_238384_i_;
        }

        public Style func_238389_b_() {
            return this.field_238379_d_;
        }

        public void func_238387_a_(int n) {
            this.field_238385_j_ += n;
        }
    }

    class StringWidthProcessor
    implements TextProcessing.ICharacterConsumer {
        private float field_238396_b_;
        private int field_238397_c_;

        public StringWidthProcessor(float f) {
            this.field_238396_b_ = f;
        }

        @Override
        public boolean onChar(int n, Style style, int n2) {
            this.field_238396_b_ -= CharacterManager.this.field_238347_a_.getWidth(n2, style);
            if (this.field_238396_b_ >= 0.0f) {
                this.field_238397_c_ = n + Character.charCount(n2);
                return true;
            }
            return false;
        }

        public int func_238398_a_() {
            return this.field_238397_c_;
        }

        public void func_238399_b_() {
            this.field_238397_c_ = 0;
        }
    }

    @FunctionalInterface
    public static interface ICharWidthProvider {
        public float getWidth(int var1, Style var2);
    }
}

