/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.RangeCodec;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistryCodec;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleRegistry<T>
extends MutableRegistry<T> {
    protected static final Logger field_148743_a = LogManager.getLogger();
    protected final IntIdentityHashBiMap<T> field_148759_a = new IntIdentityHashBiMap(256);
    protected final BiMap<ResourceLocation, T> field_82596_a = HashBiMap.create();
    private final BiMap<RegistryKey<T>, T> field_239649_bb_ = HashBiMap.create();
    private final Set<RegistryKey<T>> field_239650_bc_ = Sets.newIdentityHashSet();
    protected Object[] field_186802_b;
    private int field_195869_d;

    public SimpleRegistry(RegistryKey<Registry<T>> registryKey, Lifecycle lifecycle) {
        super(registryKey, lifecycle);
    }

    @Override
    public <V extends T> V func_218382_a(int n, RegistryKey<T> registryKey, V v) {
        this.field_148759_a.func_186814_a(v, n);
        Validate.notNull(registryKey);
        Validate.notNull(v);
        this.field_186802_b = null;
        if (this.field_239649_bb_.containsKey(registryKey)) {
            field_148743_a.debug("Adding duplicate key '{}' to registry", registryKey);
        }
        this.field_82596_a.put((Object)registryKey.func_240901_a_(), v);
        this.field_239649_bb_.put(registryKey, v);
        if (this.field_195869_d <= n) {
            this.field_195869_d = n + 1;
        }
        return v;
    }

    @Override
    public <V extends T> V func_218381_a(RegistryKey<T> registryKey, V v) {
        return this.func_218382_a(this.field_195869_d, registryKey, v);
    }

    @Override
    @Nullable
    public ResourceLocation func_177774_c(T t) {
        return (ResourceLocation)this.field_82596_a.inverse().get(t);
    }

    @Override
    public Optional<RegistryKey<T>> func_230519_c_(T t) {
        return Optional.ofNullable(this.field_239649_bb_.inverse().get(t));
    }

    @Override
    public int func_148757_b(@Nullable T t) {
        return this.field_148759_a.func_186815_a(t);
    }

    @Override
    @Nullable
    public T func_230516_a_(@Nullable RegistryKey<T> registryKey) {
        return (T)this.field_239649_bb_.get(registryKey);
    }

    @Override
    @Nullable
    public T func_148745_a(int n) {
        return this.field_148759_a.func_148745_a(n);
    }

    @Override
    public Iterator<T> iterator() {
        return this.field_148759_a.iterator();
    }

    @Override
    @Nullable
    public T func_82594_a(@Nullable ResourceLocation resourceLocation) {
        return (T)this.field_82596_a.get((Object)resourceLocation);
    }

    @Override
    public Optional<T> func_218349_b(@Nullable ResourceLocation resourceLocation) {
        return Optional.ofNullable(this.field_82596_a.get((Object)resourceLocation));
    }

    @Override
    public Set<ResourceLocation> func_148742_b() {
        return Collections.unmodifiableSet(this.field_82596_a.keySet());
    }

    public Set<Map.Entry<RegistryKey<T>, T>> func_239659_c_() {
        return Collections.unmodifiableMap(this.field_239649_bb_).entrySet();
    }

    @Nullable
    public T func_186801_a(Random random2) {
        Random random2;
        if (this.field_186802_b == null) {
            Set set = this.field_82596_a.values();
            if (set.isEmpty()) {
                return null;
            }
            this.field_186802_b = set.toArray(new Object[set.size()]);
        }
        return (T)Util.func_240989_a_(this.field_186802_b, random2);
    }

    @Override
    public boolean func_212607_c(ResourceLocation resourceLocation) {
        return this.field_82596_a.containsKey((Object)resourceLocation);
    }

    @Override
    public boolean func_230518_b_(int n) {
        return this.field_148759_a.func_232993_b_(n);
    }

    @Override
    public boolean func_239660_c_(RegistryKey<T> registryKey) {
        return this.field_239650_bc_.contains(registryKey);
    }

    @Override
    public void func_239662_d_(RegistryKey<T> registryKey) {
        this.field_239650_bc_.add(registryKey);
    }

    public static <T> Codec<SimpleRegistry<T>> func_241743_a_(RegistryKey<Registry<T>> registryKey, Lifecycle lifecycle, MapCodec<T> mapCodec) {
        return RangeCodec.func_241293_a_(registryKey, mapCodec).codec().listOf().xmap(list -> {
            SimpleRegistry simpleRegistry = new SimpleRegistry(registryKey, lifecycle);
            for (Pair pair : list) {
                simpleRegistry.func_218381_a((RegistryKey)pair.getFirst(), pair.getSecond());
            }
            return simpleRegistry;
        }, simpleRegistry -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object t : simpleRegistry.field_148759_a) {
                builder.add((Object)Pair.of(simpleRegistry.func_230519_c_(t).get(), t));
            }
            return builder.build();
        });
    }

    public static <T> Codec<SimpleRegistry<T>> func_241744_b_(RegistryKey<Registry<T>> registryKey, Lifecycle lifecycle, MapCodec<T> mapCodec) {
        return SimpleRegistryCodec.func_241793_a_(registryKey, lifecycle, mapCodec);
    }

    public static <T> Codec<SimpleRegistry<T>> func_241745_c_(RegistryKey<Registry<T>> registryKey, Lifecycle lifecycle, MapCodec<T> mapCodec) {
        return Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_.xmap(RegistryKey.func_240902_a_(registryKey), RegistryKey::func_240901_a_), (Codec)mapCodec.codec()).xmap(map -> {
            SimpleRegistry simpleRegistry = new SimpleRegistry(registryKey, lifecycle);
            map.forEach((? super K registryKey, ? super V object) -> {
                simpleRegistry.func_218382_a(simpleRegistry.field_195869_d, (RegistryKey)registryKey, (Object)object);
                simpleRegistry.func_239662_d_((RegistryKey)registryKey);
            });
            return simpleRegistry;
        }, simpleRegistry -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            simpleRegistry.field_239649_bb_.entrySet().stream().filter(entry -> simpleRegistry.func_239660_c_((RegistryKey)entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)builder).put(arg_0));
            return builder.build();
        });
    }
}

