/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.integrated;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.LanServerPingThread;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedPlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.CryptManager;
import net.minecraft.util.SharedConstants;
import net.minecraft.world.GameType;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegratedServer
extends MinecraftServer {
    private static final Logger field_147148_h = LogManager.getLogger();
    private final Minecraft field_71349_l;
    private boolean field_71348_o;
    private int field_195580_l = -1;
    private LanServerPingThread field_71345_q;
    private UUID field_211528_n;

    public IntegratedServer(Thread thread, Minecraft minecraft, IDynamicRegistries.Impl impl, SaveFormat.LevelSave levelSave, ResourcePackList<ResourcePackInfo> resourcePackList, DataPackRegistries dataPackRegistries, IServerConfiguration iServerConfiguration, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, PlayerProfileCache playerProfileCache, IChunkStatusListenerFactory iChunkStatusListenerFactory) {
        super(thread, impl, levelSave, iServerConfiguration, resourcePackList, minecraft.func_110437_J(), minecraft.func_184126_aj(), dataPackRegistries, minecraftSessionService, gameProfileRepository, playerProfileCache, iChunkStatusListenerFactory);
        this.func_71224_l(minecraft.func_110432_I().func_111285_a());
        this.func_71204_b(minecraft.func_71355_q());
        this.func_71191_d(256);
        this.func_184105_a(new IntegratedPlayerList(this, this.field_240767_f_, this.field_240766_e_));
        this.field_71349_l = minecraft;
    }

    @Override
    public boolean func_71197_b() {
        field_147148_h.info("Starting integrated minecraft server version " + SharedConstants.func_215069_a().getName());
        this.func_71229_d(true);
        this.func_71188_g(true);
        this.func_71245_h(true);
        field_147148_h.info("Generating keypair");
        this.func_71253_a(CryptManager.func_75891_b());
        this.func_240800_l__();
        this.func_71205_p(this.func_71214_G() + " - " + this.func_240793_aU_().func_76065_j());
        return true;
    }

    @Override
    public void func_71217_p(BooleanSupplier booleanSupplier) {
        boolean bl = this.field_71348_o;
        this.field_71348_o = Minecraft.func_71410_x().func_147114_u() != null && Minecraft.func_71410_x().func_147113_T();
        IProfiler \u26032 = this.func_213185_aS();
        if (!bl && this.field_71348_o) {
            \u26032.func_76320_a("autoSave");
            field_147148_h.info("Saving and pausing game...");
            this.func_184103_al().func_72389_g();
            this.func_213211_a(false, false, false);
            \u26032.func_76319_b();
        }
        if (this.field_71348_o) {
            return;
        }
        super.func_71217_p(booleanSupplier);
        int \u26033 = Math.max(2, this.field_71349_l.field_71474_y.field_151451_c + -1);
        if (\u26033 != this.func_184103_al().func_72395_o()) {
            field_147148_h.info("Changing view distance to {}, from {}", (Object)\u26033, (Object)this.func_184103_al().func_72395_o());
            this.func_184103_al().func_217884_a(\u26033);
        }
    }

    @Override
    public boolean func_195569_l() {
        return true;
    }

    @Override
    public boolean func_195041_r_() {
        return true;
    }

    @Override
    public File func_71238_n() {
        return this.field_71349_l.field_71412_D;
    }

    @Override
    public boolean func_71262_S() {
        return false;
    }

    @Override
    public boolean func_181035_ah() {
        return false;
    }

    @Override
    public void func_71228_a(CrashReport crashReport) {
        this.field_71349_l.func_71404_a(crashReport);
    }

    @Override
    public CrashReport func_71230_b(CrashReport crashReport) {
        crashReport = super.func_71230_b(crashReport);
        crashReport.func_85056_g().func_71507_a("Type", "Integrated Server (map_client.txt)");
        crashReport.func_85056_g().func_189529_a("Is Modded", () -> this.func_230045_q_().orElse("Probably not. Jar signature remains and both client + server brands are untouched."));
        return crashReport;
    }

    @Override
    public Optional<String> func_230045_q_() {
        String string = ClientBrandRetriever.getClientModName();
        if (!string.equals("vanilla")) {
            return Optional.of("Definitely; Client brand changed to '" + string + "'");
        }
        string = this.getServerModName();
        if (!"vanilla".equals(string)) {
            return Optional.of("Definitely; Server brand changed to '" + string + "'");
        }
        if (Minecraft.class.getSigners() == null) {
            return Optional.of("Very likely; Jar signature invalidated");
        }
        return Optional.empty();
    }

    @Override
    public void func_70000_a(Snooper snooper) {
        super.func_70000_a(snooper);
        snooper.func_152768_a("snooper_partner", this.field_71349_l.func_71378_E().func_80006_f());
    }

    @Override
    public boolean func_195565_a(GameType gameType, boolean bl, int n) {
        try {
            this.func_147137_ag().func_151265_a(null, n);
            field_147148_h.info("Started serving on {}", (Object)n);
            this.field_195580_l = n;
            this.field_71345_q = new LanServerPingThread(this.func_71273_Y(), n + "");
            this.field_71345_q.start();
            this.func_184103_al().func_152604_a(gameType);
            this.func_184103_al().func_72387_b(bl);
            \u2603 = this.func_211833_a(this.field_71349_l.field_71439_g.func_146103_bH());
            this.field_71349_l.field_71439_g.func_184839_n(\u2603);
            for (ServerPlayerEntity serverPlayerEntity : this.func_184103_al().func_181057_v()) {
                this.func_195571_aL().func_197051_a(serverPlayerEntity);
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void func_71260_j() {
        super.func_71260_j();
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    @Override
    public void func_71263_m(boolean bl) {
        this.func_213167_f(() -> {
            ArrayList arrayList = Lists.newArrayList(this.func_184103_al().func_181057_v());
            for (ServerPlayerEntity serverPlayerEntity : arrayList) {
                if (serverPlayerEntity.func_110124_au().equals(this.field_211528_n)) continue;
                this.func_184103_al().func_72367_e(serverPlayerEntity);
            }
        });
        super.func_71263_m(bl);
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    @Override
    public boolean func_71344_c() {
        return this.field_195580_l > -1;
    }

    @Override
    public int func_71215_F() {
        return this.field_195580_l;
    }

    @Override
    public void func_71235_a(GameType gameType) {
        super.func_71235_a(gameType);
        this.func_184103_al().func_152604_a(gameType);
    }

    @Override
    public boolean func_82356_Z() {
        return true;
    }

    @Override
    public int func_110455_j() {
        return 2;
    }

    @Override
    public int func_223707_k() {
        return 2;
    }

    public void func_211527_b(UUID uUID) {
        this.field_211528_n = uUID;
    }

    @Override
    public boolean func_213199_b(GameProfile gameProfile) {
        return gameProfile.getName().equalsIgnoreCase(this.func_71214_G());
    }

    @Override
    public int func_230512_b_(int n) {
        return (int)(this.field_71349_l.field_71474_y.field_238329_c_ * (float)n);
    }

    @Override
    public boolean func_230540_aS_() {
        return this.field_71349_l.field_71474_y.field_241568_aS_;
    }
}

