/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.MainThread;
import net.minecraft.network.rcon.QueryThread;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerPropertiesProvider;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.PendingCommand;
import net.minecraft.server.dedicated.ServerHangWatchdog;
import net.minecraft.server.dedicated.ServerInfoMBean;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.server.gui.MinecraftServerGui;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.CryptManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.DefaultWithNameUncaughtExceptionHandler;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DedicatedServer
extends MinecraftServer
implements IServer {
    private static final Logger field_155771_h = LogManager.getLogger();
    private static final Pattern field_189647_l = Pattern.compile("^[a-fA-F0-9]{40}$");
    private final List<PendingCommand> field_71341_l = Collections.synchronizedList(Lists.newArrayList());
    private QueryThread field_71342_m;
    private final RConConsoleSource field_184115_n;
    private MainThread field_71339_n;
    private final ServerPropertiesProvider field_71340_o;
    @Nullable
    private MinecraftServerGui field_213225_q;

    public DedicatedServer(Thread thread, IDynamicRegistries.Impl impl, SaveFormat.LevelSave levelSave, ResourcePackList<ResourcePackInfo> resourcePackList, DataPackRegistries dataPackRegistries, IServerConfiguration iServerConfiguration, ServerPropertiesProvider serverPropertiesProvider, DataFixer dataFixer, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, PlayerProfileCache playerProfileCache, IChunkStatusListenerFactory iChunkStatusListenerFactory) {
        super(thread, impl, levelSave, iServerConfiguration, resourcePackList, Proxy.NO_PROXY, dataFixer, dataPackRegistries, minecraftSessionService, gameProfileRepository, playerProfileCache, iChunkStatusListenerFactory);
        this.field_71340_o = serverPropertiesProvider;
        this.field_184115_n = new RConConsoleSource(this);
    }

    @Override
    public boolean func_71197_b() throws IOException {
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                try {
                    while (!DedicatedServer.this.func_71241_aa() && DedicatedServer.this.func_71278_l() && (\u2603 = bufferedReader.readLine()) != null) {
                        DedicatedServer.this.func_195581_a(\u2603, DedicatedServer.this.func_195573_aM());
                    }
                }
                catch (IOException \u26032) {
                    field_155771_h.error("Exception handling console input", (Throwable)\u26032);
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_155771_h));
        thread.start();
        field_155771_h.info("Starting minecraft server version " + SharedConstants.func_215069_a().getName());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            field_155771_h.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        field_155771_h.info("Loading properties");
        ServerProperties \u26032 = this.field_71340_o.func_219034_a();
        if (this.func_71264_H()) {
            this.func_71189_e("127.0.0.1");
        } else {
            this.func_71229_d(\u26032.field_219007_a);
            this.func_190517_e(\u26032.field_219008_b);
            this.func_71189_e(\u26032.field_219009_c);
        }
        this.func_71188_g(\u26032.field_219012_f);
        this.func_71245_h(\u26032.field_219013_g);
        this.func_180507_a_(\u26032.field_219014_h, this.func_184113_aK());
        this.func_71205_p(\u26032.field_219015_i);
        this.func_104055_i(\u26032.field_219016_j);
        super.func_143006_e(\u26032.field_219005_R.get());
        this.func_205741_k(\u26032.field_219017_k);
        this.field_240768_i_.func_230392_a_(\u26032.field_219020_n);
        field_155771_h.info("Default game type: {}", (Object)\u26032.field_219020_n);
        InetAddress \u26033 = null;
        if (!this.func_71211_k().isEmpty()) {
            \u26033 = InetAddress.getByName(this.func_71211_k());
        }
        if (this.func_71215_F() < 0) {
            this.func_71208_b(\u26032.field_219025_s);
        }
        field_155771_h.info("Generating keypair");
        this.func_71253_a(CryptManager.func_75891_b());
        field_155771_h.info("Starting Minecraft server on {}:{}", (Object)(this.func_71211_k().isEmpty() ? "*" : this.func_71211_k()), (Object)this.func_71215_F());
        try {
            this.func_147137_ag().func_151265_a(\u26033, this.func_71215_F());
        }
        catch (IOException \u26034) {
            field_155771_h.warn("**** FAILED TO BIND TO PORT!");
            field_155771_h.warn("The exception was: {}", (Object)\u26034.toString());
            field_155771_h.warn("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.func_71266_T()) {
            field_155771_h.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            field_155771_h.warn("The server will make no attempt to authenticate usernames. Beware.");
            field_155771_h.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            field_155771_h.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (this.func_152368_aE()) {
            this.func_152358_ax().func_152658_c();
        }
        if (!PreYggdrasilConverter.func_219587_e(this)) {
            return false;
        }
        this.func_184105_a(new DedicatedPlayerList(this, this.field_240767_f_, this.field_240766_e_));
        long \u26035 = Util.func_211178_c();
        this.func_71191_d(\u26032.field_219026_t);
        SkullTileEntity.func_184293_a(this.func_152358_ax());
        SkullTileEntity.func_184294_a(this.func_147130_as());
        PlayerProfileCache.func_187320_a(this.func_71266_T());
        field_155771_h.info("Preparing level \"{}\"", (Object)this.func_230542_k__());
        this.func_240800_l__();
        long \u26036 = Util.func_211178_c() - \u26035;
        String \u26037 = String.format(Locale.ROOT, "%.3fs", (double)\u26036 / 1.0E9);
        field_155771_h.info("Done ({})! For help, type \"help\"", (Object)\u26037);
        if (\u26032.field_219027_u != null) {
            this.func_200252_aR().func_223585_a(GameRules.field_223620_w).func_223570_a(\u26032.field_219027_u, this);
        }
        if (\u26032.field_219028_v) {
            field_155771_h.info("Starting GS4 status listener");
            this.field_71342_m = new QueryThread(this);
            this.field_71342_m.func_72602_a();
        }
        if (\u26032.field_219030_x) {
            field_155771_h.info("Starting remote control listener");
            this.field_71339_n = new MainThread(this);
            this.field_71339_n.func_72602_a();
        }
        if (this.func_175593_aQ() > 0L) {
            \u2603 = new Thread(new ServerHangWatchdog(this));
            \u2603.setUncaughtExceptionHandler(new DefaultWithNameUncaughtExceptionHandler(field_155771_h));
            \u2603.setName("Server Watchdog");
            \u2603.setDaemon(true);
            \u2603.start();
        }
        Items.field_190931_a.func_150895_a(ItemGroup.field_78027_g, NonNullList.func_191196_a());
        if (\u26032.field_241079_P_) {
            ServerInfoMBean.func_233490_a_(this);
        }
        return true;
    }

    @Override
    public boolean func_230537_U_() {
        return this.func_213221_d_().field_219010_d && super.func_230537_U_();
    }

    @Override
    public boolean func_230536_N_() {
        return this.field_71340_o.func_219034_a().field_218992_E && super.func_230536_N_();
    }

    @Override
    public boolean func_230538_V_() {
        return this.field_71340_o.func_219034_a().field_219011_e && super.func_230538_V_();
    }

    public String func_184113_aK() {
        String string;
        ServerProperties serverProperties = this.field_71340_o.func_219034_a();
        if (!serverProperties.field_218989_B.isEmpty()) {
            string = serverProperties.field_218989_B;
            if (!Strings.isNullOrEmpty((String)serverProperties.field_218988_A)) {
                field_155771_h.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            }
        } else if (!Strings.isNullOrEmpty((String)serverProperties.field_218988_A)) {
            field_155771_h.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
            string = serverProperties.field_218988_A;
        } else {
            string = "";
        }
        if (!string.isEmpty() && !field_189647_l.matcher(string).matches()) {
            field_155771_h.warn("Invalid sha1 for ressource-pack-sha1");
        }
        if (!serverProperties.field_219014_h.isEmpty() && string.isEmpty()) {
            field_155771_h.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        }
        return string;
    }

    @Override
    public ServerProperties func_213221_d_() {
        return this.field_71340_o.func_219034_a();
    }

    @Override
    public void func_230543_p_() {
        this.func_147139_a(this.func_213221_d_().field_219019_m, true);
    }

    @Override
    public boolean func_71199_h() {
        return this.func_213221_d_().field_218990_C;
    }

    @Override
    public CrashReport func_71230_b(CrashReport crashReport) {
        crashReport = super.func_71230_b(crashReport);
        crashReport.func_85056_g().func_189529_a("Is Modded", () -> this.func_230045_q_().orElse("Unknown (can't tell)"));
        crashReport.func_85056_g().func_189529_a("Type", () -> "Dedicated Server (map_server.txt)");
        return crashReport;
    }

    @Override
    public Optional<String> func_230045_q_() {
        String string = this.getServerModName();
        if (!"vanilla".equals(string)) {
            return Optional.of("Definitely; Server brand changed to '" + string + "'");
        }
        return Optional.empty();
    }

    @Override
    public void func_71240_o() {
        if (this.field_213225_q != null) {
            this.field_213225_q.func_219050_b();
        }
        if (this.field_71339_n != null) {
            this.field_71339_n.func_219591_b();
        }
        if (this.field_71342_m != null) {
            this.field_71342_m.func_219591_b();
        }
    }

    @Override
    public void func_71190_q(BooleanSupplier booleanSupplier) {
        super.func_71190_q(booleanSupplier);
        this.func_71333_ah();
    }

    @Override
    public boolean func_71255_r() {
        return this.func_213221_d_().field_218991_D;
    }

    @Override
    public void func_70000_a(Snooper snooper) {
        snooper.func_152768_a("whitelist_enabled", this.func_184103_al().func_72383_n());
        snooper.func_152768_a("whitelist_count", this.func_184103_al().func_152598_l().length);
        super.func_70000_a(snooper);
    }

    public void func_195581_a(String string, CommandSource commandSource) {
        this.field_71341_l.add(new PendingCommand(string, commandSource));
    }

    public void func_71333_ah() {
        while (!this.field_71341_l.isEmpty()) {
            PendingCommand pendingCommand = this.field_71341_l.remove(0);
            this.func_195571_aL().func_197059_a(pendingCommand.field_73701_b, pendingCommand.field_73702_a);
        }
    }

    @Override
    public boolean func_71262_S() {
        return true;
    }

    @Override
    public boolean func_181035_ah() {
        return this.func_213221_d_().field_218994_G;
    }

    @Override
    public DedicatedPlayerList func_184103_al() {
        return (DedicatedPlayerList)super.func_184103_al();
    }

    @Override
    public boolean func_71344_c() {
        return true;
    }

    @Override
    public String func_71277_t() {
        return this.func_71211_k();
    }

    @Override
    public int func_71234_u() {
        return this.func_71215_F();
    }

    @Override
    public String func_71274_v() {
        return this.func_71273_Y();
    }

    public void func_120011_ar() {
        if (this.field_213225_q == null) {
            this.field_213225_q = MinecraftServerGui.func_219048_a(this);
        }
    }

    @Override
    public boolean func_71279_ae() {
        return this.field_213225_q != null;
    }

    @Override
    public boolean func_195565_a(GameType gameType, boolean bl, int n) {
        return false;
    }

    @Override
    public boolean func_82356_Z() {
        return this.func_213221_d_().field_218995_H;
    }

    @Override
    public int func_82357_ak() {
        return this.func_213221_d_().field_218996_I;
    }

    @Override
    public boolean func_175579_a(ServerWorld serverWorld, BlockPos blockPos, PlayerEntity playerEntity) {
        if (serverWorld.func_234923_W_() != World.field_234918_g_) {
            return false;
        }
        if (this.func_184103_al().func_152603_m().func_152690_d()) {
            return false;
        }
        if (this.func_184103_al().func_152596_g(playerEntity.func_146103_bH())) {
            return false;
        }
        if (this.func_82357_ak() <= 0) {
            return false;
        }
        BlockPos blockPos2 = serverWorld.func_241135_u_();
        int \u26032 = MathHelper.func_76130_a(blockPos.func_177958_n() - blockPos2.func_177958_n());
        int \u26033 = Math.max(\u26032, \u2603 = MathHelper.func_76130_a(blockPos.func_177952_p() - blockPos2.func_177952_p()));
        return \u26033 <= this.func_82357_ak();
    }

    @Override
    public boolean func_230541_aj_() {
        return this.func_213221_d_().field_241080_Q_;
    }

    @Override
    public int func_110455_j() {
        return this.func_213221_d_().field_218997_J;
    }

    @Override
    public int func_223707_k() {
        return this.func_213221_d_().field_225395_K;
    }

    @Override
    public void func_143006_e(int n) {
        super.func_143006_e(n);
        this.field_71340_o.func_219033_a(serverProperties -> (ServerProperties)serverProperties.field_219005_R.func_219038_a(n));
    }

    @Override
    public boolean func_195569_l() {
        return this.func_213221_d_().field_219002_O;
    }

    @Override
    public boolean func_195041_r_() {
        return this.func_213221_d_().field_219003_P;
    }

    @Override
    public int func_175580_aG() {
        return this.func_213221_d_().field_219004_Q;
    }

    @Override
    public int func_175577_aI() {
        return this.func_213221_d_().field_219001_N;
    }

    protected boolean func_152368_aE() {
        int n;
        boolean bl = false;
        for (n = 0; !bl && n <= 2; ++n) {
            if (n > 0) {
                field_155771_h.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.func_152369_aG();
            }
            bl = PreYggdrasilConverter.func_152724_a(this);
        }
        boolean bl2 = false;
        for (n = 0; !bl2 && n <= 2; ++n) {
            if (n > 0) {
                field_155771_h.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.func_152369_aG();
            }
            bl2 = PreYggdrasilConverter.func_152722_b(this);
        }
        boolean bl3 = false;
        for (n = 0; !bl3 && n <= 2; ++n) {
            if (n > 0) {
                field_155771_h.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.func_152369_aG();
            }
            bl3 = PreYggdrasilConverter.func_152718_c(this);
        }
        boolean bl4 = false;
        for (n = 0; !bl4 && n <= 2; ++n) {
            if (n > 0) {
                field_155771_h.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.func_152369_aG();
            }
            bl4 = PreYggdrasilConverter.func_152710_d(this);
        }
        boolean bl5 = false;
        for (n = 0; !bl5 && n <= 2; ++n) {
            if (n > 0) {
                field_155771_h.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.func_152369_aG();
            }
            bl5 = PreYggdrasilConverter.func_152723_a(this);
        }
        return bl || bl2 || bl3 || bl4 || bl5;
    }

    private void func_152369_aG() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public long func_175593_aQ() {
        return this.func_213221_d_().field_218998_K;
    }

    @Override
    public String func_71258_A() {
        return "";
    }

    @Override
    public String func_71252_i(String string) {
        this.field_184115_n.func_70007_b();
        this.func_213167_f(() -> this.func_195571_aL().func_197059_a(this.field_184115_n.func_195540_f(), string));
        return this.field_184115_n.func_70008_c();
    }

    public void func_213223_o(boolean bl) {
        this.field_71340_o.func_219033_a(serverProperties -> (ServerProperties)serverProperties.field_219006_S.func_219038_a(bl));
    }

    @Override
    public void func_71260_j() {
        super.func_71260_j();
        Util.func_240993_h_();
    }

    @Override
    public boolean func_213199_b(GameProfile gameProfile) {
        return false;
    }

    @Override
    public int func_230512_b_(int n) {
        return this.func_213221_d_().field_241081_R_ * n / 100;
    }

    @Override
    public String func_230542_k__() {
        return this.field_71310_m.func_237282_a_();
    }

    @Override
    public boolean func_230540_aS_() {
        return this.field_71340_o.func_219034_a().field_241078_O_;
    }

    @Override
    public /* synthetic */ PlayerList func_184103_al() {
        return this.func_184103_al();
    }
}

