/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms.action;

import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsServerAddress;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.gui.LongRunningTask;
import com.mojang.realmsclient.gui.screens.RealmsBrokenWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsTermsScreen;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.realms.action.ConnectedToRealmsAction;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ConnectingToRealmsAction
extends LongRunningTask {
    private final RealmsServer field_238116_c_;
    private final Screen field_238117_d_;
    private final RealmsMainScreen field_238118_e_;
    private final ReentrantLock field_238119_f_;

    public ConnectingToRealmsAction(RealmsMainScreen realmsMainScreen, Screen screen, RealmsServer realmsServer, ReentrantLock reentrantLock) {
        this.field_238117_d_ = screen;
        this.field_238118_e_ = realmsMainScreen;
        this.field_238116_c_ = realmsServer;
        this.field_238119_f_ = reentrantLock;
    }

    @Override
    public void run() {
        this.func_224989_b(I18n.func_135052_a("mco.connect.connecting", new Object[0]));
        RealmsClient realmsClient = RealmsClient.func_224911_a();
        boolean \u26032 = false;
        boolean \u26033 = false;
        int \u26034 = 5;
        RealmsServerAddress \u26035 = null;
        boolean \u26036 = false;
        boolean \u26037 = false;
        for (int i = 0; i < 40 && !this.func_224988_a(); ++i) {
            try {
                \u26035 = realmsClient.func_224904_b(this.field_238116_c_.field_230582_a_);
                \u26032 = true;
            }
            catch (RetryCallException retryCallException) {
                \u26034 = retryCallException.field_224985_e;
            }
            catch (RealmsServiceException realmsServiceException) {
                if (realmsServiceException.field_224983_c == 6002) {
                    \u26036 = true;
                    break;
                }
                if (realmsServiceException.field_224983_c == 6006) {
                    \u26037 = true;
                    break;
                }
                \u26033 = true;
                this.func_237703_a_(realmsServiceException.toString());
                field_238124_a_.error("Couldn't connect to world", (Throwable)realmsServiceException);
                break;
            }
            catch (Exception exception) {
                \u26033 = true;
                field_238124_a_.error("Couldn't connect to world", (Throwable)exception);
                this.func_237703_a_(exception.getLocalizedMessage());
                break;
            }
            if (\u26032) break;
            this.func_238123_b_(\u26034);
        }
        if (\u26036) {
            ConnectingToRealmsAction.func_238127_a_(new RealmsTermsScreen(this.field_238117_d_, this.field_238118_e_, this.field_238116_c_));
        } else if (\u26037) {
            if (this.field_238116_c_.field_230588_g_.equals(Minecraft.func_71410_x().func_110432_I().func_148255_b())) {
                ConnectingToRealmsAction.func_238127_a_(new RealmsBrokenWorldScreen(this.field_238117_d_, this.field_238118_e_, this.field_238116_c_.field_230582_a_, this.field_238116_c_.field_230594_m_ == RealmsServer.ServerType.MINIGAME));
            } else {
                ConnectingToRealmsAction.func_238127_a_(new RealmsGenericErrorScreen(new TranslationTextComponent("mco.brokenworld.nonowner.title"), new TranslationTextComponent("mco.brokenworld.nonowner.error"), this.field_238117_d_));
            }
        } else if (!this.func_224988_a() && !\u26033) {
            if (\u26032) {
                RealmsServerAddress realmsServerAddress = \u26035;
                if (realmsServerAddress.field_230602_b_ != null && realmsServerAddress.field_230603_c_ != null) {
                    TranslationTextComponent translationTextComponent = new TranslationTextComponent("mco.configure.world.resourcepack.question.line1");
                    \u2603 = new TranslationTextComponent("mco.configure.world.resourcepack.question.line2");
                    ConnectingToRealmsAction.func_238127_a_(new RealmsLongConfirmationScreen(bl -> {
                        try {
                            if (bl) {
                                Function<Throwable, Void> function = throwable -> {
                                    Minecraft.func_71410_x().func_195541_I().func_195749_c();
                                    field_238124_a_.error(throwable);
                                    ConnectingToRealmsAction.func_238127_a_(new RealmsGenericErrorScreen(new StringTextComponent("Failed to download resource pack!"), this.field_238117_d_));
                                    return null;
                                };
                                try {
                                    ((CompletableFuture)Minecraft.func_71410_x().func_195541_I().func_217818_a(realmsServerAddress.field_230602_b_, realmsServerAddress.field_230603_c_).thenRun(() -> this.func_224987_a(new RealmsLongRunningMcoTaskScreen(this.field_238117_d_, new ConnectedToRealmsAction(this.field_238117_d_, realmsServerAddress))))).exceptionally(function);
                                }
                                catch (Exception \u26032) {
                                    function.apply(\u26032);
                                }
                            } else {
                                ConnectingToRealmsAction.func_238127_a_(this.field_238117_d_);
                            }
                        }
                        finally {
                            if (this.field_238119_f_ != null && this.field_238119_f_.isHeldByCurrentThread()) {
                                this.field_238119_f_.unlock();
                            }
                        }
                    }, RealmsLongConfirmationScreen.Type.Info, translationTextComponent, \u2603, true));
                } else {
                    this.func_224987_a(new RealmsLongRunningMcoTaskScreen(this.field_238117_d_, new ConnectedToRealmsAction(this.field_238117_d_, realmsServerAddress)));
                }
            } else {
                this.func_230434_a_(new TranslationTextComponent("mco.errorMessage.connectionFailure"));
            }
        }
    }

    private void func_238123_b_(int n) {
        try {
            Thread.sleep(n * 1000);
        }
        catch (InterruptedException interruptedException) {
            field_238124_a_.warn(interruptedException.getLocalizedMessage());
        }
    }
}

