/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.rcon;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConOutputStream;
import net.minecraft.network.rcon.RConThread;
import net.minecraft.network.rcon.RConUtils;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryThread
extends RConThread {
    private static final Logger field_232648_d_ = LogManager.getLogger();
    private long field_72629_g;
    private final int field_72636_h;
    private final int field_72637_i;
    private final int field_72634_j;
    private final String field_72635_k;
    private final String field_72632_l;
    private DatagramSocket field_72633_m;
    private final byte[] field_72630_n = new byte[1460];
    private String field_72643_q;
    private String field_72642_r;
    private final Map<SocketAddress, Auth> field_72641_s;
    private final RConOutputStream field_72639_u;
    private long field_72638_v;
    private final IServer field_232649_r_;

    public QueryThread(IServer iServer) {
        super("Query Listener");
        this.field_232649_r_ = iServer;
        this.field_72636_h = iServer.func_213221_d_().field_219029_w;
        this.field_72642_r = iServer.func_71277_t();
        this.field_72637_i = iServer.func_71234_u();
        this.field_72635_k = iServer.func_71274_v();
        this.field_72634_j = iServer.func_71275_y();
        this.field_72632_l = iServer.func_230542_k__();
        this.field_72638_v = 0L;
        this.field_72643_q = "0.0.0.0";
        if (this.field_72642_r.isEmpty() || this.field_72643_q.equals(this.field_72642_r)) {
            this.field_72642_r = "0.0.0.0";
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.field_72643_q = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                field_232648_d_.warn("Unable to determine local host IP, please set server-ip in server.properties", (Throwable)unknownHostException);
            }
        } else {
            this.field_72643_q = this.field_72642_r;
        }
        this.field_72639_u = new RConOutputStream(1460);
        this.field_72641_s = Maps.newHashMap();
    }

    private void func_72620_a(byte[] byArray, DatagramPacket datagramPacket) throws IOException {
        this.field_72633_m.send(new DatagramPacket(byArray, byArray.length, datagramPacket.getSocketAddress()));
    }

    private boolean func_72621_a(DatagramPacket datagramPacket) throws IOException {
        byte[] byArray = datagramPacket.getData();
        int \u26032 = datagramPacket.getLength();
        SocketAddress \u26033 = datagramPacket.getSocketAddress();
        field_232648_d_.debug("Packet len {} [{}]", (Object)\u26032, (Object)\u26033);
        if (3 > \u26032 || -2 != byArray[0] || -3 != byArray[1]) {
            field_232648_d_.debug("Invalid packet [{}]", (Object)\u26033);
            return false;
        }
        field_232648_d_.debug("Packet '{}' [{}]", (Object)RConUtils.func_72663_a(byArray[2]), (Object)\u26033);
        switch (byArray[2]) {
            case 9: {
                this.func_72622_d(datagramPacket);
                field_232648_d_.debug("Challenge [{}]", (Object)\u26033);
                return true;
            }
            case 0: {
                if (!this.func_72627_c(datagramPacket).booleanValue()) {
                    field_232648_d_.debug("Invalid challenge [{}]", (Object)\u26033);
                    return false;
                }
                if (15 == \u26032) {
                    this.func_72620_a(this.func_72624_b(datagramPacket), datagramPacket);
                    field_232648_d_.debug("Rules [{}]", (Object)\u26033);
                    break;
                }
                RConOutputStream rConOutputStream = new RConOutputStream(1460);
                rConOutputStream.func_72667_a(0);
                rConOutputStream.func_72670_a(this.func_72625_a(datagramPacket.getSocketAddress()));
                rConOutputStream.func_72671_a(this.field_72635_k);
                rConOutputStream.func_72671_a("SMP");
                rConOutputStream.func_72671_a(this.field_72632_l);
                rConOutputStream.func_72671_a(Integer.toString(this.field_232649_r_.func_71233_x()));
                rConOutputStream.func_72671_a(Integer.toString(this.field_72634_j));
                rConOutputStream.func_72668_a((short)this.field_72637_i);
                rConOutputStream.func_72671_a(this.field_72643_q);
                this.func_72620_a(rConOutputStream.func_72672_a(), datagramPacket);
                field_232648_d_.debug("Status [{}]", (Object)\u26033);
            }
        }
        return true;
    }

    private byte[] func_72624_b(DatagramPacket datagramPacket) throws IOException {
        long l = Util.func_211177_b();
        if (l < this.field_72638_v + 5000L) {
            byte[] byArray = this.field_72639_u.func_72672_a();
            \u2603 = this.func_72625_a(datagramPacket.getSocketAddress());
            byArray[1] = \u2603[0];
            byArray[2] = \u2603[1];
            byArray[3] = \u2603[2];
            byArray[4] = \u2603[3];
            return byArray;
        }
        this.field_72638_v = l;
        this.field_72639_u.func_72669_b();
        this.field_72639_u.func_72667_a(0);
        this.field_72639_u.func_72670_a(this.func_72625_a(datagramPacket.getSocketAddress()));
        this.field_72639_u.func_72671_a("splitnum");
        this.field_72639_u.func_72667_a(128);
        this.field_72639_u.func_72667_a(0);
        this.field_72639_u.func_72671_a("hostname");
        this.field_72639_u.func_72671_a(this.field_72635_k);
        this.field_72639_u.func_72671_a("gametype");
        this.field_72639_u.func_72671_a("SMP");
        this.field_72639_u.func_72671_a("game_id");
        this.field_72639_u.func_72671_a("MINECRAFT");
        this.field_72639_u.func_72671_a("version");
        this.field_72639_u.func_72671_a(this.field_232649_r_.func_71249_w());
        this.field_72639_u.func_72671_a("plugins");
        this.field_72639_u.func_72671_a(this.field_232649_r_.func_71258_A());
        this.field_72639_u.func_72671_a("map");
        this.field_72639_u.func_72671_a(this.field_72632_l);
        this.field_72639_u.func_72671_a("numplayers");
        this.field_72639_u.func_72671_a("" + this.field_232649_r_.func_71233_x());
        this.field_72639_u.func_72671_a("maxplayers");
        this.field_72639_u.func_72671_a("" + this.field_72634_j);
        this.field_72639_u.func_72671_a("hostport");
        this.field_72639_u.func_72671_a("" + this.field_72637_i);
        this.field_72639_u.func_72671_a("hostip");
        this.field_72639_u.func_72671_a(this.field_72643_q);
        this.field_72639_u.func_72667_a(0);
        this.field_72639_u.func_72667_a(1);
        this.field_72639_u.func_72671_a("player_");
        this.field_72639_u.func_72667_a(0);
        for (String string : \u2603 = this.field_232649_r_.func_71213_z()) {
            this.field_72639_u.func_72671_a(string);
        }
        this.field_72639_u.func_72667_a(0);
        return this.field_72639_u.func_72672_a();
    }

    private byte[] func_72625_a(SocketAddress socketAddress) {
        return this.field_72641_s.get(socketAddress).func_72591_c();
    }

    private Boolean func_72627_c(DatagramPacket datagramPacket) {
        SocketAddress socketAddress = datagramPacket.getSocketAddress();
        if (!this.field_72641_s.containsKey(socketAddress)) {
            return false;
        }
        byte[] \u26032 = datagramPacket.getData();
        return this.field_72641_s.get(socketAddress).func_72592_a() == RConUtils.func_72664_c(\u26032, 7, datagramPacket.getLength());
    }

    private void func_72622_d(DatagramPacket datagramPacket) throws IOException {
        Auth auth = new Auth(datagramPacket);
        this.field_72641_s.put(datagramPacket.getSocketAddress(), auth);
        this.func_72620_a(auth.func_72594_b(), datagramPacket);
    }

    private void func_72628_f() {
        if (!this.field_72619_a) {
            return;
        }
        long l = Util.func_211177_b();
        if (l < this.field_72629_g + 30000L) {
            return;
        }
        this.field_72629_g = l;
        this.field_72641_s.values().removeIf(auth -> auth.func_72593_a(l));
    }

    @Override
    public void run() {
        field_232648_d_.info("Query running on {}:{}", (Object)this.field_72642_r, (Object)this.field_72636_h);
        this.field_72629_g = Util.func_211177_b();
        DatagramPacket datagramPacket = new DatagramPacket(this.field_72630_n, this.field_72630_n.length);
        try {
            while (this.field_72619_a) {
                try {
                    this.field_72633_m.receive(datagramPacket);
                    this.func_72628_f();
                    this.func_72621_a(datagramPacket);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.func_72628_f();
                }
                catch (PortUnreachableException socketTimeoutException) {
                }
                catch (IOException iOException) {
                    this.func_72623_a(iOException);
                }
            }
        }
        finally {
            field_232648_d_.debug("closeSocket: {}:{}", (Object)this.field_72642_r, (Object)this.field_72636_h);
            this.field_72633_m.close();
        }
    }

    @Override
    public void func_72602_a() {
        if (this.field_72619_a) {
            return;
        }
        if (0 >= this.field_72636_h || 65535 < this.field_72636_h) {
            field_232648_d_.warn("Invalid query port {} found in server.properties (queries disabled)", (Object)this.field_72636_h);
            return;
        }
        if (this.func_72626_g()) {
            super.func_72602_a();
        }
    }

    private void func_72623_a(Exception exception) {
        if (!this.field_72619_a) {
            return;
        }
        field_232648_d_.warn("Unexpected exception", (Throwable)exception);
        if (!this.func_72626_g()) {
            field_232648_d_.error("Failed to recover from exception, shutting down!");
            this.field_72619_a = false;
        }
    }

    private boolean func_72626_g() {
        try {
            this.field_72633_m = new DatagramSocket(this.field_72636_h, InetAddress.getByName(this.field_72642_r));
            this.field_72633_m.setSoTimeout(500);
            return true;
        }
        catch (Exception exception) {
            field_232648_d_.warn("Unable to initialise query system on {}:{}", (Object)this.field_72642_r, (Object)this.field_72636_h, (Object)exception);
            return false;
        }
    }

    static class Auth {
        private final long field_72598_b = new Date().getTime();
        private final int field_72599_c;
        private final byte[] field_72596_d;
        private final byte[] field_72597_e;
        private final String field_72595_f;

        public Auth(DatagramPacket datagramPacket) {
            byte[] byArray = datagramPacket.getData();
            this.field_72596_d = new byte[4];
            this.field_72596_d[0] = byArray[3];
            this.field_72596_d[1] = byArray[4];
            this.field_72596_d[2] = byArray[5];
            this.field_72596_d[3] = byArray[6];
            this.field_72595_f = new String(this.field_72596_d, StandardCharsets.UTF_8);
            this.field_72599_c = new Random().nextInt(0x1000000);
            this.field_72597_e = String.format("\t%s%d\u0000", this.field_72595_f, this.field_72599_c).getBytes(StandardCharsets.UTF_8);
        }

        public Boolean func_72593_a(long l) {
            return this.field_72598_b < l;
        }

        public int func_72592_a() {
            return this.field_72599_c;
        }

        public byte[] func_72594_b() {
            return this.field_72597_e;
        }

        public byte[] func_72591_c() {
            return this.field_72596_d;
        }
    }
}

