/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.potion.Effect;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class SetStewEffect
extends LootFunction {
    private final Map<Effect, RandomValueRange> field_215950_a;

    private SetStewEffect(ILootCondition[] iLootConditionArray, Map<Effect, RandomValueRange> map) {
        super(iLootConditionArray);
        this.field_215950_a = ImmutableMap.copyOf(map);
    }

    @Override
    public LootFunctionType func_230425_b_() {
        return LootFunctionManager.field_237439_l_;
    }

    @Override
    public ItemStack func_215859_a(ItemStack itemStack, LootContext lootContext) {
        if (itemStack.func_77973_b() != Items.field_222115_pz || this.field_215950_a.isEmpty()) {
            return itemStack;
        }
        Random random = lootContext.func_216032_b();
        int \u26032 = random.nextInt(this.field_215950_a.size());
        Map.Entry \u26033 = (Map.Entry)Iterables.get(this.field_215950_a.entrySet(), (int)\u26032);
        Effect \u26034 = (Effect)\u26033.getKey();
        int \u26035 = ((RandomValueRange)\u26033.getValue()).func_186511_a(random);
        if (!\u26034.func_76403_b()) {
            \u26035 *= 20;
        }
        SuspiciousStewItem.func_220037_a(itemStack, \u26034, \u26035);
        return itemStack;
    }

    public static Builder func_215948_b() {
        return new Builder();
    }

    public static class Serializer
    extends LootFunction.Serializer<SetStewEffect> {
        @Override
        public void func_230424_a_(JsonObject jsonObject, SetStewEffect setStewEffect, JsonSerializationContext jsonSerializationContext) {
            super.func_230424_a_(jsonObject, setStewEffect, jsonSerializationContext);
            if (!setStewEffect.field_215950_a.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (Effect effect : setStewEffect.field_215950_a.keySet()) {
                    JsonObject jsonObject2 = new JsonObject();
                    ResourceLocation \u26032 = Registry.field_212631_t.func_177774_c(effect);
                    if (\u26032 == null) {
                        throw new IllegalArgumentException("Don't know how to serialize mob effect " + effect);
                    }
                    jsonObject2.add("type", (JsonElement)new JsonPrimitive(\u26032.toString()));
                    jsonObject2.add("duration", jsonSerializationContext.serialize(setStewEffect.field_215950_a.get(effect)));
                    jsonArray.add((JsonElement)jsonObject2);
                }
                jsonObject.add("effects", (JsonElement)jsonArray);
            }
        }

        @Override
        public SetStewEffect func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            HashMap hashMap = Maps.newHashMap();
            if (jsonObject.has("effects")) {
                JsonArray jsonArray = JSONUtils.func_151214_t(jsonObject, "effects");
                for (JsonElement jsonElement : jsonArray) {
                    String string = JSONUtils.func_151200_h(jsonElement.getAsJsonObject(), "type");
                    Effect \u26032 = Registry.field_212631_t.func_218349_b(new ResourceLocation(string)).orElseThrow(() -> new JsonSyntaxException("Unknown mob effect '" + string + "'"));
                    RandomValueRange \u26033 = JSONUtils.func_188174_a(jsonElement.getAsJsonObject(), "duration", jsonDeserializationContext, RandomValueRange.class);
                    hashMap.put(\u26032, \u26033);
                }
            }
            return new SetStewEffect(iLootConditionArray, hashMap);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final Map<Effect, RandomValueRange> field_216078_a = Maps.newHashMap();

        @Override
        protected Builder func_212826_d_() {
            return this;
        }

        public Builder func_216077_a(Effect effect, RandomValueRange randomValueRange) {
            this.field_216078_a.put(effect, randomValueRange);
            return this;
        }

        @Override
        public ILootFunction func_216052_b() {
            return new SetStewEffect(this.func_216053_g(), this.field_216078_a);
        }

        @Override
        protected /* synthetic */ LootFunction.Builder func_212826_d_() {
            return this.func_212826_d_();
        }
    }
}

