/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;

public class SpawnEggItem
extends Item {
    private static final Map<EntityType<?>, SpawnEggItem> field_195987_b = Maps.newIdentityHashMap();
    private final int field_195988_c;
    private final int field_195989_d;
    private final EntityType<?> field_200890_d;

    public SpawnEggItem(EntityType<?> entityType, int n, int n2, Item.Properties properties) {
        super(properties);
        this.field_200890_d = entityType;
        this.field_195988_c = n;
        this.field_195989_d = n2;
        field_195987_b.put(entityType, this);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext itemUseContext) {
        World world = itemUseContext.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack \u26032 = itemUseContext.func_195996_i();
        BlockPos \u26033 = itemUseContext.func_195995_a();
        Direction \u26034 = itemUseContext.func_196000_l();
        BlockState \u26035 = world.func_180495_p(\u26033);
        if (\u26035.func_203425_a(Blocks.field_150474_ac) && (object = world.func_175625_s(\u26033)) instanceof MobSpawnerTileEntity) {
            AbstractSpawner abstractSpawner = ((MobSpawnerTileEntity)object).func_145881_a();
            EntityType<?> \u26036 = this.func_208076_b(\u26032.func_77978_p());
            abstractSpawner.func_200876_a(\u26036);
            ((TileEntity)object).func_70296_d();
            world.func_184138_a(\u26033, \u26035, \u26035, 3);
            \u26032.func_190918_g(1);
            return ActionResultType.CONSUME;
        }
        Object object = \u26035.func_196952_d(world, \u26033).func_197766_b() ? \u26033 : \u26033.func_177972_a(\u26034);
        EntityType<?> \u26037 = this.func_208076_b(\u26032.func_77978_p());
        if (\u26037.func_220331_a(world, \u26032, itemUseContext.func_195999_j(), (BlockPos)object, SpawnReason.SPAWN_EGG, true, !Objects.equals(\u26033, object) && \u26034 == Direction.UP) != null) {
            \u26032.func_190918_g(1);
        }
        return ActionResultType.CONSUME;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        BlockRayTraceResult \u26032 = SpawnEggItem.func_219968_a(world, playerEntity, RayTraceContext.FluidMode.SOURCE_ONLY);
        if (((RayTraceResult)\u26032).func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_(itemStack);
        }
        if (world.field_72995_K) {
            return ActionResult.func_226248_a_(itemStack);
        }
        BlockRayTraceResult \u26033 = \u26032;
        BlockPos \u26034 = \u26033.func_216350_a();
        if (!(world.func_180495_p(\u26034).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_(itemStack);
        }
        if (!world.func_175660_a(playerEntity, \u26034) || !playerEntity.func_175151_a(\u26034, \u26033.func_216354_b(), itemStack)) {
            return ActionResult.func_226251_d_(itemStack);
        }
        EntityType<?> \u26035 = this.func_208076_b(itemStack.func_77978_p());
        if (\u26035.func_220331_a(world, itemStack, playerEntity, \u26034, SpawnReason.SPAWN_EGG, false, false) == null) {
            return ActionResult.func_226250_c_(itemStack);
        }
        if (!playerEntity.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        playerEntity.func_71029_a(Stats.field_75929_E.func_199076_b(this));
        return ActionResult.func_226249_b_(itemStack);
    }

    public boolean func_208077_a(@Nullable CompoundNBT compoundNBT, EntityType<?> entityType) {
        return Objects.equals(this.func_208076_b(compoundNBT), entityType);
    }

    public int func_195983_a(int n) {
        return n == 0 ? this.field_195988_c : this.field_195989_d;
    }

    @Nullable
    public static SpawnEggItem func_200889_b(@Nullable EntityType<?> entityType) {
        return field_195987_b.get(entityType);
    }

    public static Iterable<SpawnEggItem> func_195985_g() {
        return Iterables.unmodifiableIterable(field_195987_b.values());
    }

    public EntityType<?> func_208076_b(@Nullable CompoundNBT compoundNBT) {
        if (compoundNBT != null && compoundNBT.func_150297_b("EntityTag", 10) && (\u2603 = compoundNBT.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return EntityType.func_220327_a(\u2603.func_74779_i("id")).orElse(this.field_200890_d);
        }
        return this.field_200890_d;
    }

    public Optional<MobEntity> func_234809_a_(PlayerEntity playerEntity, MobEntity mobEntity, EntityType<? extends MobEntity> entityType, World world, Vector3d vector3d, ItemStack itemStack) {
        if (!this.func_208077_a(itemStack.func_77978_p(), entityType)) {
            return Optional.empty();
        }
        MobEntity mobEntity2 = mobEntity instanceof AgeableEntity ? ((AgeableEntity)mobEntity).func_90011_a((AgeableEntity)mobEntity) : entityType.func_200721_a(world);
        if (mobEntity2 == null) {
            return Optional.empty();
        }
        mobEntity2.func_82227_f(true);
        if (!mobEntity2.func_70631_g_()) {
            return Optional.empty();
        }
        mobEntity2.func_70012_b(vector3d.func_82615_a(), vector3d.func_82617_b(), vector3d.func_82616_c(), 0.0f, 0.0f);
        world.func_217376_c(mobEntity2);
        if (itemStack.func_82837_s()) {
            mobEntity2.func_200203_b(itemStack.func_200301_q());
        }
        if (!playerEntity.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        return Optional.of(mobEntity2);
    }
}

