/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.arguments.BlockPredicateArgument;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.UnbreakingEnchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ItemStack {
    public static final Codec<ItemStack> field_234691_a_ = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212630_s.fieldOf("id").forGetter(itemStack -> itemStack.field_151002_e), (App)Codec.INT.fieldOf("Count").forGetter(itemStack -> itemStack.field_77994_a), (App)CompoundNBT.field_240597_a_.optionalFieldOf("tag").forGetter(itemStack -> Optional.ofNullable(itemStack.field_77990_d))).apply((Applicative)instance, ItemStack::new));
    private static final Logger field_199558_c = LogManager.getLogger();
    public static final ItemStack field_190927_a = new ItemStack((IItemProvider)null);
    public static final DecimalFormat field_111284_a = Util.func_200696_a(new DecimalFormat("#.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private static final Style field_234692_e_ = Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_PURPLE).func_240722_b_(true);
    private int field_77994_a;
    private int field_77992_b;
    @Deprecated
    private final Item field_151002_e;
    private CompoundNBT field_77990_d;
    private boolean field_190928_g;
    private Entity field_234693_k_;
    private CachedBlockInfo field_179552_h;
    private boolean field_179553_i;
    private CachedBlockInfo field_179550_j;
    private boolean field_179551_k;

    public ItemStack(IItemProvider iItemProvider) {
        this(iItemProvider, 1);
    }

    private ItemStack(IItemProvider iItemProvider, int n, Optional<CompoundNBT> optional) {
        this(iItemProvider, n);
        optional.ifPresent(this::func_77982_d);
    }

    public ItemStack(IItemProvider iItemProvider, int n) {
        this.field_151002_e = iItemProvider == null ? null : iItemProvider.func_199767_j();
        this.field_77994_a = n;
        if (this.field_151002_e != null && this.field_151002_e.func_77645_m()) {
            this.func_196085_b(this.func_77952_i());
        }
        this.func_190923_F();
    }

    private void func_190923_F() {
        this.field_190928_g = false;
        this.field_190928_g = this.func_190926_b();
    }

    private ItemStack(CompoundNBT compoundNBT) {
        this.field_151002_e = Registry.field_212630_s.func_82594_a(new ResourceLocation(compoundNBT.func_74779_i("id")));
        this.field_77994_a = compoundNBT.func_74771_c("Count");
        if (compoundNBT.func_150297_b("tag", 10)) {
            this.field_77990_d = compoundNBT.func_74775_l("tag");
            this.func_77973_b().func_179215_a(compoundNBT);
        }
        if (this.func_77973_b().func_77645_m()) {
            this.func_196085_b(this.func_77952_i());
        }
        this.func_190923_F();
    }

    public static ItemStack func_199557_a(CompoundNBT compoundNBT) {
        try {
            return new ItemStack(compoundNBT);
        }
        catch (RuntimeException runtimeException) {
            field_199558_c.debug("Tried to load invalid item: {}", (Object)compoundNBT, (Object)runtimeException);
            return field_190927_a;
        }
    }

    public boolean func_190926_b() {
        if (this == field_190927_a) {
            return true;
        }
        if (this.func_77973_b() == null || this.func_77973_b() == Items.field_190931_a) {
            return true;
        }
        return this.field_77994_a <= 0;
    }

    public ItemStack func_77979_a(int n) {
        \u2603 = Math.min(n, this.field_77994_a);
        ItemStack itemStack = this.func_77946_l();
        itemStack.func_190920_e(\u2603);
        this.func_190918_g(\u2603);
        return itemStack;
    }

    public Item func_77973_b() {
        return this.field_190928_g ? Items.field_190931_a : this.field_151002_e;
    }

    public ActionResultType func_196084_a(ItemUseContext itemUseContext) {
        PlayerEntity playerEntity = itemUseContext.func_195999_j();
        BlockPos \u26032 = itemUseContext.func_195995_a();
        CachedBlockInfo \u26033 = new CachedBlockInfo(itemUseContext.func_195991_k(), \u26032, false);
        if (playerEntity != null && !playerEntity.field_71075_bZ.field_75099_e && !this.func_206847_b(itemUseContext.func_195991_k().func_205772_D(), \u26033)) {
            return ActionResultType.PASS;
        }
        Item \u26034 = this.func_77973_b();
        ActionResultType \u26035 = \u26034.func_195939_a(itemUseContext);
        if (playerEntity != null && \u26035.func_226246_a_()) {
            playerEntity.func_71029_a(Stats.field_75929_E.func_199076_b(\u26034));
        }
        return \u26035;
    }

    public float func_150997_a(BlockState blockState) {
        return this.func_77973_b().func_150893_a(this, blockState);
    }

    public ActionResult<ItemStack> func_77957_a(World world, PlayerEntity playerEntity, Hand hand) {
        return this.func_77973_b().func_77659_a(world, playerEntity, hand);
    }

    public ItemStack func_77950_b(World world, LivingEntity livingEntity) {
        return this.func_77973_b().func_77654_b(this, world, livingEntity);
    }

    public CompoundNBT func_77955_b(CompoundNBT compoundNBT) {
        ResourceLocation resourceLocation = Registry.field_212630_s.func_177774_c(this.func_77973_b());
        compoundNBT.func_74778_a("id", resourceLocation == null ? "minecraft:air" : resourceLocation.toString());
        compoundNBT.func_74774_a("Count", (byte)this.field_77994_a);
        if (this.field_77990_d != null) {
            compoundNBT.func_218657_a("tag", this.field_77990_d.func_74737_b());
        }
        return compoundNBT;
    }

    public int func_77976_d() {
        return this.func_77973_b().func_77639_j();
    }

    public boolean func_77985_e() {
        return this.func_77976_d() > 1 && (!this.func_77984_f() || !this.func_77951_h());
    }

    public boolean func_77984_f() {
        if (this.field_190928_g || this.func_77973_b().func_77612_l() <= 0) {
            return false;
        }
        CompoundNBT compoundNBT = this.func_77978_p();
        return compoundNBT == null || !compoundNBT.func_74767_n("Unbreakable");
    }

    public boolean func_77951_h() {
        return this.func_77984_f() && this.func_77952_i() > 0;
    }

    public int func_77952_i() {
        return this.field_77990_d == null ? 0 : this.field_77990_d.func_74762_e("Damage");
    }

    public void func_196085_b(int n) {
        this.func_196082_o().func_74768_a("Damage", Math.max(0, n));
    }

    public int func_77958_k() {
        return this.func_77973_b().func_77612_l();
    }

    public boolean func_96631_a(int n, Random random, @Nullable ServerPlayerEntity serverPlayerEntity2) {
        ServerPlayerEntity serverPlayerEntity2;
        int \u26032;
        if (!this.func_77984_f()) {
            return false;
        }
        if (n > 0) {
            \u26032 = EnchantmentHelper.func_77506_a(Enchantments.field_185307_s, this);
            \u2603 = 0;
            for (\u2603 = 0; \u26032 > 0 && \u2603 < n; ++\u2603) {
                if (!UnbreakingEnchantment.func_92097_a(this, \u26032, random)) continue;
                ++\u2603;
            }
            if ((n -= \u2603) <= 0) {
                return false;
            }
        }
        if (serverPlayerEntity2 != null && n != 0) {
            CriteriaTriggers.field_193132_s.func_193158_a(serverPlayerEntity2, this, this.func_77952_i() + n);
        }
        \u26032 = this.func_77952_i() + n;
        this.func_196085_b(\u26032);
        return \u26032 >= this.func_77958_k();
    }

    public <T extends LivingEntity> void func_222118_a(int n, T t, Consumer<T> consumer) {
        if (t.field_70170_p.field_72995_K || t instanceof PlayerEntity && ((PlayerEntity)t).field_71075_bZ.field_75098_d) {
            return;
        }
        if (!this.func_77984_f()) {
            return;
        }
        if (this.func_96631_a(n, t.func_70681_au(), t instanceof ServerPlayerEntity ? (ServerPlayerEntity)t : null)) {
            consumer.accept(t);
            Item item = this.func_77973_b();
            this.func_190918_g(1);
            if (t instanceof PlayerEntity) {
                ((PlayerEntity)t).func_71029_a(Stats.field_199088_e.func_199076_b(item));
            }
            this.func_196085_b(0);
        }
    }

    public void func_77961_a(LivingEntity livingEntity, PlayerEntity playerEntity) {
        Item item = this.func_77973_b();
        if (item.func_77644_a(this, livingEntity, playerEntity)) {
            playerEntity.func_71029_a(Stats.field_75929_E.func_199076_b(item));
        }
    }

    public void func_179548_a(World world, BlockState blockState, BlockPos blockPos, PlayerEntity playerEntity) {
        Item item = this.func_77973_b();
        if (item.func_179218_a(this, world, blockState, blockPos, playerEntity)) {
            playerEntity.func_71029_a(Stats.field_75929_E.func_199076_b(item));
        }
    }

    public boolean func_150998_b(BlockState blockState) {
        return this.func_77973_b().func_150897_b(blockState);
    }

    public ActionResultType func_111282_a_(PlayerEntity playerEntity, LivingEntity livingEntity, Hand hand) {
        return this.func_77973_b().func_111207_a(this, playerEntity, livingEntity, hand);
    }

    public ItemStack func_77946_l() {
        if (this.func_190926_b()) {
            return field_190927_a;
        }
        ItemStack itemStack = new ItemStack(this.func_77973_b(), this.field_77994_a);
        itemStack.func_190915_d(this.func_190921_D());
        if (this.field_77990_d != null) {
            itemStack.field_77990_d = this.field_77990_d.func_74737_b();
        }
        return itemStack;
    }

    public static boolean func_77970_a(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack.func_190926_b() && itemStack2.func_190926_b()) {
            return true;
        }
        if (itemStack.func_190926_b() || itemStack2.func_190926_b()) {
            return false;
        }
        if (itemStack.field_77990_d == null && itemStack2.field_77990_d != null) {
            return false;
        }
        return itemStack.field_77990_d == null || itemStack.field_77990_d.equals(itemStack2.field_77990_d);
    }

    public static boolean func_77989_b(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack.func_190926_b() && itemStack2.func_190926_b()) {
            return true;
        }
        if (itemStack.func_190926_b() || itemStack2.func_190926_b()) {
            return false;
        }
        return itemStack.func_77959_d(itemStack2);
    }

    private boolean func_77959_d(ItemStack itemStack) {
        if (this.field_77994_a != itemStack.field_77994_a) {
            return false;
        }
        if (this.func_77973_b() != itemStack.func_77973_b()) {
            return false;
        }
        if (this.field_77990_d == null && itemStack.field_77990_d != null) {
            return false;
        }
        return this.field_77990_d == null || this.field_77990_d.equals(itemStack.field_77990_d);
    }

    public static boolean func_179545_c(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == itemStack2) {
            return true;
        }
        if (!itemStack.func_190926_b() && !itemStack2.func_190926_b()) {
            return itemStack.func_77969_a(itemStack2);
        }
        return false;
    }

    public static boolean func_185132_d(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == itemStack2) {
            return true;
        }
        if (!itemStack.func_190926_b() && !itemStack2.func_190926_b()) {
            return itemStack.func_185136_b(itemStack2);
        }
        return false;
    }

    public boolean func_77969_a(ItemStack itemStack) {
        return !itemStack.func_190926_b() && this.func_77973_b() == itemStack.func_77973_b();
    }

    public boolean func_185136_b(ItemStack itemStack) {
        if (this.func_77984_f()) {
            return !itemStack.func_190926_b() && this.func_77973_b() == itemStack.func_77973_b();
        }
        return this.func_77969_a(itemStack);
    }

    public String func_77977_a() {
        return this.func_77973_b().func_77667_c(this);
    }

    public String toString() {
        return this.field_77994_a + " " + this.func_77973_b();
    }

    public void func_77945_a(World world, Entity entity, int n, boolean bl) {
        if (this.field_77992_b > 0) {
            --this.field_77992_b;
        }
        if (this.func_77973_b() != null) {
            this.func_77973_b().func_77663_a(this, world, entity, n, bl);
        }
    }

    public void func_77980_a(World world, PlayerEntity playerEntity, int n) {
        playerEntity.func_71064_a(Stats.field_188066_af.func_199076_b(this.func_77973_b()), n);
        this.func_77973_b().func_77622_d(this, world, playerEntity);
    }

    public int func_77988_m() {
        return this.func_77973_b().func_77626_a(this);
    }

    public UseAction func_77975_n() {
        return this.func_77973_b().func_77661_b(this);
    }

    public void func_77974_b(World world, LivingEntity livingEntity, int n) {
        this.func_77973_b().func_77615_a(this, world, livingEntity, n);
    }

    public boolean func_222122_m() {
        return this.func_77973_b().func_219970_i(this);
    }

    public boolean func_77942_o() {
        return !this.field_190928_g && this.field_77990_d != null && !this.field_77990_d.isEmpty();
    }

    @Nullable
    public CompoundNBT func_77978_p() {
        return this.field_77990_d;
    }

    public CompoundNBT func_196082_o() {
        if (this.field_77990_d == null) {
            this.func_77982_d(new CompoundNBT());
        }
        return this.field_77990_d;
    }

    public CompoundNBT func_190925_c(String string2) {
        String string2;
        if (this.field_77990_d == null || !this.field_77990_d.func_150297_b(string2, 10)) {
            CompoundNBT compoundNBT = new CompoundNBT();
            this.func_77983_a(string2, compoundNBT);
            return compoundNBT;
        }
        return this.field_77990_d.func_74775_l(string2);
    }

    @Nullable
    public CompoundNBT func_179543_a(String string) {
        if (this.field_77990_d == null || !this.field_77990_d.func_150297_b(string, 10)) {
            return null;
        }
        return this.field_77990_d.func_74775_l(string);
    }

    public void func_196083_e(String string) {
        if (this.field_77990_d != null && this.field_77990_d.func_74764_b(string)) {
            this.field_77990_d.func_82580_o(string);
            if (this.field_77990_d.isEmpty()) {
                this.field_77990_d = null;
            }
        }
    }

    public ListNBT func_77986_q() {
        if (this.field_77990_d != null) {
            return this.field_77990_d.func_150295_c("Enchantments", 10);
        }
        return new ListNBT();
    }

    public void func_77982_d(@Nullable CompoundNBT compoundNBT) {
        this.field_77990_d = compoundNBT;
        if (this.func_77973_b().func_77645_m()) {
            this.func_196085_b(this.func_77952_i());
        }
    }

    public ITextComponent func_200301_q() {
        CompoundNBT compoundNBT = this.func_179543_a("display");
        if (compoundNBT != null && compoundNBT.func_150297_b("Name", 8)) {
            try {
                IFormattableTextComponent iFormattableTextComponent = ITextComponent.Serializer.func_240643_a_(compoundNBT.func_74779_i("Name"));
                if (iFormattableTextComponent != null) {
                    return iFormattableTextComponent;
                }
                compoundNBT.func_82580_o("Name");
            }
            catch (JsonParseException jsonParseException) {
                compoundNBT.func_82580_o("Name");
            }
        }
        return this.func_77973_b().func_200295_i(this);
    }

    public ItemStack func_200302_a(@Nullable ITextComponent iTextComponent) {
        CompoundNBT compoundNBT = this.func_190925_c("display");
        if (iTextComponent != null) {
            compoundNBT.func_74778_a("Name", ITextComponent.Serializer.func_150696_a(iTextComponent));
        } else {
            compoundNBT.func_82580_o("Name");
        }
        return this;
    }

    public void func_135074_t() {
        CompoundNBT compoundNBT = this.func_179543_a("display");
        if (compoundNBT != null) {
            compoundNBT.func_82580_o("Name");
            if (compoundNBT.isEmpty()) {
                this.func_196083_e("display");
            }
        }
        if (this.field_77990_d != null && this.field_77990_d.isEmpty()) {
            this.field_77990_d = null;
        }
    }

    public boolean func_82837_s() {
        CompoundNBT compoundNBT = this.func_179543_a("display");
        return compoundNBT != null && compoundNBT.func_150297_b("Name", 8);
    }

    public List<ITextComponent> func_82840_a(@Nullable PlayerEntity playerEntity, ITooltipFlag iTooltipFlag2) {
        ITooltipFlag iTooltipFlag2;
        Object object;
        Object object2;
        ArrayList arrayList = Lists.newArrayList();
        IFormattableTextComponent \u26032 = new StringTextComponent("").func_230529_a_(this.func_200301_q()).func_240699_a_(this.func_77953_t().field_77937_e);
        if (this.func_82837_s()) {
            \u26032.func_240699_a_(TextFormatting.ITALIC);
        }
        arrayList.add(\u26032);
        if (!iTooltipFlag2.func_194127_a() && !this.func_82837_s() && this.func_77973_b() == Items.field_151098_aY) {
            arrayList.add(new StringTextComponent("#" + FilledMapItem.func_195949_f(this)).func_240699_a_(TextFormatting.GRAY));
        }
        int \u26033 = 0;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("HideFlags", 99)) {
            \u26033 = this.field_77990_d.func_74762_e("HideFlags");
        }
        if ((\u26033 & 0x20) == 0) {
            this.func_77973_b().func_77624_a(this, playerEntity == null ? null : playerEntity.field_70170_p, arrayList, iTooltipFlag2);
        }
        if (this.func_77942_o()) {
            if ((\u26033 & 1) == 0) {
                ItemStack.func_222120_a(arrayList, this.func_77986_q());
            }
            if (this.field_77990_d.func_150297_b("display", 10)) {
                object2 = this.field_77990_d.func_74775_l("display");
                if (((CompoundNBT)object2).func_150297_b("color", 3)) {
                    if (iTooltipFlag2.func_194127_a()) {
                        arrayList.add(new TranslationTextComponent("item.color", String.format("#%06X", ((CompoundNBT)object2).func_74762_e("color"))).func_240699_a_(TextFormatting.GRAY));
                    } else {
                        arrayList.add(new TranslationTextComponent("item.dyed").func_240701_a_(TextFormatting.GRAY, TextFormatting.ITALIC));
                    }
                }
                if (((CompoundNBT)object2).func_150299_b("Lore") == 9) {
                    ListNBT listNBT = ((CompoundNBT)object2).func_150295_c("Lore", 8);
                    for (int i = 0; i < listNBT.size(); ++i) {
                        object = listNBT.func_150307_f(i);
                        try {
                            \u2603 = ITextComponent.Serializer.func_240643_a_((String)object);
                            if (\u2603 == null) continue;
                            arrayList.add(TextComponentUtils.func_240648_a_(\u2603, field_234692_e_));
                            continue;
                        }
                        catch (JsonParseException \u26034) {
                            ((CompoundNBT)object2).func_82580_o("Lore");
                        }
                    }
                }
            }
        }
        object2 = EquipmentSlotType.values();
        int listNBT = ((EquipmentSlotType[])object2).length;
        for (int i = 0; i < listNBT; ++i) {
            object = object2[i];
            \u2603 = this.func_111283_C((EquipmentSlotType)((Object)object));
            if (\u2603.isEmpty() || (\u26033 & 2) != 0) continue;
            arrayList.add(StringTextComponent.field_240750_d_);
            arrayList.add(new TranslationTextComponent("item.modifiers." + object.func_188450_d()).func_240699_a_(TextFormatting.GRAY));
            for (Map.Entry entry : \u2603.entries()) {
                AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
                double \u26035 = attributeModifier.func_111164_d();
                boolean \u26036 = false;
                if (playerEntity != null) {
                    if (attributeModifier.func_111167_a() == Item.field_111210_e) {
                        \u26035 += playerEntity.func_233638_c_(Attributes.field_233823_f_);
                        \u26035 += (double)EnchantmentHelper.func_152377_a(this, CreatureAttribute.field_223222_a_);
                        \u26036 = true;
                    } else if (attributeModifier.func_111167_a() == Item.field_185050_h) {
                        \u26035 += playerEntity.func_233638_c_(Attributes.field_233825_h_);
                        \u26036 = true;
                    }
                }
                double \u26037 = attributeModifier.func_220375_c() == AttributeModifier.Operation.MULTIPLY_BASE || attributeModifier.func_220375_c() == AttributeModifier.Operation.MULTIPLY_TOTAL ? \u26035 * 100.0 : (((Attribute)entry.getKey()).equals(Attributes.field_233820_c_) ? \u26035 * 10.0 : \u26035);
                if (\u26036) {
                    arrayList.add(new StringTextComponent(" ").func_230529_a_(new TranslationTextComponent("attribute.modifier.equals." + attributeModifier.func_220375_c().func_220371_a(), field_111284_a.format(\u26037), new TranslationTextComponent(((Attribute)entry.getKey()).func_233754_c_()))).func_240699_a_(TextFormatting.DARK_GREEN));
                    continue;
                }
                if (\u26035 > 0.0) {
                    arrayList.add(new TranslationTextComponent("attribute.modifier.plus." + attributeModifier.func_220375_c().func_220371_a(), field_111284_a.format(\u26037), new TranslationTextComponent(((Attribute)entry.getKey()).func_233754_c_())).func_240699_a_(TextFormatting.BLUE));
                    continue;
                }
                if (!(\u26035 < 0.0)) continue;
                arrayList.add(new TranslationTextComponent("attribute.modifier.take." + attributeModifier.func_220375_c().func_220371_a(), field_111284_a.format(\u26037 *= -1.0), new TranslationTextComponent(((Attribute)entry.getKey()).func_233754_c_())).func_240699_a_(TextFormatting.RED));
            }
        }
        if (this.func_77942_o() && this.func_77978_p().func_74767_n("Unbreakable") && (\u26033 & 4) == 0) {
            arrayList.add(new TranslationTextComponent("item.unbreakable").func_240699_a_(TextFormatting.BLUE));
        }
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanDestroy", 9) && (\u26033 & 8) == 0 && !((ListNBT)(object2 = this.field_77990_d.func_150295_c("CanDestroy", 8))).isEmpty()) {
            arrayList.add(StringTextComponent.field_240750_d_);
            arrayList.add(new TranslationTextComponent("item.canBreak").func_240699_a_(TextFormatting.GRAY));
            for (listNBT = 0; listNBT < ((ListNBT)object2).size(); ++listNBT) {
                arrayList.addAll(ItemStack.func_206845_f(((ListNBT)object2).func_150307_f(listNBT)));
            }
        }
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanPlaceOn", 9) && (\u26033 & 0x10) == 0 && !((ListNBT)(object2 = this.field_77990_d.func_150295_c("CanPlaceOn", 8))).isEmpty()) {
            arrayList.add(StringTextComponent.field_240750_d_);
            arrayList.add(new TranslationTextComponent("item.canPlace").func_240699_a_(TextFormatting.GRAY));
            for (listNBT = 0; listNBT < ((ListNBT)object2).size(); ++listNBT) {
                arrayList.addAll(ItemStack.func_206845_f(((ListNBT)object2).func_150307_f(listNBT)));
            }
        }
        if (iTooltipFlag2.func_194127_a()) {
            if (this.func_77951_h()) {
                arrayList.add(new TranslationTextComponent("item.durability", this.func_77958_k() - this.func_77952_i(), this.func_77958_k()));
            }
            arrayList.add(new StringTextComponent(Registry.field_212630_s.func_177774_c(this.func_77973_b()).toString()).func_240699_a_(TextFormatting.DARK_GRAY));
            if (this.func_77942_o()) {
                arrayList.add(new TranslationTextComponent("item.nbt_tags", this.func_77978_p().func_150296_c().size()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
        return arrayList;
    }

    public static void func_222120_a(List<ITextComponent> list, ListNBT listNBT) {
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT compoundNBT = listNBT.func_150305_b(i);
            Registry.field_212628_q.func_218349_b(ResourceLocation.func_208304_a(compoundNBT.func_74779_i("id"))).ifPresent(enchantment -> list.add(enchantment.func_200305_d(compoundNBT.func_74762_e("lvl"))));
        }
    }

    private static Collection<ITextComponent> func_206845_f(String string) {
        try {
            BlockStateParser blockStateParser = new BlockStateParser(new StringReader(string), true).func_197243_a(true);
            BlockState \u26032 = blockStateParser.func_197249_b();
            ResourceLocation \u26033 = blockStateParser.func_199829_d();
            boolean \u26034 = \u26032 != null;
            boolean bl = \u2603 = \u26033 != null;
            if (\u26034 || \u2603) {
                if (\u26034) {
                    return Lists.newArrayList((Object[])new ITextComponent[]{\u26032.func_177230_c().func_235333_g_().func_240699_a_(TextFormatting.DARK_GRAY)});
                }
                ITag<Block> iTag = BlockTags.func_199896_a().func_199910_a(\u26033);
                if (iTag != null && !(\u2603 = iTag.func_230236_b_()).isEmpty()) {
                    return \u2603.stream().map(Block::func_235333_g_).map(iFormattableTextComponent -> iFormattableTextComponent.func_240699_a_(TextFormatting.DARK_GRAY)).collect(Collectors.toList());
                }
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return Lists.newArrayList((Object[])new ITextComponent[]{new StringTextComponent("missingno").func_240699_a_(TextFormatting.DARK_GRAY)});
    }

    public boolean func_77962_s() {
        return this.func_77973_b().func_77636_d(this);
    }

    public Rarity func_77953_t() {
        return this.func_77973_b().func_77613_e(this);
    }

    public boolean func_77956_u() {
        if (!this.func_77973_b().func_77616_k(this)) {
            return false;
        }
        return !this.func_77948_v();
    }

    public void func_77966_a(Enchantment enchantment, int n) {
        this.func_196082_o();
        if (!this.field_77990_d.func_150297_b("Enchantments", 9)) {
            this.field_77990_d.func_218657_a("Enchantments", new ListNBT());
        }
        ListNBT listNBT = this.field_77990_d.func_150295_c("Enchantments", 10);
        CompoundNBT \u26032 = new CompoundNBT();
        \u26032.func_74778_a("id", String.valueOf(Registry.field_212628_q.func_177774_c(enchantment)));
        \u26032.func_74777_a("lvl", (byte)n);
        listNBT.add(\u26032);
    }

    public boolean func_77948_v() {
        if (this.field_77990_d != null && this.field_77990_d.func_150297_b("Enchantments", 9)) {
            return !this.field_77990_d.func_150295_c("Enchantments", 10).isEmpty();
        }
        return false;
    }

    public void func_77983_a(String string, INBT iNBT) {
        this.func_196082_o().func_218657_a(string, iNBT);
    }

    public boolean func_82839_y() {
        return this.field_234693_k_ instanceof ItemFrameEntity;
    }

    public void func_234695_a_(@Nullable Entity entity) {
        this.field_234693_k_ = entity;
    }

    @Nullable
    public ItemFrameEntity func_82836_z() {
        return this.field_234693_k_ instanceof ItemFrameEntity ? (ItemFrameEntity)this.func_234694_A_() : null;
    }

    @Nullable
    public Entity func_234694_A_() {
        return !this.field_190928_g ? this.field_234693_k_ : null;
    }

    public int func_82838_A() {
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("RepairCost", 3)) {
            return this.field_77990_d.func_74762_e("RepairCost");
        }
        return 0;
    }

    public void func_82841_c(int n) {
        this.func_196082_o().func_74768_a("RepairCost", n);
    }

    public Multimap<Attribute, AttributeModifier> func_111283_C(EquipmentSlotType equipmentSlotType2) {
        HashMultimap \u26033;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("AttributeModifiers", 9)) {
            \u26033 = HashMultimap.create();
            ListNBT \u26032 = this.field_77990_d.func_150295_c("AttributeModifiers", 10);
            for (int i = 0; i < \u26032.size(); ++i) {
                CompoundNBT compoundNBT = \u26032.func_150305_b(i);
                if (compoundNBT.func_150297_b("Slot", 8) && !compoundNBT.func_74779_i("Slot").equals(equipmentSlotType2.func_188450_d()) || !(\u2603 = Registry.field_239692_aP_.func_218349_b(ResourceLocation.func_208304_a(compoundNBT.func_74779_i("AttributeName")))).isPresent() || (\u2603 = AttributeModifier.func_233800_a_(compoundNBT)) == null || \u2603.func_111167_a().getLeastSignificantBits() == 0L || \u2603.func_111167_a().getMostSignificantBits() == 0L) continue;
                \u26033.put((Object)\u2603.get(), (Object)\u2603);
            }
        } else {
            EquipmentSlotType equipmentSlotType2;
            \u26033 = this.func_77973_b().func_111205_h(equipmentSlotType2);
        }
        return \u26033;
    }

    public void func_185129_a(Attribute attribute, AttributeModifier attributeModifier, @Nullable EquipmentSlotType equipmentSlotType) {
        this.func_196082_o();
        if (!this.field_77990_d.func_150297_b("AttributeModifiers", 9)) {
            this.field_77990_d.func_218657_a("AttributeModifiers", new ListNBT());
        }
        ListNBT listNBT = this.field_77990_d.func_150295_c("AttributeModifiers", 10);
        CompoundNBT \u26032 = attributeModifier.func_233801_e_();
        \u26032.func_74778_a("AttributeName", Registry.field_239692_aP_.func_177774_c(attribute).toString());
        if (equipmentSlotType != null) {
            \u26032.func_74778_a("Slot", equipmentSlotType.func_188450_d());
        }
        listNBT.add(\u26032);
    }

    public ITextComponent func_151000_E() {
        IFormattableTextComponent iFormattableTextComponent = new StringTextComponent("").func_230529_a_(this.func_200301_q());
        if (this.func_82837_s()) {
            iFormattableTextComponent.func_240699_a_(TextFormatting.ITALIC);
        }
        \u2603 = TextComponentUtils.func_240647_a_(iFormattableTextComponent);
        if (!this.field_190928_g) {
            \u2603.func_240699_a_(this.func_77953_t().field_77937_e).func_240700_a_(style -> style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230551_b_, new HoverEvent.ItemHover(this))));
        }
        return \u2603;
    }

    private static boolean func_206846_a(CachedBlockInfo cachedBlockInfo, @Nullable CachedBlockInfo cachedBlockInfo2) {
        if (cachedBlockInfo2 == null || cachedBlockInfo.func_177509_a() != cachedBlockInfo2.func_177509_a()) {
            return false;
        }
        if (cachedBlockInfo.func_177507_b() == null && cachedBlockInfo2.func_177507_b() == null) {
            return true;
        }
        if (cachedBlockInfo.func_177507_b() == null || cachedBlockInfo2.func_177507_b() == null) {
            return false;
        }
        return Objects.equals(cachedBlockInfo.func_177507_b().func_189515_b(new CompoundNBT()), cachedBlockInfo2.func_177507_b().func_189515_b(new CompoundNBT()));
    }

    public boolean func_206848_a(NetworkTagManager networkTagManager, CachedBlockInfo cachedBlockInfo) {
        if (ItemStack.func_206846_a(cachedBlockInfo, this.field_179552_h)) {
            return this.field_179553_i;
        }
        this.field_179552_h = cachedBlockInfo;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanDestroy", 9)) {
            ListNBT listNBT = this.field_77990_d.func_150295_c("CanDestroy", 8);
            for (int i = 0; i < listNBT.size(); ++i) {
                String string = listNBT.func_150307_f(i);
                try {
                    Predicate<CachedBlockInfo> predicate = BlockPredicateArgument.func_199824_a().parse(new StringReader(string)).create(networkTagManager);
                    if (predicate.test(cachedBlockInfo)) {
                        this.field_179553_i = true;
                        return true;
                    }
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        this.field_179553_i = false;
        return false;
    }

    public boolean func_206847_b(NetworkTagManager networkTagManager, CachedBlockInfo cachedBlockInfo) {
        if (ItemStack.func_206846_a(cachedBlockInfo, this.field_179550_j)) {
            return this.field_179551_k;
        }
        this.field_179550_j = cachedBlockInfo;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanPlaceOn", 9)) {
            ListNBT listNBT = this.field_77990_d.func_150295_c("CanPlaceOn", 8);
            for (int i = 0; i < listNBT.size(); ++i) {
                String string = listNBT.func_150307_f(i);
                try {
                    Predicate<CachedBlockInfo> predicate = BlockPredicateArgument.func_199824_a().parse(new StringReader(string)).create(networkTagManager);
                    if (predicate.test(cachedBlockInfo)) {
                        this.field_179551_k = true;
                        return true;
                    }
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        this.field_179551_k = false;
        return false;
    }

    public int func_190921_D() {
        return this.field_77992_b;
    }

    public void func_190915_d(int n) {
        this.field_77992_b = n;
    }

    public int func_190916_E() {
        return this.field_190928_g ? 0 : this.field_77994_a;
    }

    public void func_190920_e(int n) {
        this.field_77994_a = n;
        this.func_190923_F();
    }

    public void func_190917_f(int n) {
        this.func_190920_e(this.field_77994_a + n);
    }

    public void func_190918_g(int n) {
        this.func_190917_f(-n);
    }

    public void func_222121_b(World world, LivingEntity livingEntity, int n) {
        this.func_77973_b().func_219972_a(world, livingEntity, this, n);
    }

    public boolean func_222117_E() {
        return this.func_77973_b().func_219971_r();
    }

    public SoundEvent func_226629_F_() {
        return this.func_77973_b().func_225520_U__();
    }

    public SoundEvent func_226630_G_() {
        return this.func_77973_b().func_225519_S__();
    }
}

