/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CompassItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ItemModelsProperties {
    private static final Map<ResourceLocation, IItemPropertyGetter> field_239410_a_ = Maps.newHashMap();
    private static final ResourceLocation field_239411_b_ = new ResourceLocation("damaged");
    private static final ResourceLocation field_239412_c_ = new ResourceLocation("damage");
    private static final IItemPropertyGetter field_239413_d_ = (itemStack, clientWorld, livingEntity) -> itemStack.func_77951_h() ? 1.0f : 0.0f;
    private static final IItemPropertyGetter field_239414_e_ = (itemStack, clientWorld, livingEntity) -> MathHelper.func_76131_a((float)itemStack.func_77952_i() / (float)itemStack.func_77958_k(), 0.0f, 1.0f);
    private static final Map<Item, Map<ResourceLocation, IItemPropertyGetter>> field_239415_f_ = Maps.newHashMap();

    private static IItemPropertyGetter func_239420_a_(ResourceLocation resourceLocation, IItemPropertyGetter iItemPropertyGetter) {
        field_239410_a_.put(resourceLocation, iItemPropertyGetter);
        return iItemPropertyGetter;
    }

    private static void func_239418_a_(Item item2, ResourceLocation resourceLocation, IItemPropertyGetter iItemPropertyGetter) {
        field_239415_f_.computeIfAbsent(item2, item -> Maps.newHashMap()).put(resourceLocation, iItemPropertyGetter);
    }

    @Nullable
    public static IItemPropertyGetter func_239417_a_(Item item, ResourceLocation resourceLocation) {
        if (item.func_77612_l() > 0) {
            if (field_239412_c_.equals(resourceLocation)) {
                return field_239414_e_;
            }
            if (field_239411_b_.equals(resourceLocation)) {
                return field_239413_d_;
            }
        }
        if ((\u2603 = field_239410_a_.get(resourceLocation)) != null) {
            return \u2603;
        }
        Map<ResourceLocation, IItemPropertyGetter> map = field_239415_f_.get(item);
        if (map == null) {
            return null;
        }
        return map.get(resourceLocation);
    }

    static {
        ItemModelsProperties.func_239420_a_(new ResourceLocation("lefthanded"), (itemStack, clientWorld, livingEntity) -> livingEntity == null || livingEntity.func_184591_cq() == HandSide.RIGHT ? 0.0f : 1.0f);
        ItemModelsProperties.func_239420_a_(new ResourceLocation("cooldown"), (itemStack, clientWorld, livingEntity) -> livingEntity instanceof PlayerEntity ? ((PlayerEntity)livingEntity).func_184811_cZ().func_185143_a(itemStack.func_77973_b(), 0.0f) : 0.0f);
        ItemModelsProperties.func_239420_a_(new ResourceLocation("custom_model_data"), (itemStack, clientWorld, livingEntity) -> itemStack.func_77942_o() ? (float)itemStack.func_77978_p().func_74762_e("CustomModelData") : 0.0f);
        ItemModelsProperties.func_239418_a_(Items.field_151031_f, new ResourceLocation("pull"), (itemStack, clientWorld, livingEntity) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            if (livingEntity.func_184607_cu() != itemStack) {
                return 0.0f;
            }
            return (float)(itemStack.func_77988_m() - livingEntity.func_184605_cv()) / 20.0f;
        });
        ItemModelsProperties.func_239418_a_(Items.field_151031_f, new ResourceLocation("pulling"), (itemStack, clientWorld, livingEntity) -> livingEntity != null && livingEntity.func_184587_cr() && livingEntity.func_184607_cu() == itemStack ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_(Items.field_151113_aN, new ResourceLocation("time"), new IItemPropertyGetter(){
            private double field_239435_a_;
            private double field_239436_b_;
            private long field_239437_c_;

            @Override
            public float call(ItemStack itemStack, @Nullable ClientWorld clientWorld2, @Nullable LivingEntity livingEntity) {
                double \u26032;
                Entity entity;
                Entity entity2 = entity = livingEntity != null ? livingEntity : itemStack.func_234694_A_();
                if (entity == null) {
                    return 0.0f;
                }
                if (clientWorld2 == null && entity.field_70170_p instanceof ClientWorld) {
                    clientWorld2 = (ClientWorld)entity.field_70170_p;
                }
                if (clientWorld2 == null) {
                    return 0.0f;
                }
                if (clientWorld2.func_230315_m_().func_236043_f_()) {
                    double d = clientWorld2.func_72826_c(1.0f);
                } else {
                    \u26032 = Math.random();
                }
                \u26032 = this.func_239438_a_(clientWorld2, \u26032);
                return (float)\u26032;
            }

            private double func_239438_a_(World world, double d) {
                if (world.func_82737_E() != this.field_239437_c_) {
                    this.field_239437_c_ = world.func_82737_E();
                    \u2603 = d - this.field_239435_a_;
                    \u2603 = MathHelper.func_191273_b(\u2603 + 0.5, 1.0) - 0.5;
                    this.field_239436_b_ += \u2603 * 0.1;
                    this.field_239436_b_ *= 0.9;
                    this.field_239435_a_ = MathHelper.func_191273_b(this.field_239435_a_ + this.field_239436_b_, 1.0);
                }
                return this.field_239435_a_;
            }
        });
        ItemModelsProperties.func_239418_a_(Items.field_151111_aL, new ResourceLocation("angle"), new IItemPropertyGetter(){
            private final Angle field_239439_a_ = new Angle();
            private final Angle field_239440_b_ = new Angle();

            @Override
            public float call(ItemStack itemStack2, @Nullable ClientWorld clientWorld2, @Nullable LivingEntity livingEntity2) {
                double d;
                LivingEntity livingEntity2;
                ItemStack itemStack2;
                Entity entity = \u2603 = livingEntity2 != null ? livingEntity2 : itemStack2.func_234694_A_();
                if (\u2603 == null) {
                    return 0.0f;
                }
                if (clientWorld2 == null && \u2603.field_70170_p instanceof ClientWorld) {
                    ClientWorld clientWorld2 = (ClientWorld)\u2603.field_70170_p;
                }
                BlockPos \u26032 = CompassItem.func_234670_d_(itemStack2) ? this.func_239442_a_(clientWorld2, itemStack2.func_196082_o()) : this.func_239444_a_(clientWorld2);
                long \u26033 = clientWorld2.func_82737_E();
                if (\u26032 == null || \u2603.func_213303_ch().func_186679_c((double)\u26032.func_177958_n() + 0.5, \u2603.func_213303_ch().func_82617_b(), (double)\u26032.func_177952_p() + 0.5) < (double)1.0E-5f) {
                    if (this.field_239440_b_.func_239448_a_(\u26033)) {
                        this.field_239440_b_.func_239449_a_(\u26033, Math.random());
                    }
                    double d2 = this.field_239440_b_.field_239445_a_ + (double)((float)itemStack2.hashCode() / 2.1474836E9f);
                    return MathHelper.func_188207_b((float)d2, 1.0f);
                }
                boolean \u26034 = livingEntity2 instanceof PlayerEntity && ((PlayerEntity)livingEntity2).func_175144_cb();
                double \u26035 = 0.0;
                if (\u26034) {
                    \u26035 = livingEntity2.field_70177_z;
                } else if (\u2603 instanceof ItemFrameEntity) {
                    \u26035 = this.func_239441_a_((ItemFrameEntity)\u2603);
                } else if (\u2603 instanceof ItemEntity) {
                    \u26035 = 180.0f - ((ItemEntity)\u2603).func_234272_a_(0.5f) / ((float)Math.PI * 2) * 360.0f;
                } else if (livingEntity2 != null) {
                    \u26035 = livingEntity2.field_70761_aq;
                }
                \u26035 = MathHelper.func_191273_b(\u26035 / 360.0, 1.0);
                double \u26036 = this.func_239443_a_(Vector3d.func_237489_a_(\u26032), \u2603) / 6.2831854820251465;
                if (\u26034) {
                    if (this.field_239439_a_.func_239448_a_(\u26033)) {
                        this.field_239439_a_.func_239449_a_(\u26033, 0.5 - (\u26035 - 0.25));
                    }
                    d = \u26036 + this.field_239439_a_.field_239445_a_;
                } else {
                    d = 0.5 - (\u26035 - 0.25 - \u26036);
                }
                return MathHelper.func_188207_b((float)d, 1.0f);
            }

            @Nullable
            private BlockPos func_239444_a_(ClientWorld clientWorld) {
                return clientWorld.func_230315_m_().func_236043_f_() ? clientWorld.func_239140_u_() : null;
            }

            @Nullable
            private BlockPos func_239442_a_(World world, CompoundNBT compoundNBT) {
                boolean bl = compoundNBT.func_74764_b("LodestonePos");
                \u2603 = compoundNBT.func_74764_b("LodestoneDimension");
                if (bl && \u2603 && (\u2603 = CompassItem.func_234667_a_(compoundNBT)).isPresent() && world.func_234923_W_() == \u2603.get()) {
                    return NBTUtil.func_186861_c(compoundNBT.func_74775_l("LodestonePos"));
                }
                return null;
            }

            private double func_239441_a_(ItemFrameEntity itemFrameEntity) {
                Direction direction = itemFrameEntity.func_174811_aO();
                int \u26032 = direction.func_176740_k().func_200128_b() ? 90 * direction.func_176743_c().func_179524_a() : 0;
                return MathHelper.func_188209_b(180 + direction.func_176736_b() * 90 + itemFrameEntity.func_82333_j() * 45 + \u26032);
            }

            private double func_239443_a_(Vector3d vector3d, Entity entity) {
                return Math.atan2(vector3d.func_82616_c() - entity.func_226281_cx_(), vector3d.func_82615_a() - entity.func_226277_ct_());
            }
        });
        ItemModelsProperties.func_239418_a_(Items.field_222114_py, new ResourceLocation("pull"), (itemStack, clientWorld, livingEntity) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            if (CrossbowItem.func_220012_d(itemStack)) {
                return 0.0f;
            }
            return (float)(itemStack.func_77988_m() - livingEntity.func_184605_cv()) / (float)CrossbowItem.func_220026_e(itemStack);
        });
        ItemModelsProperties.func_239418_a_(Items.field_222114_py, new ResourceLocation("pulling"), (itemStack, clientWorld, livingEntity) -> livingEntity != null && livingEntity.func_184587_cr() && livingEntity.func_184607_cu() == itemStack && !CrossbowItem.func_220012_d(itemStack) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_(Items.field_222114_py, new ResourceLocation("charged"), (itemStack, clientWorld, livingEntity) -> livingEntity != null && CrossbowItem.func_220012_d(itemStack) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_(Items.field_222114_py, new ResourceLocation("firework"), (itemStack, clientWorld, livingEntity) -> livingEntity != null && CrossbowItem.func_220012_d(itemStack) && CrossbowItem.func_220019_a(itemStack, Items.field_196152_dE) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_(Items.field_185160_cR, new ResourceLocation("broken"), (itemStack, clientWorld, livingEntity) -> ElytraItem.func_185069_d(itemStack) ? 0.0f : 1.0f);
        ItemModelsProperties.func_239418_a_(Items.field_151112_aM, new ResourceLocation("cast"), (itemStack, clientWorld, livingEntity) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            boolean bl = livingEntity.func_184614_ca() == itemStack;
            boolean bl2 = \u2603 = livingEntity.func_184592_cb() == itemStack;
            if (livingEntity.func_184614_ca().func_77973_b() instanceof FishingRodItem) {
                \u2603 = false;
            }
            return (bl || \u2603) && livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71104_cf != null ? 1.0f : 0.0f;
        });
        ItemModelsProperties.func_239418_a_(Items.field_185159_cQ, new ResourceLocation("blocking"), (itemStack, clientWorld, livingEntity) -> livingEntity != null && livingEntity.func_184587_cr() && livingEntity.func_184607_cu() == itemStack ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_(Items.field_203184_eO, new ResourceLocation("throwing"), (itemStack, clientWorld, livingEntity) -> livingEntity != null && livingEntity.func_184587_cr() && livingEntity.func_184607_cu() == itemStack ? 1.0f : 0.0f);
    }

    static class Angle {
        private double field_239445_a_;
        private double field_239446_b_;
        private long field_239447_c_;

        private Angle() {
        }

        private boolean func_239448_a_(long l) {
            return this.field_239447_c_ != l;
        }

        private void func_239449_a_(long l, double d) {
            this.field_239447_c_ = l;
            \u2603 = d - this.field_239445_a_;
            \u2603 = MathHelper.func_191273_b(\u2603 + 0.5, 1.0) - 0.5;
            this.field_239446_b_ += \u2603 * 0.1;
            this.field_239446_b_ *= 0.8;
            this.field_239445_a_ = MathHelper.func_191273_b(this.field_239445_a_ + this.field_239446_b_, 1.0);
        }
    }
}

