/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.AbstractMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;

public class FilledMapItem
extends AbstractMapItem {
    public FilledMapItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack func_195952_a(World world, int n, int n2, byte by, boolean bl, boolean bl2) {
        ItemStack itemStack = new ItemStack(Items.field_151098_aY);
        FilledMapItem.func_195951_a(itemStack, world, n, n2, by, bl, bl2, world.func_234923_W_());
        return itemStack;
    }

    @Nullable
    public static MapData func_219994_a(ItemStack itemStack, World world) {
        return world.func_217406_a(FilledMapItem.func_219993_a(FilledMapItem.func_195949_f(itemStack)));
    }

    @Nullable
    public static MapData func_195950_a(ItemStack itemStack, World world) {
        MapData mapData = FilledMapItem.func_219994_a(itemStack, world);
        if (mapData == null && world instanceof ServerWorld) {
            mapData = FilledMapItem.func_195951_a(itemStack, world, world.func_72912_H().func_76079_c(), world.func_72912_H().func_76074_e(), 3, false, false, world.func_234923_W_());
        }
        return mapData;
    }

    public static int func_195949_f(ItemStack itemStack) {
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        return compoundNBT != null && compoundNBT.func_150297_b("map", 99) ? compoundNBT.func_74762_e("map") : 0;
    }

    private static MapData func_195951_a(ItemStack itemStack, World world, int n, int n2, int n3, boolean bl, boolean bl2, RegistryKey<World> registryKey) {
        int n4 = world.func_217395_y();
        MapData \u26032 = new MapData(FilledMapItem.func_219993_a(n4));
        \u26032.func_237241_a_(n, n2, n3, bl, bl2, registryKey);
        world.func_217399_a(\u26032);
        itemStack.func_196082_o().func_74768_a("map", n4);
        return \u26032;
    }

    public static String func_219993_a(int n) {
        return "map_" + n;
    }

    public void func_77872_a(World world2, Entity entity, MapData mapData) {
        if (world2.func_234923_W_() != mapData.field_76200_c || !(entity instanceof PlayerEntity)) {
            return;
        }
        int n = 1 << mapData.field_76197_d;
        \u2603 = mapData.field_76201_a;
        \u2603 = mapData.field_76199_b;
        \u2603 = MathHelper.func_76128_c(entity.func_226277_ct_() - (double)\u2603) / n + 64;
        \u2603 = MathHelper.func_76128_c(entity.func_226281_cx_() - (double)\u2603) / n + 64;
        \u2603 = 128 / n;
        if (world2.func_230315_m_().func_236037_d_()) {
            \u2603 /= 2;
        }
        MapData.MapInfo \u26032 = mapData.func_82568_a((PlayerEntity)entity);
        ++\u26032.field_82569_d;
        boolean \u26033 = false;
        for (\u2603 = \u2603 - \u2603 + 1; \u2603 < \u2603 + \u2603; ++\u2603) {
            if ((\u2603 & 0xF) != (\u26032.field_82569_d & 0xF) && !\u26033) continue;
            \u26033 = false;
            double d = 0.0;
            for (int i = \u2603 - \u2603 - 1; i < \u2603 + \u2603; ++i) {
                int \u260314;
                if (\u2603 < 0 || i < -1 || \u2603 >= 128 || i >= 128) continue;
                \u2603 = \u2603 - \u2603;
                \u2603 = i - \u2603;
                boolean bl = \u2603 * \u2603 + \u2603 * \u2603 > (\u2603 - 2) * (\u2603 - 2);
                int \u26034 = (\u2603 / n + \u2603 - 64) * n;
                int \u26035 = (\u2603 / n + i - 64) * n;
                LinkedHashMultiset \u26036 = LinkedHashMultiset.create();
                Chunk \u26037 = world2.func_175726_f(new BlockPos(\u26034, 0, \u26035));
                if (\u26037.func_76621_g()) continue;
                ChunkPos \u26038 = \u26037.func_76632_l();
                int \u26039 = \u26034 & 0xF;
                int \u260310 = \u26035 & 0xF;
                int \u260311 = 0;
                double \u260312 = 0.0;
                if (world2.func_230315_m_().func_236037_d_()) {
                    int n2 = \u26034 + \u26035 * 231871;
                    if (((n2 = n2 * n2 * 31287121 + n2 * 11) >> 20 & 1) == 0) {
                        \u26036.add((Object)Blocks.field_150346_d.func_176223_P().func_185909_g(world2, BlockPos.field_177992_a), 10);
                    } else {
                        \u26036.add((Object)Blocks.field_150348_b.func_176223_P().func_185909_g(world2, BlockPos.field_177992_a), 100);
                    }
                    \u260312 = 100.0;
                } else {
                    BlockPos.Mutable mutable = new BlockPos.Mutable();
                    \u2603 = new BlockPos.Mutable();
                    for (\u260314 = 0; \u260314 < n; ++\u260314) {
                        for (\u2603 = 0; \u2603 < n; ++\u2603) {
                            BlockState \u260313;
                            \u2603 = \u26037.func_201576_a(Heightmap.Type.WORLD_SURFACE, \u260314 + \u26039, \u2603 + \u260310) + 1;
                            if (\u2603 > 1) {
                                do {
                                    mutable.func_181079_c(\u26038.func_180334_c() + \u260314 + \u26039, --\u2603, \u26038.func_180333_d() + \u2603 + \u260310);
                                } while ((\u260313 = \u26037.func_180495_p(mutable)).func_185909_g(world2, mutable) == MaterialColor.field_151660_b && \u2603 > 0);
                                if (\u2603 > 0 && !\u260313.func_204520_s().func_206888_e()) {
                                    World world2;
                                    \u2603 = \u2603 - 1;
                                    \u2603.func_189533_g(mutable);
                                    do {
                                        \u2603.func_185336_p(\u2603--);
                                        BlockState blockState = \u26037.func_180495_p(\u2603);
                                        ++\u260311;
                                    } while (\u2603 > 0 && !blockState.func_204520_s().func_206888_e());
                                    \u260313 = this.func_211698_a(world2, \u260313, mutable);
                                }
                            } else {
                                \u260313 = Blocks.field_150357_h.func_176223_P();
                            }
                            mapData.func_204268_a(world2, \u26038.func_180334_c() + \u260314 + \u26039, \u26038.func_180333_d() + \u2603 + \u260310);
                            \u260312 += (double)\u2603 / (double)(n * n);
                            \u26036.add((Object)\u260313.func_185909_g(world2, mutable));
                        }
                    }
                }
                \u260311 /= n * n;
                double d2 = (\u260312 - d) * 4.0 / (double)(n + 4) + ((double)(\u2603 + i & 1) - 0.5) * 0.4;
                \u260314 = 1;
                if (d2 > 0.6) {
                    \u260314 = 2;
                }
                if (d2 < -0.6) {
                    \u260314 = 0;
                }
                if ((\u2603 = (MaterialColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)\u26036), (Object)MaterialColor.field_151660_b)) == MaterialColor.field_151662_n) {
                    d2 = (double)\u260311 * 0.1 + (double)(\u2603 + i & 1) * 0.2;
                    \u260314 = 1;
                    if (d2 < 0.5) {
                        \u260314 = 2;
                    }
                    if (d2 > 0.9) {
                        \u260314 = 0;
                    }
                }
                d = \u260312;
                if (i < 0 || \u2603 * \u2603 + \u2603 * \u2603 >= \u2603 * \u2603 || bl && (\u2603 + i & 1) == 0 || (\u2603 = mapData.field_76198_e[\u2603 + i * 128]) == (\u2603 = (byte)(\u2603.field_76290_q * 4 + \u260314))) continue;
                mapData.field_76198_e[\u2603 + i * 128] = \u2603;
                mapData.func_176053_a(\u2603, i);
                \u26033 = true;
            }
        }
    }

    private BlockState func_211698_a(World world, BlockState blockState, BlockPos blockPos) {
        FluidState fluidState = blockState.func_204520_s();
        if (!fluidState.func_206888_e() && !blockState.func_224755_d(world, blockPos, Direction.UP)) {
            return fluidState.func_206883_i();
        }
        return blockState;
    }

    private static boolean func_195954_a(Biome[] biomeArray, int n, int n2, int n3) {
        return biomeArray[n2 * n + n3 * n * 128 * n].func_185355_j() >= 0.0f;
    }

    public static void func_226642_a_(ServerWorld serverWorld, ItemStack itemStack) {
        int n;
        MapData mapData = FilledMapItem.func_195950_a(itemStack, serverWorld);
        if (mapData == null) {
            return;
        }
        if (serverWorld.func_234923_W_() != mapData.field_76200_c) {
            return;
        }
        int \u26032 = 1 << mapData.field_76197_d;
        int \u26033 = mapData.field_76201_a;
        int \u26034 = mapData.field_76199_b;
        Biome[] \u26035 = new Biome[128 * \u26032 * 128 * \u26032];
        for (n = 0; n < 128 * \u26032; ++n) {
            for (\u2603 = 0; \u2603 < 128 * \u26032; ++\u2603) {
                \u26035[n * 128 * \u26032 + \u2603] = serverWorld.func_226691_t_(new BlockPos((\u26033 / \u26032 - 64) * \u26032 + \u2603, 0, (\u26034 / \u26032 - 64) * \u26032 + n));
            }
        }
        for (n = 0; n < 128; ++n) {
            for (\u2603 = 0; \u2603 < 128; ++\u2603) {
                if (n <= 0 || \u2603 <= 0 || n >= 127 || \u2603 >= 127) continue;
                Biome biome = \u26035[n * \u26032 + \u2603 * \u26032 * 128 * \u26032];
                int \u26036 = 8;
                if (FilledMapItem.func_195954_a(\u26035, \u26032, n - 1, \u2603 - 1)) {
                    --\u26036;
                }
                if (FilledMapItem.func_195954_a(\u26035, \u26032, n - 1, \u2603 + 1)) {
                    --\u26036;
                }
                if (FilledMapItem.func_195954_a(\u26035, \u26032, n - 1, \u2603)) {
                    --\u26036;
                }
                if (FilledMapItem.func_195954_a(\u26035, \u26032, n + 1, \u2603 - 1)) {
                    --\u26036;
                }
                if (FilledMapItem.func_195954_a(\u26035, \u26032, n + 1, \u2603 + 1)) {
                    --\u26036;
                }
                if (FilledMapItem.func_195954_a(\u26035, \u26032, n + 1, \u2603)) {
                    --\u26036;
                }
                if (FilledMapItem.func_195954_a(\u26035, \u26032, n, \u2603 - 1)) {
                    --\u26036;
                }
                if (FilledMapItem.func_195954_a(\u26035, \u26032, n, \u2603 + 1)) {
                    --\u26036;
                }
                int \u26037 = 3;
                MaterialColor \u26038 = MaterialColor.field_151660_b;
                if (biome.func_185355_j() < 0.0f) {
                    \u26038 = MaterialColor.field_151676_q;
                    if (\u26036 > 7 && \u2603 % 2 == 0) {
                        \u26037 = (n + (int)(MathHelper.func_76126_a((float)\u2603 + 0.0f) * 7.0f)) / 8 % 5;
                        if (\u26037 == 3) {
                            \u26037 = 1;
                        } else if (\u26037 == 4) {
                            \u26037 = 0;
                        }
                    } else if (\u26036 > 7) {
                        \u26038 = MaterialColor.field_151660_b;
                    } else if (\u26036 > 5) {
                        \u26037 = 1;
                    } else if (\u26036 > 3) {
                        \u26037 = 0;
                    } else if (\u26036 > 1) {
                        \u26037 = 0;
                    }
                } else if (\u26036 > 0) {
                    \u26038 = MaterialColor.field_151650_B;
                    \u26037 = \u26036 > 3 ? 1 : 3;
                }
                if (\u26038 == MaterialColor.field_151660_b) continue;
                mapData.field_76198_e[n + \u2603 * 128] = (byte)(\u26038.field_76290_q * 4 + \u26037);
                mapData.func_176053_a(n, \u2603);
            }
        }
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int n, boolean bl) {
        if (world.field_72995_K) {
            return;
        }
        MapData mapData = FilledMapItem.func_195950_a(itemStack, world);
        if (mapData == null) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)entity;
            mapData.func_76191_a(playerEntity, itemStack);
        }
        if (!mapData.field_215161_h && (bl || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184592_cb() == itemStack)) {
            this.func_77872_a(world, entity, mapData);
        }
    }

    @Override
    @Nullable
    public IPacket<?> func_150911_c(ItemStack itemStack, World world, PlayerEntity playerEntity) {
        return FilledMapItem.func_195950_a(itemStack, world).func_176052_a(itemStack, world, playerEntity);
    }

    @Override
    public void func_77622_d(ItemStack itemStack, World world, PlayerEntity playerEntity) {
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        if (compoundNBT != null && compoundNBT.func_150297_b("map_scale_direction", 99)) {
            FilledMapItem.func_185063_a(itemStack, world, compoundNBT.func_74762_e("map_scale_direction"));
            compoundNBT.func_82580_o("map_scale_direction");
        }
    }

    protected static void func_185063_a(ItemStack itemStack, World world, int n) {
        MapData mapData = FilledMapItem.func_195950_a(itemStack, world);
        if (mapData != null) {
            FilledMapItem.func_195951_a(itemStack, world, mapData.field_76201_a, mapData.field_76199_b, MathHelper.func_76125_a(mapData.field_76197_d + n, 0, 4), mapData.field_186210_e, mapData.field_191096_f, mapData.field_76200_c);
        }
    }

    @Nullable
    public static ItemStack func_219992_b(World world, ItemStack itemStack) {
        MapData mapData = FilledMapItem.func_195950_a(itemStack, world);
        if (mapData != null) {
            ItemStack itemStack2 = itemStack.func_77946_l();
            MapData \u26032 = FilledMapItem.func_195951_a(itemStack2, world, 0, 0, mapData.field_76197_d, mapData.field_186210_e, mapData.field_191096_f, mapData.field_76200_c);
            \u26032.func_215160_a(mapData);
            return itemStack2;
        }
        return null;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag iTooltipFlag) {
        MapData mapData = \u2603 = world == null ? null : FilledMapItem.func_195950_a(itemStack, world);
        if (\u2603 != null && \u2603.field_215161_h) {
            list.add(new TranslationTextComponent("filled_map.locked", FilledMapItem.func_195949_f(itemStack)).func_240699_a_(TextFormatting.GRAY));
        }
        if (iTooltipFlag.func_194127_a()) {
            if (\u2603 != null) {
                list.add(new TranslationTextComponent("filled_map.id", FilledMapItem.func_195949_f(itemStack)).func_240699_a_(TextFormatting.GRAY));
                list.add(new TranslationTextComponent("filled_map.scale", 1 << \u2603.field_76197_d).func_240699_a_(TextFormatting.GRAY));
                list.add(new TranslationTextComponent("filled_map.level", \u2603.field_76197_d, 4).func_240699_a_(TextFormatting.GRAY));
            } else {
                list.add(new TranslationTextComponent("filled_map.unknown").func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    public static int func_190907_h(ItemStack itemStack) {
        CompoundNBT compoundNBT = itemStack.func_179543_a("display");
        if (compoundNBT != null && compoundNBT.func_150297_b("MapColor", 99)) {
            int n = compoundNBT.func_74762_e("MapColor");
            return 0xFF000000 | n & 0xFFFFFF;
        }
        return -12173266;
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext itemUseContext2) {
        ItemUseContext itemUseContext2;
        BlockState blockState = itemUseContext2.func_195991_k().func_180495_p(itemUseContext2.func_195995_a());
        if (blockState.func_235714_a_(BlockTags.field_202897_p)) {
            if (!itemUseContext2.field_196006_g.field_72995_K) {
                MapData mapData = FilledMapItem.func_195950_a(itemUseContext2.func_195996_i(), itemUseContext2.func_195991_k());
                mapData.func_204269_a(itemUseContext2.func_195991_k(), itemUseContext2.func_195995_a());
            }
            return ActionResultType.func_233537_a_(itemUseContext2.field_196006_g.field_72995_K);
        }
        return super.func_195939_a(itemUseContext2);
    }
}

