/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.horse;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.CoatColors;
import net.minecraft.entity.passive.horse.CoatTypes;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class HorseEntity
extends AbstractHorseEntity {
    private static final UUID field_184786_bD = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataParameter<Integer> field_184789_bG = EntityDataManager.func_187226_a(HorseEntity.class, DataSerializers.field_187192_b);

    public HorseEntity(EntityType<? extends HorseEntity> entityType, World world) {
        super((EntityType<? extends AbstractHorseEntity>)entityType, world);
    }

    @Override
    protected void func_230273_eI_() {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.func_110267_cL());
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.func_110203_cN());
        this.func_110148_a(Attributes.field_233830_m_).func_111128_a(this.func_110245_cM());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184789_bG, 0);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("Variant", this.func_234241_eS_());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compoundNBT.func_218657_a("ArmorItem", this.field_110296_bG.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
    }

    public ItemStack func_213803_dV() {
        return this.func_184582_a(EquipmentSlotType.CHEST);
    }

    private void func_213805_k(ItemStack itemStack) {
        this.func_184201_a(EquipmentSlotType.CHEST, itemStack);
        this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_234242_w_(compoundNBT.func_74762_e("Variant"));
        if (compoundNBT.func_150297_b("ArmorItem", 10) && !(\u2603 = ItemStack.func_199557_a(compoundNBT.func_74775_l("ArmorItem"))).func_190926_b() && this.func_190682_f(\u2603)) {
            this.field_110296_bG.func_70299_a(1, \u2603);
        }
        this.func_230275_fc_();
    }

    private void func_234242_w_(int n) {
        this.field_70180_af.func_187227_b(field_184789_bG, n);
    }

    private int func_234241_eS_() {
        return this.field_70180_af.func_187225_a(field_184789_bG);
    }

    private void func_234238_a_(CoatColors coatColors, CoatTypes coatTypes) {
        this.func_234242_w_(coatColors.func_234253_a_() & 0xFF | coatTypes.func_234247_a_() << 8 & 0xFF00);
    }

    public CoatColors func_234239_eK_() {
        return CoatColors.func_234254_a_(this.func_234241_eS_() & 0xFF);
    }

    public CoatTypes func_234240_eM_() {
        return CoatTypes.func_234248_a_((this.func_234241_eS_() & 0xFF00) >> 8);
    }

    @Override
    protected void func_230275_fc_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        super.func_230275_fc_();
        this.func_213804_l(this.field_110296_bG.func_70301_a(1));
        this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
    }

    private void func_213804_l(ItemStack itemStack) {
        this.func_213805_k(itemStack);
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(Attributes.field_233826_i_).func_188479_b(field_184786_bD);
            if (this.func_190682_f(itemStack) && (\u2603 = ((HorseArmorItem)itemStack.func_77973_b()).func_219977_e()) != 0) {
                this.func_110148_a(Attributes.field_233826_i_).func_233767_b_(new AttributeModifier(field_184786_bD, "Horse armor bonus", (double)\u2603, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @Override
    public void func_76316_a(IInventory iInventory) {
        ItemStack itemStack = this.func_213803_dV();
        super.func_76316_a(iInventory);
        \u2603 = this.func_213803_dV();
        if (this.field_70173_aa > 20 && this.func_190682_f(\u2603) && itemStack != \u2603) {
            this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
        }
    }

    @Override
    protected void func_190680_a(SoundType soundType) {
        super.func_190680_a(soundType);
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_184185_a(SoundEvents.field_187705_cn, soundType.func_185843_a() * 0.6f, soundType.func_185847_b());
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187696_ck;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187708_co;
    }

    @Override
    @Nullable
    protected SoundEvent func_230274_fe_() {
        return SoundEvents.field_187711_cp;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        super.func_184601_bQ(damageSource);
        return SoundEvents.field_187717_cr;
    }

    @Override
    protected SoundEvent func_184785_dv() {
        super.func_184785_dv();
        return SoundEvents.field_187699_cl;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity playerEntity2, Hand hand) {
        PlayerEntity playerEntity2;
        ItemStack itemStack = playerEntity2.func_184586_b(hand);
        if (!this.func_70631_g_()) {
            if (this.func_110248_bS() && playerEntity2.func_226563_dT_()) {
                this.func_110199_f(playerEntity2);
                return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
            }
            if (this.func_184207_aI()) {
                return super.func_230254_b_(playerEntity2, hand);
            }
        }
        if (!itemStack.func_190926_b()) {
            if (this.func_70877_b(itemStack)) {
                return this.func_241395_b_(playerEntity2, itemStack);
            }
            ActionResultType actionResultType = itemStack.func_111282_a_(playerEntity2, this, hand);
            if (actionResultType.func_226246_a_()) {
                return actionResultType;
            }
            if (!this.func_110248_bS()) {
                this.func_190687_dF();
                return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
            }
            boolean bl = \u2603 = !this.func_70631_g_() && !this.func_110257_ck() && itemStack.func_77973_b() == Items.field_151141_av;
            if (this.func_190682_f(itemStack) || \u2603) {
                this.func_110199_f(playerEntity2);
                return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
            }
        }
        if (this.func_70631_g_()) {
            return super.func_230254_b_(playerEntity2, hand);
        }
        this.func_110237_h(playerEntity2);
        return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
    }

    @Override
    public boolean func_70878_b(AnimalEntity animalEntity) {
        if (animalEntity == this) {
            return false;
        }
        if (animalEntity instanceof DonkeyEntity || animalEntity instanceof HorseEntity) {
            return this.func_110200_cJ() && ((AbstractHorseEntity)animalEntity).func_110200_cJ();
        }
        return false;
    }

    @Override
    public AgeableEntity func_90011_a(AgeableEntity ageableEntity2) {
        AbstractHorseEntity \u26033;
        if (ageableEntity2 instanceof DonkeyEntity) {
            \u26033 = EntityType.field_200779_S.func_200721_a(this.field_70170_p);
        } else {
            AgeableEntity ageableEntity2;
            HorseEntity \u26032 = (HorseEntity)ageableEntity2;
            \u26033 = EntityType.field_200762_B.func_200721_a(this.field_70170_p);
            int \u26034 = this.field_70146_Z.nextInt(9);
            CoatColors \u26035 = \u26034 < 4 ? this.func_234239_eK_() : (\u26034 < 8 ? \u26032.func_234239_eK_() : Util.func_240989_a_(CoatColors.values(), this.field_70146_Z));
            int \u26036 = this.field_70146_Z.nextInt(5);
            CoatTypes \u26037 = \u26036 < 2 ? this.func_234240_eM_() : (\u26036 < 4 ? \u26032.func_234240_eM_() : Util.func_240989_a_(CoatTypes.values(), this.field_70146_Z));
            ((HorseEntity)\u26033).func_234238_a_(\u26035, \u26037);
        }
        this.func_190681_a(ageableEntity2, \u26033);
        return \u26033;
    }

    @Override
    public boolean func_230276_fq_() {
        return true;
    }

    @Override
    public boolean func_190682_f(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof HorseArmorItem;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData \u260322, @Nullable CompoundNBT compoundNBT) {
        ILivingEntityData \u260322;
        CoatColors coatColors;
        if (\u260322 instanceof HorseData) {
            coatColors = ((HorseData)\u260322).field_190885_a;
        } else {
            coatColors = Util.func_240989_a_(CoatColors.values(), this.field_70146_Z);
            \u260322 = new HorseData(coatColors);
        }
        this.func_234238_a_(coatColors, Util.func_240989_a_(CoatTypes.values(), this.field_70146_Z));
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, \u260322, compoundNBT);
    }

    public static class HorseData
    extends AgeableEntity.AgeableData {
        public final CoatColors field_190885_a;

        public HorseData(CoatColors coatColors) {
            this.field_190885_a = coatColors;
        }
    }
}

