/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.horse;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class AbstractHorseEntity
extends AnimalEntity
implements IInventoryChangedListener,
IJumpingMount,
IEquipable {
    private static final Predicate<LivingEntity> field_110276_bu = livingEntity -> livingEntity instanceof AbstractHorseEntity && ((AbstractHorseEntity)livingEntity).func_110205_ce();
    private static final EntityPredicate field_213618_bK = new EntityPredicate().func_221013_a(16.0).func_221008_a().func_221011_b().func_221014_c().func_221012_a(field_110276_bu);
    private static final Ingredient field_234235_bE_ = Ingredient.func_199804_a(Items.field_151015_O, Items.field_151102_aT, Blocks.field_150407_cf.func_199767_j(), Items.field_151034_e, Items.field_151150_bK, Items.field_151153_ao, Items.field_196100_at);
    private static final DataParameter<Byte> field_184787_bE = EntityDataManager.func_187226_a(AbstractHorseEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Optional<UUID>> field_184790_bH = EntityDataManager.func_187226_a(AbstractHorseEntity.class, DataSerializers.field_187203_m);
    private int field_190689_bJ;
    private int field_110290_bE;
    private int field_110295_bF;
    public int field_110278_bp;
    public int field_110279_bq;
    protected boolean field_110275_br;
    protected Inventory field_110296_bG;
    protected int field_110274_bs;
    protected float field_110277_bt;
    private boolean field_110294_bI;
    private float field_110283_bJ;
    private float field_110284_bK;
    private float field_110281_bL;
    private float field_110282_bM;
    private float field_110287_bN;
    private float field_110288_bO;
    protected boolean field_190688_bE = true;
    protected int field_110285_bP;

    protected AbstractHorseEntity(EntityType<? extends AbstractHorseEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
        this.field_70138_W = 1.0f;
        this.func_110226_cD();
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new PanicGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(1, new RunAroundLikeCrazyGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(2, new BreedGoal(this, 1.0, AbstractHorseEntity.class));
        this.field_70714_bg.func_75776_a(4, new FollowParentGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new WaterAvoidingRandomWalkingGoal(this, 0.7));
        this.field_70714_bg.func_75776_a(7, new LookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
        this.func_205714_dM();
    }

    protected void func_205714_dM() {
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184787_bE, (byte)0);
        this.field_70180_af.func_187214_a(field_184790_bH, Optional.empty());
    }

    protected boolean func_110233_w(int n) {
        return (this.field_70180_af.func_187225_a(field_184787_bE) & n) != 0;
    }

    protected void func_110208_b(int n, boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184787_bE);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184787_bE, (byte)(by | n));
        } else {
            this.field_70180_af.func_187227_b(field_184787_bE, (byte)(by & ~n));
        }
    }

    public boolean func_110248_bS() {
        return this.func_110233_w(2);
    }

    @Nullable
    public UUID func_184780_dh() {
        return this.field_70180_af.func_187225_a(field_184790_bH).orElse(null);
    }

    public void func_184779_b(@Nullable UUID uUID) {
        this.field_70180_af.func_187227_b(field_184790_bH, Optional.ofNullable(uUID));
    }

    public boolean func_110246_bZ() {
        return this.field_110275_br;
    }

    public void func_110234_j(boolean bl) {
        this.func_110208_b(2, bl);
    }

    public void func_110255_k(boolean bl) {
        this.field_110275_br = bl;
    }

    @Override
    protected void func_142017_o(float f) {
        if (f > 6.0f && this.func_110204_cc()) {
            this.func_110227_p(false);
        }
    }

    public boolean func_110204_cc() {
        return this.func_110233_w(16);
    }

    public boolean func_110209_cd() {
        return this.func_110233_w(32);
    }

    public boolean func_110205_ce() {
        return this.func_110233_w(8);
    }

    public void func_110242_l(boolean bl) {
        this.func_110208_b(8, bl);
    }

    @Override
    public boolean func_230264_L__() {
        return this.func_70089_S() && !this.func_70631_g_() && this.func_110248_bS();
    }

    @Override
    public void func_230266_a_(@Nullable SoundCategory soundCategory) {
        this.field_110296_bG.func_70299_a(0, new ItemStack(Items.field_151141_av));
        if (soundCategory != null) {
            this.field_70170_p.func_217384_a(null, this, SoundEvents.field_187726_cu, soundCategory, 0.5f, 1.0f);
        }
    }

    @Override
    public boolean func_110257_ck() {
        return this.func_110233_w(4);
    }

    public int func_110252_cg() {
        return this.field_110274_bs;
    }

    public void func_110238_s(int n) {
        this.field_110274_bs = n;
    }

    public int func_110198_t(int n) {
        \u2603 = MathHelper.func_76125_a(this.func_110252_cg() + n, 0, this.func_190676_dC());
        this.func_110238_s(\u2603);
        return \u2603;
    }

    @Override
    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    private void func_110266_cB() {
        SoundEvent soundEvent;
        this.func_110249_cI();
        if (!this.func_174814_R() && (soundEvent = this.func_230274_fe_()) != null) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundEvent, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
    }

    @Override
    public boolean func_225503_b_(float f, float f2) {
        if (f > 1.0f) {
            this.func_184185_a(SoundEvents.field_187723_ct, 0.4f, 1.0f);
        }
        if ((\u2603 = this.func_225508_e_(f, f2)) <= 0) {
            return false;
        }
        this.func_70097_a(DamageSource.field_76379_h, \u2603);
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184182_bu()) {
                entity.func_70097_a(DamageSource.field_76379_h, \u2603);
            }
        }
        this.func_226295_cZ_();
        return true;
    }

    @Override
    protected int func_225508_e_(float f, float f2) {
        return MathHelper.func_76123_f((f * 0.5f - 3.0f) * f2);
    }

    protected int func_190686_di() {
        return 2;
    }

    protected void func_110226_cD() {
        Inventory inventory = this.field_110296_bG;
        this.field_110296_bG = new Inventory(this.func_190686_di());
        if (inventory != null) {
            inventory.func_110132_b(this);
            int n = Math.min(inventory.func_70302_i_(), this.field_110296_bG.func_70302_i_());
            for (\u2603 = 0; \u2603 < n; ++\u2603) {
                ItemStack itemStack = inventory.func_70301_a(\u2603);
                if (itemStack.func_190926_b()) continue;
                this.field_110296_bG.func_70299_a(\u2603, itemStack.func_77946_l());
            }
        }
        this.field_110296_bG.func_110134_a(this);
        this.func_230275_fc_();
    }

    protected void func_230275_fc_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.func_110208_b(4, !this.field_110296_bG.func_70301_a(0).func_190926_b());
    }

    @Override
    public void func_76316_a(IInventory iInventory) {
        boolean bl = this.func_110257_ck();
        this.func_230275_fc_();
        if (this.field_70173_aa > 20 && !bl && this.func_110257_ck()) {
            this.func_184185_a(SoundEvents.field_187726_cu, 0.5f, 1.0f);
        }
    }

    public double func_110215_cj() {
        return this.func_233637_b_(Attributes.field_233830_m_);
    }

    @Nullable
    protected SoundEvent func_230274_fe_() {
        return null;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.func_110220_cK();
        }
        return null;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.func_110220_cK();
        }
        return null;
    }

    @Nullable
    protected SoundEvent func_184785_dv() {
        this.func_110220_cK();
        return null;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        if (blockState.func_185904_a().func_76224_d()) {
            return;
        }
        \u2603 = this.field_70170_p.func_180495_p(blockPos.func_177984_a());
        SoundType soundType = blockState.func_215695_r();
        if (\u2603.func_203425_a(Blocks.field_150433_aE)) {
            soundType = \u2603.func_215695_r();
        }
        if (this.func_184207_aI() && this.field_190688_bE) {
            ++this.field_110285_bP;
            if (this.field_110285_bP > 5 && this.field_110285_bP % 3 == 0) {
                this.func_190680_a(soundType);
            } else if (this.field_110285_bP <= 5) {
                this.func_184185_a(SoundEvents.field_187732_cw, soundType.func_185843_a() * 0.15f, soundType.func_185847_b());
            }
        } else if (soundType == SoundType.field_185848_a) {
            this.func_184185_a(SoundEvents.field_187732_cw, soundType.func_185843_a() * 0.15f, soundType.func_185847_b());
        } else {
            this.func_184185_a(SoundEvents.field_187729_cv, soundType.func_185843_a() * 0.15f, soundType.func_185847_b());
        }
    }

    protected void func_190680_a(SoundType soundType) {
        this.func_184185_a(SoundEvents.field_187714_cq, soundType.func_185843_a() * 0.15f, soundType.func_185847_b());
    }

    public static AttributeModifierMap.MutableAttribute func_234237_fg_() {
        return MobEntity.func_233666_p_().func_233814_a_(Attributes.field_233830_m_).func_233815_a_(Attributes.field_233818_a_, 53.0).func_233815_a_(Attributes.field_233821_d_, 0.225f);
    }

    @Override
    public int func_70641_bl() {
        return 6;
    }

    public int func_190676_dC() {
        return 100;
    }

    @Override
    protected float func_70599_aP() {
        return 0.8f;
    }

    @Override
    public int func_70627_aG() {
        return 400;
    }

    public void func_110199_f(PlayerEntity playerEntity) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w(playerEntity)) && this.func_110248_bS()) {
            playerEntity.func_184826_a(this, this.field_110296_bG);
        }
    }

    public ActionResultType func_241395_b_(PlayerEntity playerEntity, ItemStack itemStack) {
        boolean bl = this.func_190678_b(playerEntity, itemStack);
        if (!playerEntity.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        if (this.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        return bl ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    protected boolean func_190678_b(PlayerEntity playerEntity, ItemStack itemStack) {
        boolean bl = false;
        float \u26032 = 0.0f;
        int \u26033 = 0;
        int \u26034 = 0;
        Item \u26035 = itemStack.func_77973_b();
        if (\u26035 == Items.field_151015_O) {
            \u26032 = 2.0f;
            \u26033 = 20;
            \u26034 = 3;
        } else if (\u26035 == Items.field_151102_aT) {
            \u26032 = 1.0f;
            \u26033 = 30;
            \u26034 = 3;
        } else if (\u26035 == Blocks.field_150407_cf.func_199767_j()) {
            \u26032 = 20.0f;
            \u26033 = 180;
        } else if (\u26035 == Items.field_151034_e) {
            \u26032 = 3.0f;
            \u26033 = 60;
            \u26034 = 3;
        } else if (\u26035 == Items.field_151150_bK) {
            \u26032 = 4.0f;
            \u26033 = 60;
            \u26034 = 5;
            if (!this.field_70170_p.field_72995_K && this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                bl = true;
                this.func_146082_f(playerEntity);
            }
        } else if (\u26035 == Items.field_151153_ao || \u26035 == Items.field_196100_at) {
            \u26032 = 10.0f;
            \u26033 = 240;
            \u26034 = 10;
            if (!this.field_70170_p.field_72995_K && this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                bl = true;
                this.func_146082_f(playerEntity);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && \u26032 > 0.0f) {
            this.func_70691_i(\u26032);
            bl = true;
        }
        if (this.func_70631_g_() && \u26033 > 0) {
            this.field_70170_p.func_195594_a(ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(\u26033);
            }
            bl = true;
        }
        if (\u26034 > 0 && (bl || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            bl = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(\u26034);
            }
        }
        if (bl) {
            this.func_110266_cB();
        }
        return bl;
    }

    protected void func_110237_h(PlayerEntity playerEntity) {
        this.func_110227_p(false);
        this.func_110219_q(false);
        if (!this.field_70170_p.field_72995_K) {
            playerEntity.field_70177_z = this.field_70177_z;
            playerEntity.field_70125_A = this.field_70125_A;
            playerEntity.func_184220_m(this);
        }
    }

    @Override
    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.func_110257_ck() || this.func_110204_cc() || this.func_110209_cd();
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return field_234235_bE_.test(itemStack);
    }

    private void func_110210_cH() {
        this.field_110278_bp = 1;
    }

    @Override
    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.field_110296_bG == null) {
            return;
        }
        for (int i = 0; i < this.field_110296_bG.func_70302_i_(); ++i) {
            ItemStack itemStack = this.field_110296_bG.func_70301_a(i);
            if (itemStack.func_190926_b() || EnchantmentHelper.func_190939_c(itemStack)) continue;
            this.func_199701_a_(itemStack);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.func_110210_cH();
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K || !this.func_70089_S()) {
            return;
        }
        if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.func_190684_dE()) {
            if (!this.func_110204_cc() && !this.func_184207_aI() && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_203425_a(Blocks.field_196658_i)) {
                this.func_110227_p(true);
            }
            if (this.func_110204_cc() && ++this.field_190689_bJ > 50) {
                this.field_190689_bJ = 0;
                this.func_110227_p(false);
            }
        }
        this.func_190679_dD();
    }

    protected void func_190679_dD() {
        AbstractHorseEntity abstractHorseEntity;
        if (this.func_110205_ce() && this.func_70631_g_() && !this.func_110204_cc() && (abstractHorseEntity = this.field_70170_p.func_217360_a(AbstractHorseEntity.class, field_213618_bK, this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_174813_aQ().func_186662_g(16.0))) != null && this.func_70068_e(abstractHorseEntity) > 4.0) {
            this.field_70699_by.func_75494_a(abstractHorseEntity, 0);
        }
    }

    public boolean func_190684_dE() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_110290_bE > 0 && ++this.field_110290_bE > 30) {
            this.field_110290_bE = 0;
            this.func_110208_b(64, false);
        }
        if ((this.func_184186_bw() || this.func_70613_aW()) && this.field_110295_bF > 0 && ++this.field_110295_bF > 20) {
            this.field_110295_bF = 0;
            this.func_110219_q(false);
        }
        if (this.field_110278_bp > 0 && ++this.field_110278_bp > 8) {
            this.field_110278_bp = 0;
        }
        if (this.field_110279_bq > 0) {
            ++this.field_110279_bq;
            if (this.field_110279_bq > 300) {
                this.field_110279_bq = 0;
            }
        }
        this.field_110284_bK = this.field_110283_bJ;
        if (this.func_110204_cc()) {
            this.field_110283_bJ += (1.0f - this.field_110283_bJ) * 0.4f + 0.05f;
            if (this.field_110283_bJ > 1.0f) {
                this.field_110283_bJ = 1.0f;
            }
        } else {
            this.field_110283_bJ += (0.0f - this.field_110283_bJ) * 0.4f - 0.05f;
            if (this.field_110283_bJ < 0.0f) {
                this.field_110283_bJ = 0.0f;
            }
        }
        this.field_110282_bM = this.field_110281_bL;
        if (this.func_110209_cd()) {
            this.field_110284_bK = this.field_110283_bJ = 0.0f;
            this.field_110281_bL += (1.0f - this.field_110281_bL) * 0.4f + 0.05f;
            if (this.field_110281_bL > 1.0f) {
                this.field_110281_bL = 1.0f;
            }
        } else {
            this.field_110294_bI = false;
            this.field_110281_bL += (0.8f * this.field_110281_bL * this.field_110281_bL * this.field_110281_bL - this.field_110281_bL) * 0.6f - 0.05f;
            if (this.field_110281_bL < 0.0f) {
                this.field_110281_bL = 0.0f;
            }
        }
        this.field_110288_bO = this.field_110287_bN;
        if (this.func_110233_w(64)) {
            this.field_110287_bN += (1.0f - this.field_110287_bN) * 0.7f + 0.05f;
            if (this.field_110287_bN > 1.0f) {
                this.field_110287_bN = 1.0f;
            }
        } else {
            this.field_110287_bN += (0.0f - this.field_110287_bN) * 0.7f - 0.05f;
            if (this.field_110287_bN < 0.0f) {
                this.field_110287_bN = 0.0f;
            }
        }
    }

    private void func_110249_cI() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_110290_bE = 1;
            this.func_110208_b(64, true);
        }
    }

    public void func_110227_p(boolean bl) {
        this.func_110208_b(16, bl);
    }

    public void func_110219_q(boolean bl) {
        if (bl) {
            this.func_110227_p(false);
        }
        this.func_110208_b(32, bl);
    }

    private void func_110220_cK() {
        if (this.func_184186_bw() || this.func_70613_aW()) {
            this.field_110295_bF = 1;
            this.func_110219_q(true);
        }
    }

    public void func_190687_dF() {
        if (!this.func_110209_cd()) {
            this.func_110220_cK();
            SoundEvent soundEvent = this.func_184785_dv();
            if (soundEvent != null) {
                this.func_184185_a(soundEvent, this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    public boolean func_110263_g(PlayerEntity playerEntity) {
        this.func_184779_b(playerEntity.func_110124_au());
        this.func_110234_j(true);
        if (playerEntity instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193136_w.func_193178_a((ServerPlayerEntity)playerEntity, this);
        }
        this.field_70170_p.func_72960_a(this, (byte)7);
        return true;
    }

    @Override
    public void func_213352_e(Vector3d vector3d2) {
        if (!this.func_70089_S()) {
            return;
        }
        if (!(this.func_184207_aI() && this.func_82171_bF() && this.func_110257_ck())) {
            this.field_70747_aH = 0.02f;
            super.func_213352_e(vector3d2);
            return;
        }
        LivingEntity livingEntity = (LivingEntity)this.func_184179_bs();
        this.field_70126_B = this.field_70177_z = livingEntity.field_70177_z;
        this.field_70125_A = livingEntity.field_70125_A * 0.5f;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70759_as = this.field_70761_aq = this.field_70177_z;
        float \u26032 = livingEntity.field_70702_br * 0.5f;
        float \u26033 = livingEntity.field_191988_bg;
        if (\u26033 <= 0.0f) {
            \u26033 *= 0.25f;
            this.field_110285_bP = 0;
        }
        if (this.field_70122_E && this.field_110277_bt == 0.0f && this.func_110209_cd() && !this.field_110294_bI) {
            \u26032 = 0.0f;
            \u26033 = 0.0f;
        }
        if (this.field_110277_bt > 0.0f && !this.func_110246_bZ() && this.field_70122_E) {
            double d = this.func_110215_cj() * (double)this.field_110277_bt * (double)this.func_226269_ah_();
            \u2603 = this.func_70644_a(Effects.field_76430_j) ? d + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : d;
            Vector3d \u26034 = this.func_213322_ci();
            this.func_213293_j(\u26034.field_72450_a, \u2603, \u26034.field_72449_c);
            this.func_110255_k(true);
            this.field_70160_al = true;
            if (\u26033 > 0.0f) {
                float f = MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180));
                \u2603 = MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180));
                this.func_213317_d(this.func_213322_ci().func_72441_c(-0.4f * f * this.field_110277_bt, 0.0, 0.4f * \u2603 * this.field_110277_bt));
            }
            this.field_110277_bt = 0.0f;
        }
        this.field_70747_aH = this.func_70689_ay() * 0.1f;
        if (this.func_184186_bw()) {
            Vector3d vector3d2;
            this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_));
            super.func_213352_e(new Vector3d(\u26032, vector3d2.field_72448_b, \u26033));
        } else if (livingEntity instanceof PlayerEntity) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        if (this.field_70122_E) {
            this.field_110277_bt = 0.0f;
            this.func_110255_k(false);
        }
        this.func_233629_a_(this, false);
    }

    protected void func_205715_ee() {
        this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74757_a("EatingHaystack", this.func_110204_cc());
        compoundNBT.func_74757_a("Bred", this.func_110205_ce());
        compoundNBT.func_74768_a("Temper", this.func_110252_cg());
        compoundNBT.func_74757_a("Tame", this.func_110248_bS());
        if (this.func_184780_dh() != null) {
            compoundNBT.func_186854_a("Owner", this.func_184780_dh());
        }
        if (!this.field_110296_bG.func_70301_a(0).func_190926_b()) {
            compoundNBT.func_218657_a("SaddleItem", this.field_110296_bG.func_70301_a(0).func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT2) {
        Object \u26032;
        UUID \u26033;
        super.func_70037_a(compoundNBT2);
        this.func_110227_p(compoundNBT2.func_74767_n("EatingHaystack"));
        this.func_110242_l(compoundNBT2.func_74767_n("Bred"));
        this.func_110238_s(compoundNBT2.func_74762_e("Temper"));
        this.func_110234_j(compoundNBT2.func_74767_n("Tame"));
        if (compoundNBT2.func_186855_b("Owner")) {
            \u26033 = compoundNBT2.func_186857_a("Owner");
        } else {
            CompoundNBT compoundNBT2;
            \u26032 = compoundNBT2.func_74779_i("Owner");
            \u26033 = PreYggdrasilConverter.func_187473_a(this.func_184102_h(), (String)\u26032);
        }
        if (\u26033 != null) {
            this.func_184779_b(\u26033);
        }
        if (compoundNBT2.func_150297_b("SaddleItem", 10) && ((ItemStack)(\u26032 = ItemStack.func_199557_a(compoundNBT2.func_74775_l("SaddleItem")))).func_77973_b() == Items.field_151141_av) {
            this.field_110296_bG.func_70299_a(0, (ItemStack)\u26032);
        }
        this.func_230275_fc_();
    }

    @Override
    public boolean func_70878_b(AnimalEntity animalEntity) {
        return false;
    }

    protected boolean func_110200_cJ() {
        return !this.func_184207_aI() && !this.func_184218_aH() && this.func_110248_bS() && !this.func_70631_g_() && this.func_110143_aJ() >= this.func_110138_aP() && this.func_70880_s();
    }

    @Override
    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return null;
    }

    protected void func_190681_a(AgeableEntity ageableEntity, AbstractHorseEntity abstractHorseEntity) {
        double d = this.func_233638_c_(Attributes.field_233818_a_) + ageableEntity.func_233638_c_(Attributes.field_233818_a_) + (double)this.func_110267_cL();
        abstractHorseEntity.func_110148_a(Attributes.field_233818_a_).func_111128_a(d / 3.0);
        \u2603 = this.func_233638_c_(Attributes.field_233830_m_) + ageableEntity.func_233638_c_(Attributes.field_233830_m_) + this.func_110245_cM();
        abstractHorseEntity.func_110148_a(Attributes.field_233830_m_).func_111128_a(\u2603 / 3.0);
        \u2603 = this.func_233638_c_(Attributes.field_233821_d_) + ageableEntity.func_233638_c_(Attributes.field_233821_d_) + this.func_110203_cN();
        abstractHorseEntity.func_110148_a(Attributes.field_233821_d_).func_111128_a(\u2603 / 3.0);
    }

    @Override
    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public float func_110258_o(float f) {
        return MathHelper.func_219799_g(f, this.field_110284_bK, this.field_110283_bJ);
    }

    public float func_110223_p(float f) {
        return MathHelper.func_219799_g(f, this.field_110282_bM, this.field_110281_bL);
    }

    public float func_110201_q(float f) {
        return MathHelper.func_219799_g(f, this.field_110288_bO, this.field_110287_bN);
    }

    @Override
    public void func_110206_u(int n) {
        if (!this.func_110257_ck()) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else {
            this.field_110294_bI = true;
            this.func_110220_cK();
        }
        this.field_110277_bt = n >= 90 ? 1.0f : 0.4f + 0.4f * (float)n / 90.0f;
    }

    @Override
    public boolean func_184776_b() {
        return this.func_110257_ck();
    }

    @Override
    public void func_184775_b(int n) {
        this.field_110294_bI = true;
        this.func_110220_cK();
        this.func_205715_ee();
    }

    @Override
    public void func_184777_r_() {
    }

    protected void func_110216_r(boolean bl) {
        BasicParticleType basicParticleType = bl ? ParticleTypes.field_197633_z : ParticleTypes.field_197601_L;
        for (int i = 0; i < 7; ++i) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            \u2603 = this.field_70146_Z.nextGaussian() * 0.02;
            \u2603 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(basicParticleType, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d, \u2603, \u2603);
        }
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 7) {
            this.func_110216_r(true);
        } else if (by == 6) {
            this.func_110216_r(false);
        } else {
            super.func_70103_a(by);
        }
    }

    @Override
    public void func_184232_k(Entity entity) {
        super.func_184232_k(entity);
        if (entity instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)entity;
            this.field_70761_aq = mobEntity.field_70761_aq;
        }
        if (this.field_110282_bM > 0.0f) {
            float f = MathHelper.func_76126_a(this.field_70761_aq * ((float)Math.PI / 180));
            \u2603 = MathHelper.func_76134_b(this.field_70761_aq * ((float)Math.PI / 180));
            \u2603 = 0.7f * this.field_110282_bM;
            \u2603 = 0.15f * this.field_110282_bM;
            entity.func_70107_b(this.func_226277_ct_() + (double)(\u2603 * f), this.func_226278_cu_() + this.func_70042_X() + entity.func_70033_W() + (double)\u2603, this.func_226281_cx_() - (double)(\u2603 * \u2603));
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    protected float func_110267_cL() {
        return 15.0f + (float)this.field_70146_Z.nextInt(8) + (float)this.field_70146_Z.nextInt(9);
    }

    protected double func_110245_cM() {
        return (double)0.4f + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2;
    }

    protected double func_110203_cN() {
        return ((double)0.45f + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean func_70617_f_() {
        return false;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return entitySize.field_220316_b * 0.95f;
    }

    public boolean func_230276_fq_() {
        return false;
    }

    public boolean func_230277_fr_() {
        return !this.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
    }

    public boolean func_190682_f(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean func_174820_d(int n, ItemStack itemStack) {
        int n2 = n - 400;
        if (n2 >= 0 && n2 < 2 && n2 < this.field_110296_bG.func_70302_i_()) {
            if (n2 == 0 && itemStack.func_77973_b() != Items.field_151141_av) {
                return false;
            }
            if (!(n2 != 1 || this.func_230276_fq_() && this.func_190682_f(itemStack))) {
                return false;
            }
            this.field_110296_bG.func_70299_a(n2, itemStack);
            this.func_230275_fc_();
            return true;
        }
        \u2603 = n - 500 + 2;
        if (\u2603 >= 2 && \u2603 < this.field_110296_bG.func_70302_i_()) {
            this.field_110296_bG.func_70299_a(\u2603, itemStack);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        if (this.func_184188_bt().isEmpty()) {
            return null;
        }
        return this.func_184188_bt().get(0);
    }

    @Nullable
    private Vector3d func_234236_a_(Vector3d vector3d, LivingEntity livingEntity) {
        double d = this.func_226277_ct_() + vector3d.field_72450_a;
        \u2603 = this.func_174813_aQ().field_72338_b;
        \u2603 = this.func_226281_cx_() + vector3d.field_72449_c;
        BlockPos.Mutable \u26032 = new BlockPos.Mutable();
        block0: for (Pose pose : livingEntity.func_230297_ef_()) {
            \u26032.func_189532_c(d, \u2603, \u2603);
            double d2 = this.func_174813_aQ().field_72337_e + 0.75;
            do {
                \u2603 = this.field_70170_p.func_234936_m_(\u26032);
                if ((double)\u26032.func_177956_o() + \u2603 > d2) continue block0;
                if (TransportationHelper.func_234630_a_(\u2603) && TransportationHelper.func_234631_a_(this.field_70170_p, livingEntity, (\u2603 = livingEntity.func_233648_f_(pose)).func_191194_a(\u2603 = new Vector3d(d, (double)\u26032.func_177956_o() + \u2603, \u2603)))) {
                    livingEntity.func_213301_b(pose);
                    return \u2603;
                }
                \u26032.func_189536_c(Direction.UP);
            } while ((double)\u26032.func_177956_o() < d2);
        }
        return null;
    }

    @Override
    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        Vector3d vector3d = AbstractHorseEntity.func_233559_a_(this.func_213311_cf(), livingEntity.func_213311_cf(), this.field_70177_z + (livingEntity.func_184591_cq() == HandSide.RIGHT ? 90.0f : -90.0f));
        \u2603 = this.func_234236_a_(vector3d, livingEntity);
        if (\u2603 != null) {
            return \u2603;
        }
        \u2603 = AbstractHorseEntity.func_233559_a_(this.func_213311_cf(), livingEntity.func_213311_cf(), this.field_70177_z + (livingEntity.func_184591_cq() == HandSide.LEFT ? 90.0f : -90.0f));
        \u2603 = this.func_234236_a_(\u2603, livingEntity);
        if (\u2603 != null) {
            return \u2603;
        }
        return this.func_213303_ch();
    }

    protected void func_230273_eI_() {
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld2, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        IWorld iWorld2;
        if (iLivingEntityData2 == null) {
            ILivingEntityData iLivingEntityData2 = new AgeableEntity.AgeableData();
            ((AgeableEntity.AgeableData)iLivingEntityData2).func_226258_a_(0.2f);
        }
        this.func_230273_eI_();
        return super.func_213386_a(iWorld2, difficultyInstance, spawnReason, iLivingEntityData2, compoundNBT);
    }
}

