/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BegGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WolfEntity
extends TameableEntity
implements IAngerable {
    private static final DataParameter<Boolean> field_184760_bA = EntityDataManager.func_187226_a(WolfEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_184758_bB = EntityDataManager.func_187226_a(WolfEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_234232_bz_ = EntityDataManager.func_187226_a(WolfEntity.class, DataSerializers.field_187192_b);
    public static final Predicate<LivingEntity> field_213441_bD = livingEntity -> {
        EntityType<?> entityType = livingEntity.func_200600_R();
        return entityType == EntityType.field_200737_ac || entityType == EntityType.field_200736_ab || entityType == EntityType.field_220356_B;
    };
    private float field_70926_e;
    private float field_70924_f;
    private boolean field_70925_g;
    private boolean field_70928_h;
    private float field_70929_i;
    private float field_70927_j;
    private static final RangedInteger field_234230_bG_ = TickRangeConverter.func_233037_a_(20, 39);
    private UUID field_234231_bH_;

    public WolfEntity(EntityType<? extends WolfEntity> entityType, World world) {
        super((EntityType<? extends TameableEntity>)entityType, world);
        this.func_70903_f(false);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(2, new SitGoal(this));
        this.field_70714_bg.func_75776_a(3, new AvoidEntityGoal<LlamaEntity>(this, LlamaEntity.class, 24.0f, 1.5, 1.5));
        this.field_70714_bg.func_75776_a(4, new LeapAtTargetGoal(this, 0.4f));
        this.field_70714_bg.func_75776_a(5, new MeleeAttackGoal(this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(7, new BreedGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(8, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(9, new BegGoal(this, 8.0f));
        this.field_70714_bg.func_75776_a(10, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new OwnerHurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, new OwnerHurtTargetGoal(this));
        this.field_70715_bh.func_75776_a(3, new HurtByTargetGoal(this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, new NearestAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, 10, true, false, this::func_233680_b_));
        this.field_70715_bh.func_75776_a(5, new NonTamedTargetGoal<AnimalEntity>(this, AnimalEntity.class, false, field_213441_bD));
        this.field_70715_bh.func_75776_a(6, new NonTamedTargetGoal<TurtleEntity>(this, TurtleEntity.class, false, TurtleEntity.field_203029_bx));
        this.field_70715_bh.func_75776_a(7, new NearestAttackableTargetGoal<AbstractSkeletonEntity>((MobEntity)this, AbstractSkeletonEntity.class, false));
        this.field_70715_bh.func_75776_a(8, new ResetAngerGoal<WolfEntity>(this, true));
    }

    public static AttributeModifierMap.MutableAttribute func_234233_eS_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.3f).func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184760_bA, false);
        this.field_70180_af.func_187214_a(field_184758_bB, DyeColor.RED.func_196059_a());
        this.field_70180_af.func_187214_a(field_234232_bz_, 0);
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74774_a("CollarColor", (byte)this.func_175546_cu().func_196059_a());
        this.func_233682_c_(compoundNBT);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_150297_b("CollarColor", 99)) {
            this.func_175547_a(DyeColor.func_196056_a(compoundNBT.func_74762_e("CollarColor")));
        }
        this.func_241358_a_((ServerWorld)this.field_70170_p, compoundNBT);
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.func_233678_J__()) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            if (this.func_70909_n() && this.func_110143_aJ() < 10.0f) {
                return SoundEvents.field_187871_gL;
            }
            return SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187863_gH;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    @Override
    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70925_g && !this.field_70928_h && !this.func_70781_l() && this.field_70122_E) {
            this.field_70928_h = true;
            this.field_70929_i = 0.0f;
            this.field_70927_j = 0.0f;
            this.field_70170_p.func_72960_a(this, (byte)8);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_70089_S()) {
            return;
        }
        this.field_70924_f = this.field_70926_e;
        this.field_70926_e = this.func_70922_bv() ? (this.field_70926_e += (1.0f - this.field_70926_e) * 0.4f) : (this.field_70926_e += (0.0f - this.field_70926_e) * 0.4f);
        if (this.func_203008_ap()) {
            this.field_70925_g = true;
            this.field_70928_h = false;
            this.field_70929_i = 0.0f;
            this.field_70927_j = 0.0f;
        } else if ((this.field_70925_g || this.field_70928_h) && this.field_70928_h) {
            if (this.field_70929_i == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.field_70927_j = this.field_70929_i;
            this.field_70929_i += 0.05f;
            if (this.field_70927_j >= 2.0f) {
                this.field_70925_g = false;
                this.field_70928_h = false;
                this.field_70927_j = 0.0f;
                this.field_70929_i = 0.0f;
            }
            if (this.field_70929_i > 0.4f) {
                float f = (float)this.func_226278_cu_();
                int \u26032 = (int)(MathHelper.func_76126_a((this.field_70929_i - 0.4f) * (float)Math.PI) * 7.0f);
                Vector3d \u26033 = this.func_213322_ci();
                for (int i = 0; i < \u26032; ++i) {
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                    \u2603 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                    this.field_70170_p.func_195594_a(ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)f2, f + 0.8f, this.func_226281_cx_() + (double)\u2603, \u26033.field_72450_a, \u26033.field_72448_b, \u26033.field_72449_c);
                }
            }
        }
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        this.field_70925_g = false;
        this.field_70928_h = false;
        this.field_70927_j = 0.0f;
        this.field_70929_i = 0.0f;
        super.func_70645_a(damageSource);
    }

    public boolean func_70921_u() {
        return this.field_70925_g;
    }

    public float func_70915_j(float f) {
        return 0.75f + MathHelper.func_219799_g(f, this.field_70927_j, this.field_70929_i) / 2.0f * 0.25f;
    }

    public float func_70923_f(float f, float f2) {
        \u2603 = (MathHelper.func_219799_g(f, this.field_70927_j, this.field_70929_i) + f2) / 1.8f;
        if (\u2603 < 0.0f) {
            \u2603 = 0.0f;
        } else if (\u2603 > 1.0f) {
            \u2603 = 1.0f;
        }
        return MathHelper.func_76126_a(\u2603 * (float)Math.PI) * MathHelper.func_76126_a(\u2603 * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    public float func_70917_k(float f) {
        return MathHelper.func_219799_g(f, this.field_70924_f, this.field_70926_e) * 0.15f * (float)Math.PI;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return entitySize.field_220316_b * 0.8f;
    }

    @Override
    public int func_70646_bf() {
        if (this.func_233684_eK_()) {
            return 20;
        }
        return super.func_70646_bf();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource2, float f2) {
        DamageSource damageSource2;
        if (this.func_180431_b(damageSource2)) {
            return false;
        }
        Entity entity = damageSource2.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            float f2 = (f2 + 1.0f) / 2.0f;
        }
        return super.func_70097_a(damageSource2, f2);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean bl = entity.func_70097_a(DamageSource.func_76358_a(this), (int)this.func_233637_b_(Attributes.field_233823_f_));
        if (bl) {
            this.func_174815_a(this, entity);
        }
        return bl;
    }

    @Override
    public void func_70903_f(boolean bl) {
        super.func_70903_f(bl);
        if (bl) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
            this.func_70606_j(20.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(8.0);
        }
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ActionResultType func_230254_b_(PlayerEntity playerEntity2, Hand hand) {
        ItemStack itemStack = playerEntity2.func_184586_b(hand);
        Item \u26032 = itemStack.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            boolean bl = this.func_152114_e(playerEntity2) || this.func_70909_n() || \u26032 == Items.field_151103_aS && !this.func_70909_n() && !this.func_233678_J__();
            return bl ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (this.func_70909_n()) {
            PlayerEntity playerEntity2;
            if (this.func_70877_b(itemStack) && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!playerEntity2.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
                this.func_70691_i(\u26032.func_219967_s().func_221466_a());
                return ActionResultType.SUCCESS;
            }
            if (\u26032 instanceof DyeItem) {
                DyeColor dyeColor = ((DyeItem)\u26032).func_195962_g();
                if (dyeColor == this.func_175546_cu()) return super.func_230254_b_(playerEntity2, hand);
                this.func_175547_a(dyeColor);
                if (playerEntity2.field_71075_bZ.field_75098_d) return ActionResultType.SUCCESS;
                itemStack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            ActionResultType \u26033 = super.func_230254_b_(playerEntity2, hand);
            if (\u26033.func_226246_a_() && !this.func_70631_g_() || !this.func_152114_e(playerEntity2)) return \u26033;
            this.func_233687_w_(!this.func_233685_eM_());
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            return ActionResultType.SUCCESS;
        }
        if (\u26032 != Items.field_151103_aS || this.func_233678_J__()) return super.func_230254_b_(playerEntity2, hand);
        if (!playerEntity2.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.func_193101_c(playerEntity2);
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            this.func_233687_w_(true);
            this.field_70170_p.func_72960_a(this, (byte)7);
            return ActionResultType.SUCCESS;
        } else {
            this.field_70170_p.func_72960_a(this, (byte)6);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 8) {
            this.field_70928_h = true;
            this.field_70929_i = 0.0f;
            this.field_70927_j = 0.0f;
        } else {
            super.func_70103_a(by);
        }
    }

    public float func_70920_v() {
        if (this.func_233678_J__()) {
            return 1.5393804f;
        }
        if (this.func_70909_n()) {
            return (0.55f - (this.func_110138_aP() - this.func_110143_aJ()) * 0.02f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return item.func_219971_r() && item.func_219967_s().func_221467_c();
    }

    @Override
    public int func_70641_bl() {
        return 8;
    }

    @Override
    public int func_230256_F__() {
        return this.field_70180_af.func_187225_a(field_234232_bz_);
    }

    @Override
    public void func_230260_a__(int n) {
        this.field_70180_af.func_187227_b(field_234232_bz_, n);
    }

    @Override
    public void func_230258_H__() {
        this.func_230260_a__(field_234230_bG_.func_233018_a_(this.field_70146_Z));
    }

    @Override
    @Nullable
    public UUID func_230257_G__() {
        return this.field_234231_bH_;
    }

    @Override
    public void func_230259_a_(@Nullable UUID uUID) {
        this.field_234231_bH_ = uUID;
    }

    public DyeColor func_175546_cu() {
        return DyeColor.func_196056_a(this.field_70180_af.func_187225_a(field_184758_bB));
    }

    public void func_175547_a(DyeColor dyeColor) {
        this.field_70180_af.func_187227_b(field_184758_bB, dyeColor.func_196059_a());
    }

    @Override
    public WolfEntity func_90011_a(AgeableEntity ageableEntity) {
        WolfEntity wolfEntity = EntityType.field_200724_aC.func_200721_a(this.field_70170_p);
        UUID \u26032 = this.func_184753_b();
        if (\u26032 != null) {
            wolfEntity.func_184754_b(\u26032);
            wolfEntity.func_70903_f(true);
        }
        return wolfEntity;
    }

    public void func_70918_i(boolean bl) {
        this.field_70180_af.func_187227_b(field_184760_bA, bl);
    }

    @Override
    public boolean func_70878_b(AnimalEntity animalEntity) {
        if (animalEntity == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(animalEntity instanceof WolfEntity)) {
            return false;
        }
        WolfEntity wolfEntity = (WolfEntity)animalEntity;
        if (!wolfEntity.func_70909_n()) {
            return false;
        }
        if (wolfEntity.func_233684_eK_()) {
            return false;
        }
        return this.func_70880_s() && wolfEntity.func_70880_s();
    }

    public boolean func_70922_bv() {
        return this.field_70180_af.func_187225_a(field_184760_bA);
    }

    @Override
    public boolean func_142018_a(LivingEntity livingEntity3, LivingEntity livingEntity2) {
        LivingEntity livingEntity3;
        if (livingEntity3 instanceof CreeperEntity || livingEntity3 instanceof GhastEntity) {
            return false;
        }
        if (livingEntity3 instanceof WolfEntity) {
            WolfEntity wolfEntity = (WolfEntity)livingEntity3;
            return !wolfEntity.func_70909_n() || wolfEntity.func_70902_q() != livingEntity2;
        }
        if (livingEntity3 instanceof PlayerEntity && livingEntity2 instanceof PlayerEntity && !((PlayerEntity)livingEntity2).func_96122_a((PlayerEntity)livingEntity3)) {
            return false;
        }
        if (livingEntity3 instanceof AbstractHorseEntity && ((AbstractHorseEntity)livingEntity3).func_110248_bS()) {
            return false;
        }
        return !(livingEntity3 instanceof TameableEntity) || !((TameableEntity)livingEntity3).func_70909_n();
    }

    @Override
    public boolean func_184652_a(PlayerEntity playerEntity) {
        return !this.func_233678_J__() && super.func_184652_a(playerEntity);
    }

    @Override
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.6f * this.func_70047_e(), this.func_213311_cf() * 0.4f);
    }

    @Override
    public /* synthetic */ AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return this.func_90011_a(ageableEntity);
    }

    class AvoidEntityGoal<T extends LivingEntity>
    extends net.minecraft.entity.ai.goal.AvoidEntityGoal<T> {
        private final WolfEntity field_190856_d;

        public AvoidEntityGoal(WolfEntity wolfEntity2, Class<T> clazz, float f, double d, double d2) {
            super(wolfEntity2, clazz, f, d, d2);
            this.field_190856_d = wolfEntity2;
        }

        @Override
        public boolean func_75250_a() {
            if (super.func_75250_a() && this.field_75376_d instanceof LlamaEntity) {
                return !this.field_190856_d.func_70909_n() && this.func_190854_a((LlamaEntity)this.field_75376_d);
            }
            return false;
        }

        private boolean func_190854_a(LlamaEntity llamaEntity) {
            return llamaEntity.func_190707_dL() >= WolfEntity.this.field_70146_Z.nextInt(5);
        }

        @Override
        public void func_75249_e() {
            WolfEntity.this.func_70624_b(null);
            super.func_75249_e();
        }

        @Override
        public void func_75246_d() {
            WolfEntity.this.func_70624_b(null);
            super.func_75246_d();
        }
    }
}

