/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.LandOnOwnersShoulderGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.ShoulderRidingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ParrotEntity
extends ShoulderRidingEntity
implements IFlyingAnimal {
    private static final DataParameter<Integer> field_192013_bG = EntityDataManager.func_187226_a(ParrotEntity.class, DataSerializers.field_187192_b);
    private static final Predicate<MobEntity> field_192014_bH = new Predicate<MobEntity>(){

        @Override
        public boolean test(@Nullable MobEntity mobEntity) {
            return mobEntity != null && field_192017_bK.containsKey(mobEntity.func_200600_R());
        }

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((MobEntity)object);
        }
    };
    private static final Item field_192015_bI = Items.field_151106_aX;
    private static final Set<Item> field_192016_bJ = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    private static final Map<EntityType<?>, SoundEvent> field_192017_bK = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put(EntityType.field_200792_f, SoundEvents.field_193791_eM);
        hashMap.put(EntityType.field_200794_h, SoundEvents.field_193813_fc);
        hashMap.put(EntityType.field_200797_k, SoundEvents.field_193792_eN);
        hashMap.put(EntityType.field_204724_o, SoundEvents.field_206942_fI);
        hashMap.put(EntityType.field_200800_n, SoundEvents.field_193793_eO);
        hashMap.put(EntityType.field_200802_p, SoundEvents.field_193794_eP);
        hashMap.put(EntityType.field_200804_r, SoundEvents.field_193796_eR);
        hashMap.put(EntityType.field_200806_t, SoundEvents.field_193797_eS);
        hashMap.put(EntityType.field_200811_y, SoundEvents.field_193798_eT);
        hashMap.put(EntityType.field_200761_A, SoundEvents.field_219654_hI);
        hashMap.put(EntityType.field_233588_G_, SoundEvents.field_232796_kj_);
        hashMap.put(EntityType.field_200763_C, SoundEvents.field_193799_eU);
        hashMap.put(EntityType.field_200764_D, SoundEvents.field_193800_eV);
        hashMap.put(EntityType.field_200771_K, SoundEvents.field_193801_eW);
        hashMap.put(EntityType.field_203097_aH, SoundEvents.field_206943_fS);
        hashMap.put(EntityType.field_233591_ai_, SoundEvents.field_232797_ko_);
        hashMap.put(EntityType.field_220350_aJ, SoundEvents.field_219656_hO);
        hashMap.put(EntityType.field_220352_aU, SoundEvents.field_219657_hQ);
        hashMap.put(EntityType.field_200738_ad, SoundEvents.field_193803_eY);
        hashMap.put(EntityType.field_200740_af, SoundEvents.field_193804_eZ);
        hashMap.put(EntityType.field_200741_ag, SoundEvents.field_193811_fa);
        hashMap.put(EntityType.field_200743_ai, SoundEvents.field_193812_fb);
        hashMap.put(EntityType.field_200748_an, SoundEvents.field_193813_fc);
        hashMap.put(EntityType.field_200750_ap, SoundEvents.field_193814_fd);
        hashMap.put(EntityType.field_200755_au, SoundEvents.field_193815_fe);
        hashMap.put(EntityType.field_200758_ax, SoundEvents.field_193816_ff);
        hashMap.put(EntityType.field_200759_ay, SoundEvents.field_193817_fg);
        hashMap.put(EntityType.field_200760_az, SoundEvents.field_193818_fh);
        hashMap.put(EntityType.field_200722_aA, SoundEvents.field_193819_fi);
        hashMap.put(EntityType.field_233590_aW_, SoundEvents.field_232786_kC_);
        hashMap.put(EntityType.field_200725_aD, SoundEvents.field_193821_fk);
        hashMap.put(EntityType.field_200727_aF, SoundEvents.field_193823_fm);
    });
    public float field_192008_bB;
    public float field_192009_bC;
    public float field_192010_bD;
    public float field_192011_bE;
    private float field_192012_bF = 1.0f;
    private boolean field_192018_bL;
    private BlockPos field_192019_bM;

    public ParrotEntity(EntityType<? extends ParrotEntity> entityType, World world) {
        super((EntityType<? extends ShoulderRidingEntity>)entityType, world);
        this.field_70765_h = new FlyingMovementController(this, 10, false);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld2, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        IWorld iWorld2;
        this.func_191997_m(this.field_70146_Z.nextInt(5));
        if (iLivingEntityData2 == null) {
            ILivingEntityData iLivingEntityData2 = new AgeableEntity.AgeableData();
            ((AgeableEntity.AgeableData)iLivingEntityData2).func_226259_a_(false);
        }
        return super.func_213386_a(iWorld2, difficultyInstance, spawnReason, iLivingEntityData2, compoundNBT);
    }

    @Override
    public boolean func_70631_g_() {
        return false;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new PanicGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, new SitGoal(this));
        this.field_70714_bg.func_75776_a(2, new FollowOwnerGoal(this, 1.0, 5.0f, 1.0f, true));
        this.field_70714_bg.func_75776_a(2, new WaterAvoidingRandomFlyingGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, new LandOnOwnersShoulderGoal(this));
        this.field_70714_bg.func_75776_a(3, new FollowMobGoal(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeModifierMap.MutableAttribute func_234213_eS_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233822_e_, 0.4f).func_233815_a_(Attributes.field_233821_d_, 0.2f);
    }

    @Override
    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator flyingPathNavigator = new FlyingPathNavigator(this, world);
        flyingPathNavigator.func_192879_a(false);
        flyingPathNavigator.func_212239_d(true);
        flyingPathNavigator.func_192878_b(true);
        return flyingPathNavigator;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return entitySize.field_220316_b * 0.6f;
    }

    @Override
    public void func_70636_d() {
        if (this.field_192019_bM == null || !this.field_192019_bM.func_218137_a(this.func_213303_ch(), 3.46) || !this.field_70170_p.func_180495_p(this.field_192019_bM).func_203425_a(Blocks.field_150421_aI)) {
            this.field_192018_bL = false;
            this.field_192019_bM = null;
        }
        if (this.field_70170_p.field_73012_v.nextInt(400) == 0) {
            ParrotEntity.func_192006_b(this.field_70170_p, this);
        }
        super.func_70636_d();
        this.func_192001_dv();
    }

    @Override
    public void func_191987_a(BlockPos blockPos, boolean bl) {
        this.field_192019_bM = blockPos;
        this.field_192018_bL = bl;
    }

    public boolean func_192004_dr() {
        return this.field_192018_bL;
    }

    private void func_192001_dv() {
        this.field_192011_bE = this.field_192008_bB;
        this.field_192010_bD = this.field_192009_bC;
        this.field_192009_bC = (float)((double)this.field_192009_bC + (double)(this.field_70122_E || this.func_184218_aH() ? -1 : 4) * 0.3);
        this.field_192009_bC = MathHelper.func_76131_a(this.field_192009_bC, 0.0f, 1.0f);
        if (!this.field_70122_E && this.field_192012_bF < 1.0f) {
            this.field_192012_bF = 1.0f;
        }
        this.field_192012_bF = (float)((double)this.field_192012_bF * 0.9);
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.field_192008_bB += this.field_192012_bF * 2.0f;
    }

    public static boolean func_192006_b(World world, Entity entity) {
        if (!entity.func_70089_S() || entity.func_174814_R() || world.field_73012_v.nextInt(2) != 0) {
            return false;
        }
        List<MobEntity> list = world.func_175647_a(MobEntity.class, entity.func_174813_aQ().func_186662_g(20.0), field_192014_bH);
        if (!list.isEmpty() && !(\u2603 = list.get(world.field_73012_v.nextInt(list.size()))).func_174814_R()) {
            SoundEvent soundEvent = ParrotEntity.func_200610_a(\u2603.func_200600_R());
            world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), soundEvent, entity.func_184176_by(), 0.7f, ParrotEntity.func_192000_b(world.field_73012_v));
            return true;
        }
        return false;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (!this.func_70909_n() && field_192016_bJ.contains(itemStack.func_77973_b())) {
            if (!playerEntity.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_192797_eu, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.func_193101_c(playerEntity);
                    this.field_70170_p.func_72960_a(this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a(this, (byte)6);
                }
            }
            return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
        }
        if (itemStack.func_77973_b() == field_192015_bI) {
            if (!playerEntity.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            this.func_195064_c(new EffectInstance(Effects.field_76436_u, 900));
            if (playerEntity.func_184812_l_() || !this.func_190530_aW()) {
                this.func_70097_a(DamageSource.func_76365_a(playerEntity), Float.MAX_VALUE);
            }
            return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
        }
        if (!this.func_192002_a() && this.func_70909_n() && this.func_152114_e(playerEntity)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_233687_w_(!this.func_233685_eM_());
            }
            return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(playerEntity, hand);
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return false;
    }

    public static boolean func_223317_c(EntityType<ParrotEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        BlockState blockState = iWorld.func_180495_p(blockPos.func_177977_b());
        return (blockState.func_235714_a_(BlockTags.field_206952_E) || blockState.func_203425_a(Blocks.field_196658_i) || blockState.func_235714_a_(BlockTags.field_200031_h) || blockState.func_203425_a(Blocks.field_150350_a)) && iWorld.func_226659_b_(blockPos, 0) > 8;
    }

    @Override
    public boolean func_225503_b_(float f, float f2) {
        return false;
    }

    @Override
    protected void func_184231_a(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    @Override
    public boolean func_70878_b(AnimalEntity animalEntity) {
        return false;
    }

    @Override
    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return null;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        return entity.func_70097_a(DamageSource.func_76358_a(this), 3.0f);
    }

    @Override
    @Nullable
    public SoundEvent func_184639_G() {
        return ParrotEntity.func_234212_a_(this.field_70170_p, this.field_70170_p.field_73012_v);
    }

    public static SoundEvent func_234212_a_(World world, Random random) {
        if (world.func_175659_aa() != Difficulty.PEACEFUL && random.nextInt(1000) == 0) {
            ArrayList arrayList = Lists.newArrayList(field_192017_bK.keySet());
            return ParrotEntity.func_200610_a((EntityType)arrayList.get(random.nextInt(arrayList.size())));
        }
        return SoundEvents.field_192792_ep;
    }

    private static SoundEvent func_200610_a(EntityType<?> entityType) {
        return field_192017_bK.getOrDefault(entityType, SoundEvents.field_192792_ep);
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_192794_er;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_192793_eq;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_192795_es, 0.15f, 1.0f);
    }

    @Override
    protected float func_191954_d(float f) {
        this.func_184185_a(SoundEvents.field_192796_et, 0.15f, 1.0f);
        return f + this.field_192009_bC / 2.0f;
    }

    @Override
    protected boolean func_191957_ae() {
        return true;
    }

    @Override
    protected float func_70647_i() {
        return ParrotEntity.func_192000_b(this.field_70146_Z);
    }

    public static float func_192000_b(Random random) {
        return (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    @Override
    public boolean func_70104_M() {
        return true;
    }

    @Override
    protected void func_82167_n(Entity entity) {
        if (entity instanceof PlayerEntity) {
            return;
        }
        super.func_82167_n(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        this.func_233687_w_(false);
        return super.func_70097_a(damageSource, f);
    }

    public int func_191998_ds() {
        return MathHelper.func_76125_a(this.field_70180_af.func_187225_a(field_192013_bG), 0, 4);
    }

    public void func_191997_m(int n) {
        this.field_70180_af.func_187227_b(field_192013_bG, n);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_192013_bG, 0);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("Variant", this.func_191998_ds());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_191997_m(compoundNBT.func_74762_e("Variant"));
    }

    public boolean func_192002_a() {
        return !this.field_70122_E;
    }

    @Override
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.5f * this.func_70047_e(), this.func_213311_cf() * 0.4f);
    }
}

