/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ShulkerAABBHelper;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;

public class ShulkerEntity
extends GolemEntity
implements IMob {
    private static final UUID field_184703_bv = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier field_184704_bw = new AttributeModifier(field_184703_bv, "Covered armor bonus", 20.0, AttributeModifier.Operation.ADDITION);
    protected static final DataParameter<Direction> field_184700_a = EntityDataManager.func_187226_a(ShulkerEntity.class, DataSerializers.field_187202_l);
    protected static final DataParameter<Optional<BlockPos>> field_184701_b = EntityDataManager.func_187226_a(ShulkerEntity.class, DataSerializers.field_187201_k);
    protected static final DataParameter<Byte> field_184702_c = EntityDataManager.func_187226_a(ShulkerEntity.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> field_190770_bw = EntityDataManager.func_187226_a(ShulkerEntity.class, DataSerializers.field_187191_a);
    private float field_184705_bx;
    private float field_184706_by;
    private BlockPos field_184707_bz = null;
    private int field_184708_bA;

    public ShulkerEntity(EntityType<? extends ShulkerEntity> entityType, World world) {
        super((EntityType<? extends GolemEntity>)entityType, world);
        this.field_70728_aV = 5;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, new AttackGoal());
        this.field_70714_bg.func_75776_a(7, new PeekGoal());
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AttackNearestGoal(this));
        this.field_70715_bh.func_75776_a(3, new DefenseAttackGoal(this));
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187773_eO;
    }

    @Override
    public void func_70642_aH() {
        if (!this.func_184686_df()) {
            super.func_70642_aH();
        }
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187781_eS;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (this.func_184686_df()) {
            return SoundEvents.field_187785_eU;
        }
        return SoundEvents.field_187783_eT;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184700_a, Direction.DOWN);
        this.field_70180_af.func_187214_a(field_184701_b, Optional.empty());
        this.field_70180_af.func_187214_a(field_184702_c, (byte)0);
        this.field_70180_af.func_187214_a(field_190770_bw, (byte)16);
    }

    public static AttributeModifierMap.MutableAttribute func_234300_m_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0);
    }

    @Override
    protected BodyController func_184650_s() {
        return new BodyHelperController(this);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.field_70180_af.func_187227_b(field_184700_a, Direction.func_82600_a(compoundNBT.func_74771_c("AttachFace")));
        this.field_70180_af.func_187227_b(field_184702_c, compoundNBT.func_74771_c("Peek"));
        this.field_70180_af.func_187227_b(field_190770_bw, compoundNBT.func_74771_c("Color"));
        if (compoundNBT.func_74764_b("APX")) {
            int n = compoundNBT.func_74762_e("APX");
            \u2603 = compoundNBT.func_74762_e("APY");
            \u2603 = compoundNBT.func_74762_e("APZ");
            this.field_70180_af.func_187227_b(field_184701_b, Optional.of(new BlockPos(n, \u2603, \u2603)));
        } else {
            this.field_70180_af.func_187227_b(field_184701_b, Optional.empty());
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74774_a("AttachFace", (byte)this.field_70180_af.func_187225_a(field_184700_a).func_176745_a());
        compoundNBT.func_74774_a("Peek", this.field_70180_af.func_187225_a(field_184702_c));
        compoundNBT.func_74774_a("Color", this.field_70180_af.func_187225_a(field_190770_bw));
        BlockPos blockPos = this.func_184699_da();
        if (blockPos != null) {
            compoundNBT.func_74768_a("APX", blockPos.func_177958_n());
            compoundNBT.func_74768_a("APY", blockPos.func_177956_o());
            compoundNBT.func_74768_a("APZ", blockPos.func_177952_p());
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos blockPos = this.field_70180_af.func_187225_a(field_184701_b).orElse(null);
        if (blockPos == null && !this.field_70170_p.field_72995_K) {
            blockPos = this.func_233580_cy_();
            this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockPos));
        }
        if (this.func_184218_aH()) {
            blockPos = null;
            this.field_70177_z = f = this.func_184187_bx().field_70177_z;
            this.field_70761_aq = f;
            this.field_70760_ar = f;
            this.field_184708_bA = 0;
        } else if (!this.field_70170_p.field_72995_K) {
            BlockState blockState = this.field_70170_p.func_180495_p(blockPos);
            if (!blockState.func_196958_f()) {
                Direction direction;
                if (blockState.func_203425_a(Blocks.field_196603_bb)) {
                    direction = blockState.func_177229_b(PistonBlock.field_176387_N);
                    if (this.field_70170_p.func_175623_d(blockPos.func_177972_a(direction))) {
                        blockPos = blockPos.func_177972_a(direction);
                        this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockPos));
                    } else {
                        this.func_184689_o();
                    }
                } else if (blockState.func_203425_a(Blocks.field_150332_K)) {
                    direction = blockState.func_177229_b(PistonHeadBlock.field_176387_N);
                    if (this.field_70170_p.func_175623_d(blockPos.func_177972_a(direction))) {
                        blockPos = blockPos.func_177972_a(direction);
                        this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockPos));
                    } else {
                        this.func_184689_o();
                    }
                } else {
                    this.func_184689_o();
                }
            }
            if (!this.func_234298_a_(blockPos, direction = this.func_184696_cZ())) {
                Direction direction = this.func_234299_g_(blockPos);
                if (direction != null) {
                    this.field_70180_af.func_187227_b(field_184700_a, direction);
                } else {
                    this.func_184689_o();
                }
            }
        }
        float f = (float)this.func_184684_db() * 0.01f;
        this.field_184705_bx = this.field_184706_by;
        if (this.field_184706_by > f) {
            this.field_184706_by = MathHelper.func_76131_a(this.field_184706_by - 0.05f, f, 1.0f);
        } else if (this.field_184706_by < f) {
            this.field_184706_by = MathHelper.func_76131_a(this.field_184706_by + 0.05f, 0.0f, f);
        }
        if (blockPos != null) {
            if (this.field_70170_p.field_72995_K) {
                if (this.field_184708_bA > 0 && this.field_184707_bz != null) {
                    --this.field_184708_bA;
                } else {
                    this.field_184707_bz = blockPos;
                }
            }
            this.func_226286_f_((double)blockPos.func_177958_n() + 0.5, blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5);
            double d = 0.5 - (double)MathHelper.func_76126_a((0.5f + this.field_184706_by) * (float)Math.PI) * 0.5;
            \u2603 = 0.5 - (double)MathHelper.func_76126_a((0.5f + this.field_184705_bx) * (float)Math.PI) * 0.5;
            Direction \u26032 = this.func_184696_cZ().func_176734_d();
            this.func_174826_a(new AxisAlignedBB(this.func_226277_ct_() - 0.5, this.func_226278_cu_(), this.func_226281_cx_() - 0.5, this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + 0.5).func_72321_a((double)\u26032.func_82601_c() * d, (double)\u26032.func_96559_d() * d, (double)\u26032.func_82599_e() * d));
            \u2603 = d - \u2603;
            if (\u2603 > 0.0 && !(\u2603 = this.field_70170_p.func_72839_b(this, this.func_174813_aQ())).isEmpty()) {
                for (Entity entity : \u2603) {
                    if (entity instanceof ShulkerEntity || entity.field_70145_X) continue;
                    entity.func_213315_a(MoverType.SHULKER, new Vector3d(\u2603 * (double)\u26032.func_82601_c(), \u2603 * (double)\u26032.func_96559_d(), \u2603 * (double)\u26032.func_82599_e()));
                }
            }
        }
    }

    @Override
    public void func_213315_a(MoverType moverType, Vector3d vector3d) {
        if (moverType == MoverType.SHULKER_BOX) {
            this.func_184689_o();
        } else {
            super.func_213315_a(moverType, vector3d);
        }
    }

    @Override
    public void func_70107_b(double d, double d2, double d3) {
        super.func_70107_b(d, d2, d3);
        if (this.field_70180_af == null || this.field_70173_aa == 0) {
            return;
        }
        Optional<BlockPos> optional = this.field_70180_af.func_187225_a(field_184701_b);
        \u2603 = Optional.of(new BlockPos(d, d2, d3));
        if (!\u2603.equals(optional)) {
            this.field_70180_af.func_187227_b(field_184701_b, \u2603);
            this.field_70180_af.func_187227_b(field_184702_c, (byte)0);
            this.field_70160_al = true;
        }
    }

    @Nullable
    protected Direction func_234299_g_(BlockPos blockPos) {
        for (Direction direction : Direction.values()) {
            if (!this.func_234298_a_(blockPos, direction)) continue;
            return direction;
        }
        return null;
    }

    private boolean func_234298_a_(BlockPos blockPos, Direction direction) {
        return this.field_70170_p.func_234929_a_(blockPos.func_177972_a(direction), this, direction.func_176734_d()) && this.field_70170_p.func_226665_a__(this, ShulkerAABBHelper.func_233539_a_(blockPos, direction.func_176734_d()));
    }

    protected boolean func_184689_o() {
        if (this.func_175446_cd() || !this.func_70089_S()) {
            return true;
        }
        BlockPos blockPos = this.func_233580_cy_();
        for (int i = 0; i < 5; ++i) {
            BlockPos blockPos2 = blockPos.func_177982_a(8 - this.field_70146_Z.nextInt(17), 8 - this.field_70146_Z.nextInt(17), 8 - this.field_70146_Z.nextInt(17));
            if (blockPos2.func_177956_o() <= 0 || !this.field_70170_p.func_175623_d(blockPos2) || !this.field_70170_p.func_175723_af().func_177746_a(blockPos2) || !this.field_70170_p.func_226665_a__(this, new AxisAlignedBB(blockPos2)) || (\u2603 = this.func_234299_g_(blockPos2)) == null) continue;
            this.field_70180_af.func_187227_b(field_184700_a, \u2603);
            this.func_184185_a(SoundEvents.field_187791_eX, 1.0f, 1.0f);
            this.field_70180_af.func_187227_b(field_184701_b, Optional.of(blockPos2));
            this.field_70180_af.func_187227_b(field_184702_c, (byte)0);
            this.func_70624_b(null);
            return true;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_213317_d(Vector3d.field_186680_a);
        if (!this.func_175446_cd()) {
            this.field_70760_ar = 0.0f;
            this.field_70761_aq = 0.0f;
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_184701_b.equals(dataParameter) && this.field_70170_p.field_72995_K && !this.func_184218_aH() && (\u2603 = this.func_184699_da()) != null) {
            if (this.field_184707_bz == null) {
                this.field_184707_bz = \u2603;
            } else {
                this.field_184708_bA = 6;
            }
            this.func_226286_f_((double)\u2603.func_177958_n() + 0.5, \u2603.func_177956_o(), (double)\u2603.func_177952_p() + 0.5);
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    public void func_180426_a(double d, double d2, double d3, float f, float f2, int n, boolean bl) {
        this.field_70716_bi = 0;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_184686_df() && (\u2603 = damageSource.func_76364_f()) instanceof AbstractArrowEntity) {
            return false;
        }
        if (super.func_70097_a(damageSource, f)) {
            if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.5 && this.field_70146_Z.nextInt(4) == 0) {
                this.func_184689_o();
            }
            return true;
        }
        return false;
    }

    private boolean func_184686_df() {
        return this.func_184684_db() == 0;
    }

    @Override
    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public Direction func_184696_cZ() {
        return this.field_70180_af.func_187225_a(field_184700_a);
    }

    @Nullable
    public BlockPos func_184699_da() {
        return this.field_70180_af.func_187225_a(field_184701_b).orElse(null);
    }

    public void func_184694_g(@Nullable BlockPos blockPos) {
        this.field_70180_af.func_187227_b(field_184701_b, Optional.ofNullable(blockPos));
    }

    public int func_184684_db() {
        return this.field_70180_af.func_187225_a(field_184702_c).byteValue();
    }

    public void func_184691_a(int n) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(Attributes.field_233826_i_).func_111124_b(field_184704_bw);
            if (n == 0) {
                this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(field_184704_bw);
                this.func_184185_a(SoundEvents.field_187779_eR, 1.0f, 1.0f);
            } else {
                this.func_184185_a(SoundEvents.field_187787_eV, 1.0f, 1.0f);
            }
        }
        this.field_70180_af.func_187227_b(field_184702_c, (byte)n);
    }

    public float func_184688_a(float f) {
        return MathHelper.func_219799_g(f, this.field_184705_bx, this.field_184706_by);
    }

    public int func_184693_dc() {
        return this.field_184708_bA;
    }

    public BlockPos func_184692_dd() {
        return this.field_184707_bz;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return 0.5f;
    }

    @Override
    public int func_70646_bf() {
        return 180;
    }

    @Override
    public int func_184649_cE() {
        return 180;
    }

    @Override
    public void func_70108_f(Entity entity) {
    }

    @Override
    public float func_70111_Y() {
        return 0.0f;
    }

    public boolean func_184697_de() {
        return this.field_184707_bz != null && this.func_184699_da() != null;
    }

    @Nullable
    public DyeColor func_190769_dn() {
        Byte by = this.field_70180_af.func_187225_a(field_190770_bw);
        if (by == 16 || by > 15) {
            return null;
        }
        return DyeColor.func_196056_a(by.byteValue());
    }

    static class DefenseAttackGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public DefenseAttackGoal(ShulkerEntity shulkerEntity) {
            super(shulkerEntity, LivingEntity.class, 10, true, false, livingEntity -> livingEntity instanceof IMob);
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_75299_d.func_96124_cp() == null) {
                return false;
            }
            return super.func_75250_a();
        }

        @Override
        protected AxisAlignedBB func_188511_a(double d) {
            Direction direction = ((ShulkerEntity)this.field_75299_d).func_184696_cZ();
            if (direction.func_176740_k() == Direction.Axis.X) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(4.0, d, d);
            }
            if (direction.func_176740_k() == Direction.Axis.Z) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(d, d, 4.0);
            }
            return this.field_75299_d.func_174813_aQ().func_72314_b(d, 4.0, d);
        }
    }

    class AttackNearestGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackNearestGoal(ShulkerEntity shulkerEntity2) {
            super((MobEntity)shulkerEntity2, PlayerEntity.class, true);
        }

        @Override
        public boolean func_75250_a() {
            if (ShulkerEntity.this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                return false;
            }
            return super.func_75250_a();
        }

        @Override
        protected AxisAlignedBB func_188511_a(double d) {
            Direction direction = ((ShulkerEntity)this.field_75299_d).func_184696_cZ();
            if (direction.func_176740_k() == Direction.Axis.X) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(4.0, d, d);
            }
            if (direction.func_176740_k() == Direction.Axis.Z) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(d, d, 4.0);
            }
            return this.field_75299_d.func_174813_aQ().func_72314_b(d, 4.0, d);
        }
    }

    class AttackGoal
    extends Goal {
        private int field_188520_b;

        public AttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            LivingEntity livingEntity = ShulkerEntity.this.func_70638_az();
            if (livingEntity == null || !livingEntity.func_70089_S()) {
                return false;
            }
            return ShulkerEntity.this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL;
        }

        @Override
        public void func_75249_e() {
            this.field_188520_b = 20;
            ShulkerEntity.this.func_184691_a(100);
        }

        @Override
        public void func_75251_c() {
            ShulkerEntity.this.func_184691_a(0);
        }

        @Override
        public void func_75246_d() {
            if (ShulkerEntity.this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                return;
            }
            --this.field_188520_b;
            LivingEntity livingEntity = ShulkerEntity.this.func_70638_az();
            ShulkerEntity.this.func_70671_ap().func_75651_a(livingEntity, 180.0f, 180.0f);
            double \u26032 = ShulkerEntity.this.func_70068_e(livingEntity);
            if (\u26032 < 400.0) {
                if (this.field_188520_b <= 0) {
                    this.field_188520_b = 20 + ShulkerEntity.this.field_70146_Z.nextInt(10) * 20 / 2;
                    ShulkerEntity.this.field_70170_p.func_217376_c(new ShulkerBulletEntity(ShulkerEntity.this.field_70170_p, ShulkerEntity.this, livingEntity, ShulkerEntity.this.func_184696_cZ().func_176740_k()));
                    ShulkerEntity.this.func_184185_a(SoundEvents.field_187789_eW, 2.0f, (ShulkerEntity.this.field_70146_Z.nextFloat() - ShulkerEntity.this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
            } else {
                ShulkerEntity.this.func_70624_b(null);
            }
            super.func_75246_d();
        }
    }

    class PeekGoal
    extends Goal {
        private int field_188522_b;

        private PeekGoal() {
        }

        @Override
        public boolean func_75250_a() {
            return ShulkerEntity.this.func_70638_az() == null && ShulkerEntity.this.field_70146_Z.nextInt(40) == 0;
        }

        @Override
        public boolean func_75253_b() {
            return ShulkerEntity.this.func_70638_az() == null && this.field_188522_b > 0;
        }

        @Override
        public void func_75249_e() {
            this.field_188522_b = 20 * (1 + ShulkerEntity.this.field_70146_Z.nextInt(3));
            ShulkerEntity.this.func_184691_a(30);
        }

        @Override
        public void func_75251_c() {
            if (ShulkerEntity.this.func_70638_az() == null) {
                ShulkerEntity.this.func_184691_a(0);
            }
        }

        @Override
        public void func_75246_d() {
            --this.field_188522_b;
        }
    }

    class BodyHelperController
    extends BodyController {
        public BodyHelperController(MobEntity mobEntity) {
            super(mobEntity);
        }

        @Override
        public void func_75664_a() {
        }
    }
}

