/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class IllusionerEntity
extends SpellcastingIllagerEntity
implements IRangedAttackMob {
    private int field_193099_c;
    private final Vector3d[][] field_193100_bx;

    public IllusionerEntity(EntityType<? extends IllusionerEntity> entityType, World world) {
        super((EntityType<? extends SpellcastingIllagerEntity>)entityType, world);
        this.field_70728_aV = 5;
        this.field_193100_bx = new Vector3d[2][4];
        for (int i = 0; i < 4; ++i) {
            this.field_193100_bx[0][i] = Vector3d.field_186680_a;
            this.field_193100_bx[1][i] = Vector3d.field_186680_a;
        }
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, new SpellcastingIllagerEntity.CastingASpellGoal(this));
        this.field_70714_bg.func_75776_a(4, new MirrorSpellGoal());
        this.field_70714_bg.func_75776_a(5, new BlindnessSpellGoal());
        this.field_70714_bg.func_75776_a(6, new RangedBowAttackGoal<IllusionerEntity>(this, 0.5, 20, 15.0f));
        this.field_70714_bg.func_75776_a(8, new RandomWalkingGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(9, new LookAtGoal(this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, new LookAtGoal(this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, AbstractRaiderEntity.class).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<AbstractVillagerEntity>((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<IronGolemEntity>((MobEntity)this, IronGolemEntity.class, false).func_190882_b(300));
    }

    public static AttributeModifierMap.MutableAttribute func_234293_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 18.0).func_233815_a_(Attributes.field_233818_a_, 32.0);
    }

    @Override
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151031_f));
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.func_82150_aj()) {
            --this.field_193099_c;
            if (this.field_193099_c < 0) {
                this.field_193099_c = 0;
            }
            if (this.field_70737_aN == 1 || this.field_70173_aa % 1200 == 0) {
                int n;
                this.field_193099_c = 3;
                float f = -6.0f;
                int \u26032 = 13;
                for (n = 0; n < 4; ++n) {
                    this.field_193100_bx[0][n] = this.field_193100_bx[1][n];
                    this.field_193100_bx[1][n] = new Vector3d((double)(-6.0f + (float)this.field_70146_Z.nextInt(13)) * 0.5, Math.max(0, this.field_70146_Z.nextInt(6) - 4), (double)(-6.0f + (float)this.field_70146_Z.nextInt(13)) * 0.5);
                }
                for (n = 0; n < 16; ++n) {
                    this.field_70170_p.func_195594_a(ParticleTypes.field_197613_f, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226285_f_(0.5), 0.0, 0.0, 0.0);
                }
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_193788_dg, this.func_184176_by(), 1.0f, 1.0f, false);
            } else if (this.field_70737_aN == this.field_70738_aO - 1) {
                this.field_193099_c = 3;
                for (int i = 0; i < 4; ++i) {
                    this.field_193100_bx[0][i] = this.field_193100_bx[1][i];
                    this.field_193100_bx[1][i] = new Vector3d(0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public SoundEvent func_213654_dW() {
        return SoundEvents.field_193783_dc;
    }

    public Vector3d[] func_193098_a(float f) {
        if (this.field_193099_c <= 0) {
            return this.field_193100_bx[1];
        }
        double d = ((float)this.field_193099_c - f) / 3.0f;
        d = Math.pow(d, 0.25);
        Vector3d[] \u26032 = new Vector3d[4];
        for (int i = 0; i < 4; ++i) {
            \u26032[i] = this.field_193100_bx[1][i].func_186678_a(1.0 - d).func_178787_e(this.field_193100_bx[0][i].func_186678_a(d));
        }
        return \u26032;
    }

    @Override
    public boolean func_184191_r(Entity entity) {
        if (super.func_184191_r(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entity.func_96124_cp() == null;
        }
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_193783_dc;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_193786_de;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_193787_df;
    }

    @Override
    protected SoundEvent func_193086_dk() {
        return SoundEvents.field_193784_dd;
    }

    @Override
    public void func_213660_a(int n, boolean bl) {
    }

    @Override
    public void func_82196_d(LivingEntity livingEntity, float f) {
        ItemStack itemStack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a(this, Items.field_151031_f)));
        AbstractArrowEntity \u26032 = ProjectileHelper.func_221272_a(this, itemStack, f);
        double \u26033 = livingEntity.func_226277_ct_() - this.func_226277_ct_();
        double \u26034 = livingEntity.func_226283_e_(0.3333333333333333) - \u26032.func_226278_cu_();
        double \u26035 = livingEntity.func_226281_cx_() - this.func_226281_cx_();
        double \u26036 = MathHelper.func_76133_a(\u26033 * \u26033 + \u26035 * \u26035);
        \u26032.func_70186_c(\u26033, \u26034 + \u26036 * (double)0.2f, \u26035, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c(\u26032);
    }

    @Override
    public AbstractIllagerEntity.ArmPose func_193077_p() {
        if (this.func_193082_dl()) {
            return AbstractIllagerEntity.ArmPose.SPELLCASTING;
        }
        if (this.func_213398_dR()) {
            return AbstractIllagerEntity.ArmPose.BOW_AND_ARROW;
        }
        return AbstractIllagerEntity.ArmPose.CROSSED;
    }

    class BlindnessSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private int field_193325_b;

        private BlindnessSpellGoal() {
            super(IllusionerEntity.this);
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (IllusionerEntity.this.func_70638_az() == null) {
                return false;
            }
            if (IllusionerEntity.this.func_70638_az().func_145782_y() == this.field_193325_b) {
                return false;
            }
            return IllusionerEntity.this.field_70170_p.func_175649_E(IllusionerEntity.this.func_233580_cy_()).func_193845_a(Difficulty.NORMAL.ordinal());
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.field_193325_b = IllusionerEntity.this.func_70638_az().func_145782_y();
        }

        @Override
        protected int func_190869_f() {
            return 20;
        }

        @Override
        protected int func_190872_i() {
            return 180;
        }

        @Override
        protected void func_190868_j() {
            IllusionerEntity.this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_76440_q, 400));
        }

        @Override
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_193789_dh;
        }

        @Override
        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.BLINDNESS;
        }
    }

    class MirrorSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private MirrorSpellGoal() {
            super(IllusionerEntity.this);
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            return !IllusionerEntity.this.func_70644_a(Effects.field_76441_p);
        }

        @Override
        protected int func_190869_f() {
            return 20;
        }

        @Override
        protected int func_190872_i() {
            return 340;
        }

        @Override
        protected void func_190868_j() {
            IllusionerEntity.this.func_195064_c(new EffectInstance(Effects.field_76441_p, 1200));
        }

        @Override
        @Nullable
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_193790_di;
        }

        @Override
        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.DISAPPEAR;
        }
    }
}

