/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.dispenser;

import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.RespawnAnchorBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.WitherSkeletonSkullBlock;
import net.minecraft.dispenser.BeehiveDispenseBehavior;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.DispenseBoatBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IDispenseItemBehavior {
    public static final IDispenseItemBehavior field_223216_a_ = (iBlockSource, itemStack) -> itemStack;

    public ItemStack dispense(IBlockSource var1, ItemStack var2);

    public static void func_218401_c() {
        DispenserBlock.func_199774_a(Items.field_151032_g, new ProjectileDispenseBehavior(){

            @Override
            protected ProjectileEntity func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                ArrowEntity arrowEntity = new ArrowEntity(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c());
                arrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
                return arrowEntity;
            }
        });
        DispenserBlock.func_199774_a(Items.field_185167_i, new ProjectileDispenseBehavior(){

            @Override
            protected ProjectileEntity func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                ArrowEntity arrowEntity = new ArrowEntity(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c());
                arrowEntity.func_184555_a(itemStack);
                arrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
                return arrowEntity;
            }
        });
        DispenserBlock.func_199774_a(Items.field_185166_h, new ProjectileDispenseBehavior(){

            @Override
            protected ProjectileEntity func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                SpectralArrowEntity spectralArrowEntity = new SpectralArrowEntity(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c());
                spectralArrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
                return spectralArrowEntity;
            }
        });
        DispenserBlock.func_199774_a(Items.field_151110_aK, new ProjectileDispenseBehavior(){

            @Override
            protected ProjectileEntity func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                return Util.func_200696_a(new EggEntity(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c()), eggEntity -> eggEntity.func_213884_b(itemStack));
            }
        });
        DispenserBlock.func_199774_a(Items.field_151126_ay, new ProjectileDispenseBehavior(){

            @Override
            protected ProjectileEntity func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                return Util.func_200696_a(new SnowballEntity(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c()), snowballEntity -> snowballEntity.func_213884_b(itemStack));
            }
        });
        DispenserBlock.func_199774_a(Items.field_151062_by, new ProjectileDispenseBehavior(){

            @Override
            protected ProjectileEntity func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                return Util.func_200696_a(new ExperienceBottleEntity(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c()), experienceBottleEntity -> experienceBottleEntity.func_213884_b(itemStack));
            }

            @Override
            protected float func_82498_a() {
                return super.func_82498_a() * 0.5f;
            }

            @Override
            protected float func_82500_b() {
                return super.func_82500_b() * 1.25f;
            }
        });
        DispenserBlock.func_199774_a(Items.field_185155_bH, new IDispenseItemBehavior(){

            @Override
            public ItemStack dispense(IBlockSource iBlockSource, ItemStack itemStack) {
                return new ProjectileDispenseBehavior(){

                    @Override
                    protected ProjectileEntity func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                        return Util.func_200696_a(new PotionEntity(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c()), potionEntity -> potionEntity.func_213884_b(itemStack));
                    }

                    @Override
                    protected float func_82498_a() {
                        return super.func_82498_a() * 0.5f;
                    }

                    @Override
                    protected float func_82500_b() {
                        return super.func_82500_b() * 1.25f;
                    }
                }.dispense(iBlockSource, itemStack);
            }
        });
        DispenserBlock.func_199774_a(Items.field_185156_bI, new IDispenseItemBehavior(){

            @Override
            public ItemStack dispense(IBlockSource iBlockSource, ItemStack itemStack) {
                return new ProjectileDispenseBehavior(){

                    @Override
                    protected ProjectileEntity func_82499_a(World world, IPosition iPosition, ItemStack itemStack) {
                        return Util.func_200696_a(new PotionEntity(world, iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c()), potionEntity -> potionEntity.func_213884_b(itemStack));
                    }

                    @Override
                    protected float func_82498_a() {
                        return super.func_82498_a() * 0.5f;
                    }

                    @Override
                    protected float func_82500_b() {
                        return super.func_82500_b() * 1.25f;
                    }
                }.dispense(iBlockSource, itemStack);
            }
        });
        DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior(){

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                Direction direction = iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a);
                EntityType<?> \u26032 = ((SpawnEggItem)itemStack.func_77973_b()).func_208076_b(itemStack.func_77978_p());
                \u26032.func_220331_a(iBlockSource.func_197524_h(), itemStack, null, iBlockSource.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                itemStack.func_190918_g(1);
                return itemStack;
            }
        };
        for (SpawnEggItem spawnEggItem : SpawnEggItem.func_195985_g()) {
            DispenserBlock.func_199774_a(spawnEggItem, defaultDispenseItemBehavior);
        }
        DispenserBlock.func_199774_a(Items.field_179565_cj, new DefaultDispenseItemBehavior(){

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                Direction direction = iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a);
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(direction);
                World \u26033 = iBlockSource.func_197524_h();
                ArmorStandEntity \u26034 = new ArmorStandEntity(\u26033, (double)\u26032.func_177958_n() + 0.5, \u26032.func_177956_o(), (double)\u26032.func_177952_p() + 0.5);
                EntityType.func_208048_a(\u26033, null, \u26034, itemStack.func_77978_p());
                \u26034.field_70177_z = direction.func_185119_l();
                \u26033.func_217376_c(\u26034);
                itemStack.func_190918_g(1);
                return itemStack;
            }
        });
        DispenserBlock.func_199774_a(Items.field_151141_av, new OptionalDispenseBehavior(){

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                BlockPos blockPos = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a));
                List<LivingEntity> \u26032 = iBlockSource.func_197524_h().func_175647_a(LivingEntity.class, new AxisAlignedBB(blockPos), livingEntity -> {
                    if (livingEntity instanceof IEquipable) {
                        IEquipable iEquipable = (IEquipable)((Object)livingEntity);
                        return !iEquipable.func_110257_ck() && iEquipable.func_230264_L__();
                    }
                    return false;
                });
                if (!\u26032.isEmpty()) {
                    ((IEquipable)((Object)\u26032.get(0))).func_230266_a_(SoundCategory.BLOCKS);
                    itemStack.func_190918_g(1);
                    this.func_239796_a_(true);
                    return itemStack;
                }
                return super.func_82487_b(iBlockSource, itemStack);
            }
        });
        OptionalDispenseBehavior optionalDispenseBehavior = new OptionalDispenseBehavior(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource2, ItemStack itemStack) {
                IBlockSource iBlockSource2;
                BlockPos blockPos = iBlockSource2.func_180699_d().func_177972_a(iBlockSource2.func_189992_e().func_177229_b(DispenserBlock.field_176441_a));
                List<AbstractHorseEntity> \u26032 = iBlockSource2.func_197524_h().func_175647_a(AbstractHorseEntity.class, new AxisAlignedBB(blockPos), abstractHorseEntity -> abstractHorseEntity.func_70089_S() && abstractHorseEntity.func_230276_fq_());
                for (AbstractHorseEntity abstractHorseEntity2 : \u26032) {
                    if (!abstractHorseEntity2.func_190682_f(itemStack) || abstractHorseEntity2.func_230277_fr_() || !abstractHorseEntity2.func_110248_bS()) continue;
                    abstractHorseEntity2.func_174820_d(401, itemStack.func_77979_a(1));
                    this.func_239796_a_(true);
                    return itemStack;
                }
                return super.func_82487_b(iBlockSource2, itemStack);
            }
        };
        DispenserBlock.func_199774_a(Items.field_222110_op, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_151138_bX, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_151136_bY, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_151125_bZ, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221809_eO, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221811_eP, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221827_eX, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221831_eZ, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221886_fa, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221892_fd, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221823_eV, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221888_fb, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221815_eR, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221825_eW, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221819_eT, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221813_eQ, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221821_eU, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221829_eY, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221890_fc, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221817_eS, optionalDispenseBehavior);
        DispenserBlock.func_199774_a(Items.field_221675_bZ, new OptionalDispenseBehavior(){

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource2, ItemStack itemStack) {
                IBlockSource iBlockSource2;
                BlockPos blockPos = iBlockSource2.func_180699_d().func_177972_a(iBlockSource2.func_189992_e().func_177229_b(DispenserBlock.field_176441_a));
                List<AbstractChestedHorseEntity> \u26032 = iBlockSource2.func_197524_h().func_175647_a(AbstractChestedHorseEntity.class, new AxisAlignedBB(blockPos), abstractChestedHorseEntity -> abstractChestedHorseEntity.func_70089_S() && !abstractChestedHorseEntity.func_190695_dh());
                for (AbstractChestedHorseEntity abstractChestedHorseEntity2 : \u26032) {
                    if (!abstractChestedHorseEntity2.func_110248_bS() || !abstractChestedHorseEntity2.func_174820_d(499, itemStack)) continue;
                    itemStack.func_190918_g(1);
                    this.func_239796_a_(true);
                    return itemStack;
                }
                return super.func_82487_b(iBlockSource2, itemStack);
            }
        });
        DispenserBlock.func_199774_a(Items.field_196152_dE, new DefaultDispenseItemBehavior(){

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                Direction direction = iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a);
                FireworkRocketEntity \u26032 = new FireworkRocketEntity(iBlockSource.func_197524_h(), itemStack, iBlockSource.func_82615_a(), iBlockSource.func_82617_b(), iBlockSource.func_82615_a(), true);
                IDispenseItemBehavior.func_239785_a_(iBlockSource, \u26032, direction);
                \u26032.func_70186_c(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e(), 0.5f, 1.0f);
                iBlockSource.func_197524_h().func_217376_c(\u26032);
                itemStack.func_190918_g(1);
                return itemStack;
            }

            @Override
            protected void func_82485_a(IBlockSource iBlockSource) {
                iBlockSource.func_197524_h().func_217379_c(1004, iBlockSource.func_180699_d(), 0);
            }
        });
        DispenserBlock.func_199774_a(Items.field_151059_bz, new DefaultDispenseItemBehavior(){

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                Direction direction = iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a);
                IPosition \u26032 = DispenserBlock.func_149939_a(iBlockSource);
                double \u26033 = \u26032.func_82615_a() + (double)((float)direction.func_82601_c() * 0.3f);
                double \u26034 = \u26032.func_82617_b() + (double)((float)direction.func_96559_d() * 0.3f);
                double \u26035 = \u26032.func_82616_c() + (double)((float)direction.func_82599_e() * 0.3f);
                World \u26036 = iBlockSource.func_197524_h();
                Random \u26037 = \u26036.field_73012_v;
                double \u26038 = \u26037.nextGaussian() * 0.05 + (double)direction.func_82601_c();
                double \u26039 = \u26037.nextGaussian() * 0.05 + (double)direction.func_96559_d();
                double \u260310 = \u26037.nextGaussian() * 0.05 + (double)direction.func_82599_e();
                \u26036.func_217376_c(Util.func_200696_a(new SmallFireballEntity(\u26036, \u26033, \u26034, \u26035, \u26038, \u26039, \u260310), smallFireballEntity -> smallFireballEntity.func_213898_b(itemStack)));
                itemStack.func_190918_g(1);
                return itemStack;
            }

            @Override
            protected void func_82485_a(IBlockSource iBlockSource) {
                iBlockSource.func_197524_h().func_217379_c(1018, iBlockSource.func_180699_d(), 0);
            }
        });
        DispenserBlock.func_199774_a(Items.field_151124_az, new DispenseBoatBehavior(BoatEntity.Type.OAK));
        DispenserBlock.func_199774_a(Items.field_185150_aH, new DispenseBoatBehavior(BoatEntity.Type.SPRUCE));
        DispenserBlock.func_199774_a(Items.field_185151_aI, new DispenseBoatBehavior(BoatEntity.Type.BIRCH));
        DispenserBlock.func_199774_a(Items.field_185152_aJ, new DispenseBoatBehavior(BoatEntity.Type.JUNGLE));
        DispenserBlock.func_199774_a(Items.field_185154_aL, new DispenseBoatBehavior(BoatEntity.Type.DARK_OAK));
        DispenserBlock.func_199774_a(Items.field_185153_aK, new DispenseBoatBehavior(BoatEntity.Type.ACACIA));
        DefaultDispenseItemBehavior defaultDispenseItemBehavior2 = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior field_239793_b_ = new DefaultDispenseItemBehavior();

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                BucketItem bucketItem = (BucketItem)itemStack.func_77973_b();
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a));
                World \u26033 = iBlockSource.func_197524_h();
                if (bucketItem.func_180616_a(null, \u26033, \u26032, null)) {
                    bucketItem.func_203792_a(\u26033, itemStack, \u26032);
                    return new ItemStack(Items.field_151133_ar);
                }
                return this.field_239793_b_.dispense(iBlockSource, itemStack);
            }
        };
        DispenserBlock.func_199774_a(Items.field_151129_at, defaultDispenseItemBehavior2);
        DispenserBlock.func_199774_a(Items.field_151131_as, defaultDispenseItemBehavior2);
        DispenserBlock.func_199774_a(Items.field_203796_aM, defaultDispenseItemBehavior2);
        DispenserBlock.func_199774_a(Items.field_203797_aN, defaultDispenseItemBehavior2);
        DispenserBlock.func_199774_a(Items.field_203795_aL, defaultDispenseItemBehavior2);
        DispenserBlock.func_199774_a(Items.field_204272_aO, defaultDispenseItemBehavior2);
        DispenserBlock.func_199774_a(Items.field_151133_ar, new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior field_239794_b_ = new DefaultDispenseItemBehavior();

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource2, ItemStack itemStack) {
                Fluid fluid;
                World world = iBlockSource2.func_197524_h();
                BlockState \u26032 = world.func_180495_p(\u2603 = iBlockSource2.func_180699_d().func_177972_a(iBlockSource2.func_189992_e().func_177229_b(DispenserBlock.field_176441_a)));
                Block \u26033 = \u26032.func_177230_c();
                if (\u26033 instanceof IBucketPickupHandler) {
                    fluid = ((IBucketPickupHandler)((Object)\u26033)).func_204508_a(world, \u2603, \u26032);
                    if (!(fluid instanceof FlowingFluid)) {
                        return super.func_82487_b(iBlockSource2, itemStack);
                    }
                } else {
                    IBlockSource iBlockSource2;
                    return super.func_82487_b(iBlockSource2, itemStack);
                }
                Item \u26034 = fluid.func_204524_b();
                itemStack.func_190918_g(1);
                if (itemStack.func_190926_b()) {
                    return new ItemStack(\u26034);
                }
                if (((DispenserTileEntity)iBlockSource2.func_150835_j()).func_146019_a(new ItemStack(\u26034)) < 0) {
                    this.field_239794_b_.dispense(iBlockSource2, new ItemStack(\u26034));
                }
                return itemStack;
            }
        });
        DispenserBlock.func_199774_a(Items.field_151033_d, new OptionalDispenseBehavior(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                World world = iBlockSource.func_197524_h();
                this.func_239796_a_(true);
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a));
                BlockState \u26033 = world.func_180495_p(\u26032);
                if (AbstractFireBlock.func_241465_a_(world, \u26032)) {
                    world.func_175656_a(\u26032, AbstractFireBlock.func_235326_a_(world, \u26032));
                } else if (CampfireBlock.func_241470_h_(\u26033)) {
                    world.func_175656_a(\u26032, (BlockState)\u26033.func_206870_a(BlockStateProperties.field_208190_q, true));
                } else if (\u26033.func_177230_c() instanceof TNTBlock) {
                    TNTBlock.func_196534_a(world, \u26032);
                    world.func_217377_a(\u26032, false);
                } else {
                    this.func_239796_a_(false);
                }
                if (this.func_239795_a_() && itemStack.func_96631_a(1, world.field_73012_v, null)) {
                    itemStack.func_190920_e(0);
                }
                return itemStack;
            }
        });
        DispenserBlock.func_199774_a(Items.field_196106_bc, new OptionalDispenseBehavior(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                this.func_239796_a_(true);
                World world = iBlockSource.func_197524_h();
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a));
                if (BoneMealItem.func_195966_a(itemStack, world, \u26032) || BoneMealItem.func_203173_b(itemStack, world, \u26032, null)) {
                    if (!world.field_72995_K) {
                        world.func_217379_c(2005, \u26032, 0);
                    }
                } else {
                    this.func_239796_a_(false);
                }
                return itemStack;
            }
        });
        DispenserBlock.func_199774_a(Blocks.field_150335_W, new DefaultDispenseItemBehavior(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                World world = iBlockSource.func_197524_h();
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a));
                TNTEntity \u26033 = new TNTEntity(world, (double)\u26032.func_177958_n() + 0.5, \u26032.func_177956_o(), (double)\u26032.func_177952_p() + 0.5, null);
                world.func_217376_c(\u26033);
                world.func_184148_a(null, \u26033.func_226277_ct_(), \u26033.func_226278_cu_(), \u26033.func_226281_cx_(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                itemStack.func_190918_g(1);
                return itemStack;
            }
        });
        OptionalDispenseBehavior optionalDispenseBehavior2 = new OptionalDispenseBehavior(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                this.func_239796_a_(ArmorItem.func_226626_a_(iBlockSource, itemStack));
                return itemStack;
            }
        };
        DispenserBlock.func_199774_a(Items.field_196185_dy, optionalDispenseBehavior2);
        DispenserBlock.func_199774_a(Items.field_196186_dz, optionalDispenseBehavior2);
        DispenserBlock.func_199774_a(Items.field_196151_dA, optionalDispenseBehavior2);
        DispenserBlock.func_199774_a(Items.field_196182_dv, optionalDispenseBehavior2);
        DispenserBlock.func_199774_a(Items.field_196184_dx, optionalDispenseBehavior2);
        DispenserBlock.func_199774_a(Items.field_196183_dw, new OptionalDispenseBehavior(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource2, ItemStack itemStack2) {
                ItemStack itemStack2;
                World world = iBlockSource2.func_197524_h();
                Direction \u26032 = iBlockSource2.func_189992_e().func_177229_b(DispenserBlock.field_176441_a);
                BlockPos \u26033 = iBlockSource2.func_180699_d().func_177972_a(\u26032);
                if (world.func_175623_d(\u26033) && WitherSkeletonSkullBlock.func_196299_b(world, \u26033, itemStack2)) {
                    world.func_180501_a(\u26033, (BlockState)Blocks.field_196705_eO.func_176223_P().func_206870_a(SkullBlock.field_196294_a, \u26032.func_176740_k() == Direction.Axis.Y ? 0 : \u26032.func_176734_d().func_176736_b() * 4), 3);
                    TileEntity tileEntity = world.func_175625_s(\u26033);
                    if (tileEntity instanceof SkullTileEntity) {
                        WitherSkeletonSkullBlock.func_196298_a(world, \u26033, (SkullTileEntity)tileEntity);
                    }
                    itemStack2.func_190918_g(1);
                    this.func_239796_a_(true);
                } else {
                    IBlockSource iBlockSource2;
                    this.func_239796_a_(ArmorItem.func_226626_a_(iBlockSource2, itemStack2));
                }
                return itemStack2;
            }
        });
        DispenserBlock.func_199774_a(Blocks.field_196625_cS, new OptionalDispenseBehavior(){

            @Override
            protected ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                World world = iBlockSource.func_197524_h();
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a));
                CarvedPumpkinBlock \u26033 = (CarvedPumpkinBlock)Blocks.field_196625_cS;
                if (world.func_175623_d(\u26032) && \u26033.func_196354_a(world, \u26032)) {
                    if (!world.field_72995_K) {
                        world.func_180501_a(\u26032, \u26033.func_176223_P(), 3);
                    }
                    itemStack.func_190918_g(1);
                    this.func_239796_a_(true);
                } else {
                    this.func_239796_a_(ArmorItem.func_226626_a_(iBlockSource, itemStack));
                }
                return itemStack;
            }
        });
        DispenserBlock.func_199774_a(Blocks.field_204409_il.func_199767_j(), new ShulkerBoxDispenseBehavior());
        for (DyeColor dyeColor : DyeColor.values()) {
            DispenserBlock.func_199774_a(ShulkerBoxBlock.func_190952_a(dyeColor).func_199767_j(), new ShulkerBoxDispenseBehavior());
        }
        DispenserBlock.func_199774_a(Items.field_151069_bo.func_199767_j(), new OptionalDispenseBehavior(){
            private final DefaultDispenseItemBehavior field_229423_c_ = new DefaultDispenseItemBehavior();

            private ItemStack func_229424_a_(IBlockSource iBlockSource, ItemStack itemStack, ItemStack itemStack2) {
                itemStack.func_190918_g(1);
                if (itemStack.func_190926_b()) {
                    return itemStack2.func_77946_l();
                }
                if (((DispenserTileEntity)iBlockSource.func_150835_j()).func_146019_a(itemStack2.func_77946_l()) < 0) {
                    this.field_229423_c_.dispense(iBlockSource, itemStack2.func_77946_l());
                }
                return itemStack;
            }

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                this.func_239796_a_(false);
                World world = iBlockSource.func_197524_h();
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a));
                BlockState \u26033 = world.func_180495_p(\u26032);
                if (\u26033.func_235715_a_(BlockTags.field_226151_aa_, abstractBlockState -> abstractBlockState.func_235901_b_(BeehiveBlock.field_226873_c_)) && \u26033.func_177229_b(BeehiveBlock.field_226873_c_) >= 5) {
                    ((BeehiveBlock)\u26033.func_177230_c()).func_226877_a_(world.func_201672_e(), \u26033, \u26032, null, BeehiveTileEntity.State.BEE_RELEASED);
                    this.func_239796_a_(true);
                    return this.func_229424_a_(iBlockSource, itemStack, new ItemStack(Items.field_226638_pX_));
                }
                if (world.func_204610_c(\u26032).func_206884_a(FluidTags.field_206959_a)) {
                    this.func_239796_a_(true);
                    return this.func_229424_a_(iBlockSource, itemStack, PotionUtils.func_185188_a(new ItemStack(Items.field_151068_bn), Potions.field_185230_b));
                }
                return super.func_82487_b(iBlockSource, itemStack);
            }
        });
        DispenserBlock.func_199774_a(Items.field_221695_cJ, new OptionalDispenseBehavior(){

            @Override
            public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack itemStack) {
                Direction direction = iBlockSource.func_189992_e().func_177229_b(DispenserBlock.field_176441_a);
                BlockPos \u26032 = iBlockSource.func_180699_d().func_177972_a(direction);
                World \u26033 = iBlockSource.func_197524_h();
                BlockState \u26034 = \u26033.func_180495_p(\u26032);
                this.func_239796_a_(true);
                if (\u26034.func_203425_a(Blocks.field_235400_nj_)) {
                    if (\u26034.func_177229_b(RespawnAnchorBlock.field_235559_a_) != 4) {
                        RespawnAnchorBlock.func_235564_a_(\u26033, \u26032, \u26034);
                        itemStack.func_190918_g(1);
                    } else {
                        this.func_239796_a_(false);
                    }
                    return itemStack;
                }
                return super.func_82487_b(iBlockSource, itemStack);
            }
        });
        DispenserBlock.func_199774_a(Items.field_151097_aZ.func_199767_j(), new BeehiveDispenseBehavior());
    }

    public static void func_239785_a_(IBlockSource iBlockSource, Entity entity, Direction direction) {
        entity.func_70107_b(iBlockSource.func_82615_a() + (double)direction.func_82601_c() * (0.5000099999997474 - (double)entity.func_213311_cf() / 2.0), iBlockSource.func_82617_b() + (double)direction.func_96559_d() * (0.5000099999997474 - (double)entity.func_213302_cg() / 2.0) - (double)entity.func_213302_cg() / 2.0, iBlockSource.func_82616_c() + (double)direction.func_82599_e() * (0.5000099999997474 - (double)entity.func_213311_cf() / 2.0));
    }
}

