/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TranslationTextComponent;

public class ScoreHolderArgument
implements ArgumentType<INameProvider> {
    public static final SuggestionProvider<CommandSource> field_201326_a = (commandContext, suggestionsBuilder2) -> {
        StringReader stringReader = new StringReader(suggestionsBuilder2.getInput());
        stringReader.setCursor(suggestionsBuilder2.getStart());
        EntitySelectorParser \u26032 = new EntitySelectorParser(stringReader);
        try {
            \u26032.func_201345_m();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return \u26032.func_201993_a(suggestionsBuilder2, suggestionsBuilder -> ISuggestionProvider.func_197005_b(((CommandSource)commandContext.getSource()).func_197011_j(), suggestionsBuilder));
    };
    private static final Collection<String> field_201327_b = Arrays.asList("Player", "0123", "*", "@e");
    private static final SimpleCommandExceptionType field_197215_a = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.scoreHolder.empty"));
    private final boolean field_197216_b;

    public ScoreHolderArgument(boolean bl) {
        this.field_197216_b = bl;
    }

    public static String func_197211_a(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return ScoreHolderArgument.func_197213_b(commandContext, string).iterator().next();
    }

    public static Collection<String> func_197213_b(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return ScoreHolderArgument.func_197210_a(commandContext, string, Collections::emptyList);
    }

    public static Collection<String> func_211707_c(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return ScoreHolderArgument.func_197210_a(commandContext, string, ((CommandSource)commandContext.getSource()).func_197028_i().func_200251_aP()::func_96526_d);
    }

    public static Collection<String> func_197210_a(CommandContext<CommandSource> commandContext, String string, Supplier<Collection<String>> supplier) throws CommandSyntaxException {
        Collection<String> collection = ((INameProvider)commandContext.getArgument(string, INameProvider.class)).getNames((CommandSource)commandContext.getSource(), supplier);
        if (collection.isEmpty()) {
            throw EntityArgument.field_197101_d.create();
        }
        return collection;
    }

    public static ScoreHolderArgument func_197209_a() {
        return new ScoreHolderArgument(false);
    }

    public static ScoreHolderArgument func_197214_b() {
        return new ScoreHolderArgument(true);
    }

    public INameProvider parse(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead() && stringReader.peek() == '@') {
            EntitySelectorParser entitySelectorParser = new EntitySelectorParser(stringReader);
            EntitySelector \u26032 = entitySelectorParser.func_201345_m();
            if (!this.field_197216_b && \u26032.func_197346_a() > 1) {
                throw EntityArgument.field_197098_a.create();
            }
            return new NameProvider(\u26032);
        }
        int n = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        String \u26033 = stringReader.getString().substring(n, stringReader.getCursor());
        if (\u26033.equals("*")) {
            return (commandSource, supplier) -> {
                Collection collection = (Collection)supplier.get();
                if (collection.isEmpty()) {
                    throw field_197215_a.create();
                }
                return collection;
            };
        }
        Set<String> \u26034 = Collections.singleton(\u26033);
        return (commandSource, supplier) -> \u26034;
    }

    public Collection<String> getExamples() {
        return field_201327_b;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class Serializer
    implements IArgumentSerializer<ScoreHolderArgument> {
        @Override
        public void func_197072_a(ScoreHolderArgument scoreHolderArgument, PacketBuffer packetBuffer) {
            int n = 0;
            if (scoreHolderArgument.field_197216_b) {
                n = (byte)(n | 1);
            }
            packetBuffer.writeByte(n);
        }

        @Override
        public ScoreHolderArgument func_197071_b(PacketBuffer packetBuffer) {
            byte by = packetBuffer.readByte();
            boolean \u26032 = (by & 1) != 0;
            return new ScoreHolderArgument(\u26032);
        }

        @Override
        public void func_212244_a(ScoreHolderArgument scoreHolderArgument, JsonObject jsonObject) {
            jsonObject.addProperty("amount", scoreHolderArgument.field_197216_b ? "multiple" : "single");
        }

        @Override
        public /* synthetic */ ArgumentType func_197071_b(PacketBuffer packetBuffer) {
            return this.func_197071_b(packetBuffer);
        }
    }

    public static class NameProvider
    implements INameProvider {
        private final EntitySelector field_197205_a;

        public NameProvider(EntitySelector entitySelector) {
            this.field_197205_a = entitySelector;
        }

        @Override
        public Collection<String> getNames(CommandSource commandSource, Supplier<Collection<String>> supplier) throws CommandSyntaxException {
            List<? extends Entity> list = this.field_197205_a.func_197341_b(commandSource);
            if (list.isEmpty()) {
                throw EntityArgument.field_197101_d.create();
            }
            ArrayList \u26032 = Lists.newArrayList();
            for (Entity entity : list) {
                \u26032.add(entity.func_195047_I_());
            }
            return \u26032;
        }
    }

    @FunctionalInterface
    public static interface INameProvider {
        public Collection<String> getNames(CommandSource var1, Supplier<Collection<String>> var2) throws CommandSyntaxException;
    }
}

